/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.perf.DebugCloseable;
import com.oracle.truffle.espresso.perf.DebugTimer;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoExitException;
import com.oracle.truffle.espresso.runtime.EspressoReferenceDrainer;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.threads.EspressoThreadRegistry;
import com.oracle.truffle.espresso.threads.ThreadsAccess;
import java.util.Iterator;
import java.util.function.Consumer;

final class EspressoShutdownHandler
extends ContextAccessImpl {
    private static final DebugTimer SHUTDOWN_TIMER = DebugTimer.create("shutdown");
    private final EspressoThreadRegistry threadManager;
    private final EspressoReferenceDrainer referenceDrainer;
    private final boolean softExit;
    private static final long MAX_KILL_PHASE_WAIT = 100L;
    private volatile boolean isClosing = false;
    private volatile int exitStatus = -1;
    private final EspressoLock shutdownSynchronizer;

    EspressoShutdownHandler(EspressoContext context, EspressoThreadRegistry threadManager, EspressoReferenceDrainer referenceDrainer, boolean softExit) {
        super(context);
        this.threadManager = threadManager;
        this.referenceDrainer = referenceDrainer;
        this.softExit = softExit;
        this.shutdownSynchronizer = EspressoLock.create(context.getBlockingSupport());
    }

    boolean isClosing() {
        return this.isClosing;
    }

    int getExitStatus() {
        assert (this.isClosing());
        if (this.isExitStatusUninit()) {
            return 0;
        }
        return this.exitStatus;
    }

    private boolean isExitStatusUninit() {
        return !this.isClosing;
    }

    private void beginClose(int code) {
        assert (this.getShutdownSynchronizer().isHeldByCurrentThread());
        this.isClosing = true;
        this.exitStatus = code;
        this.getContext().getLogger().finer(() -> "Starting close process with code=" + code);
    }

    EspressoLock getShutdownSynchronizer() {
        return this.shutdownSynchronizer;
    }

    @CompilerDirectives.TruffleBoundary
    void doExit(int code) {
        if (!this.getContext().isInitialized()) {
            return;
        }
        this.getContext().getLogger().fine(() -> {
            StaticObject currentThread = this.getContext().getCurrentPlatformThread();
            String guestName = this.getThreadAccess().getThreadName(currentThread);
            return "doExit(" + code + ") from " + guestName;
        });
        this.closeAndTeardown(code, true);
    }

    @CompilerDirectives.TruffleBoundary
    void destroyVM() {
        this.waitForClose();
        try {
            this.getMeta().java_lang_Shutdown_shutdown.invokeDirect(null, new Object[0]);
        }
        catch (AbstractTruffleException abstractTruffleException) {
            // empty catch block
        }
        this.closeAndTeardown(0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndTeardown(int code, boolean notifyNaturalExit) {
        if (this.isClosing()) {
            return;
        }
        EspressoLock sync = this.getShutdownSynchronizer();
        sync.lock();
        try {
            if (this.isClosing()) {
                return;
            }
            this.beginClose(code);
            if (notifyNaturalExit) {
                sync.signalAll();
            }
        }
        finally {
            sync.unlock();
        }
        this.teardown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForClose() throws EspressoExitException {
        EspressoLock synchronizer = this.getShutdownSynchronizer();
        Thread initiating = Thread.currentThread();
        this.getContext().getLogger().fine("Waiting for non-daemon threads to finish or exit");
        synchronizer.lock();
        try {
            while (true) {
                if (this.isClosing()) {
                    return;
                }
                if (!this.hasActiveNonDaemon(initiating)) break;
                try {
                    synchronizer.await(0L);
                }
                catch (GuestInterruptedException guestInterruptedException) {}
            }
            return;
        }
        finally {
            synchronizer.unlock();
        }
    }

    private boolean hasActiveNonDaemon(Thread initiating) {
        for (StaticObject guest : this.getManagedThreads()) {
            Thread host = this.getThreadAccess().getHost(guest);
            if (host == initiating || host.isDaemon() || !host.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void ensureThreadsJoined() {
        this.ensureThreadsJoined(Thread.currentThread(), 0L);
    }

    private boolean ensureThreadsJoined(Thread initiatingThread, long maxWaitMillis) {
        this.getContext().getLogger().finer("Teardown: Phase 3: Force kill with host EspressoExitExceptions");
        this.teardownPhase3(initiatingThread);
        boolean success = this.joinThreads(initiatingThread, true, maxWaitMillis);
        this.referenceDrainer.shutdownAndWaitReferenceDrain();
        if (!success) {
            this.getContext().getLogger().severe("Could not gracefully stop executing threads in context closing.");
            this.getContext().getLogger().severe(() -> {
                StringBuilder str = new StringBuilder("Threads still alive: ");
                for (StaticObject guest : this.getManagedThreads()) {
                    str.append(this.getThreadAccess().getHost(guest));
                }
                return str.toString();
            });
        }
        return success;
    }

    private void teardown() {
        assert (this.isClosing());
        try (DebugCloseable shutdown = SHUTDOWN_TIMER.scope(this.getContext().getTimers());){
            boolean allowHostExit;
            boolean nextPhase;
            this.getVM().getJvmti().postVmDeath();
            this.getContext().prepareDispose();
            Thread initiatingThread = Thread.currentThread();
            this.getContext().getLogger().finer("Teardown: Phase 0: wait");
            boolean bl = nextPhase = !this.joinNonDaemonThreads(initiatingThread);
            if (this.softExit) {
                if (nextPhase) {
                    this.getContext().getLogger().finer("Teardown: Phase 1: Interrupt threads.");
                    this.teardownPhase1(initiatingThread);
                    boolean bl2 = nextPhase = !this.joinNonDaemonThreads(initiatingThread);
                }
                if (nextPhase) {
                    this.getContext().getLogger().finer("Teardown: Phase 2: Stop all threads.");
                    this.teardownPhase2(initiatingThread);
                    nextPhase = !this.joinNonDaemonThreads(initiatingThread);
                }
            }
            if (!this.ensureThreadsJoined(initiatingThread, (allowHostExit = this.getContext().getEspressoEnv().AllowHostExit) ? 100L : 0L) && allowHostExit) {
                this.getContext().getLogger().severe("Calling Host System.exit()...");
                System.exit(this.getExitStatus());
            }
        }
        this.getContext().getTimers().report(this.getContext().getLogger());
    }

    private void teardownPhase1(Thread initiatingThread) {
        this.teardownLoop(this.getThreadAccess()::callInterrupt, initiatingThread);
    }

    private void teardownPhase2(Thread initiatingThread) {
        this.teardownLoop(this.getThreadAccess()::stop, initiatingThread);
    }

    private void teardownPhase3(Thread initiatingThread) {
        this.teardownLoop(this.getThreadAccess()::kill, initiatingThread);
    }

    private void teardownLoop(Consumer<StaticObject> action, Thread initiatingThread) {
        for (StaticObject guest : this.getManagedThreads()) {
            Thread t = this.getThreadAccess().getHost(guest);
            if (!t.isAlive() || t == initiatingThread) continue;
            action.accept(guest);
        }
    }

    private boolean joinNonDaemonThreads(Thread initiatingThread) {
        return this.joinThreads(initiatingThread, false, 100L);
    }

    private boolean joinThreads(Thread initiatingThread, boolean waitForDaemon, long maxWaitMillis) {
        for (StaticObject guest : this.getManagedThreads()) {
            Thread t = this.getThreadAccess().getHost(guest);
            if (!waitForDaemon && t.isDaemon() || t == initiatingThread || t == this.referenceDrainer.drainHostThread() || !t.isAlive()) continue;
            TruffleSafepoint.setBlockedThreadInterruptible(null, o -> t.join(maxWaitMillis), null);
            if (!t.isAlive()) continue;
            return false;
        }
        return true;
    }

    private Iterable<StaticObject> getManagedThreads() {
        return new ManagedThreadsIterable(this.threadManager.activeThreads(), this.getThreadAccess());
    }

    private static class ManagedThreadsIterable
    implements Iterable<StaticObject> {
        private final StaticObject[] thrds;
        private final ThreadsAccess access;

        ManagedThreadsIterable(StaticObject[] thrds, ThreadsAccess access) {
            this.thrds = thrds;
            this.access = access;
        }

        @Override
        public Iterator<StaticObject> iterator() {
            return new ManagedThreadsIterator(this.thrds, this.access);
        }
    }

    private static class ManagedThreadsIterator
    implements Iterator<StaticObject> {
        private final ThreadsAccess access;
        private final StaticObject[] thrds;
        int pos;

        ManagedThreadsIterator(StaticObject[] thrds, ThreadsAccess access) {
            this.thrds = thrds;
            this.access = access;
            this.pos = -1;
            this.consume();
        }

        @Override
        public boolean hasNext() {
            return this.hasElement() && this.currentIsManaged();
        }

        @Override
        public StaticObject next() {
            StaticObject res = this.thrds[this.pos];
            this.consume();
            return res;
        }

        private void consume() {
            ++this.pos;
            while (this.hasElement() && !this.currentIsManaged()) {
                ++this.pos;
            }
        }

        private boolean currentIsManaged() {
            if (!this.hasElement()) {
                return false;
            }
            return this.access.isManaged(this.thrds[this.pos]);
        }

        private boolean hasElement() {
            return this.pos >= 0 && this.pos < this.thrds.length;
        }
    }
}

