/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.BootClassPathType;
import com.oracle.truffle.espresso.runtime.DarwinBuilder;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.LinuxBuilder;
import com.oracle.truffle.espresso.runtime.OS;
import com.oracle.truffle.espresso.runtime.WindowsBuilder;
import com.oracle.truffle.espresso.substitutions.ModuleExtension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.graalvm.options.OptionValues;

public interface EspressoProperties {
    public static final String BOOT_MODULES_NAME = "modules";

    public Path espressoLibs();

    public BootClassPathType bootClassPathType();

    public Path javaHome();

    public List<Path> jvmLibraryPath();

    public List<Path> classpath();

    public List<Path> bootClasspath();

    public List<Path> javaLibraryPath();

    public List<Path> bootLibraryPath();

    public List<Path> extDirs();

    public static Builder processOptions(Builder builder, OptionValues options, EspressoContext context) {
        Path javaHome = options.hasBeenSet(EspressoOptions.JavaHome) ? (Path)options.get(EspressoOptions.JavaHome) : builder.javaHome();
        Path java8Home = javaHome.resolve("jre");
        if (Files.isDirectory(java8Home, new LinkOption[0])) {
            javaHome = java8Home;
        }
        builder.javaHome(javaHome);
        if (options.hasBeenSet(EspressoOptions.JVMLibraryPath)) {
            builder.jvmLibraryPath((List)options.get(EspressoOptions.JVMLibraryPath));
        }
        if (options.hasBeenSet(EspressoOptions.Classpath)) {
            builder.classpath((List)options.get(EspressoOptions.Classpath));
        }
        ArrayList<Path> bootClasspath = new ArrayList<Path>(builder.bootClasspath());
        if (options.hasBeenSet(EspressoOptions.BootClasspath)) {
            bootClasspath = new ArrayList((Collection)options.get(EspressoOptions.BootClasspath));
        }
        Path espressoLibs = context.getEspressoLibs();
        for (ModuleExtension me : ModuleExtension.get(context)) {
            Path jarPath = espressoLibs.resolve(me.jarName());
            if (Files.isReadable(jarPath)) {
                TruffleLogger.getLogger((String)"java").fine("Adding " + me.jarName() + " to the boot classpath");
                bootClasspath.add(jarPath);
                continue;
            }
            TruffleLogger.getLogger((String)"java").warning(jarPath + " not found at " + espressoLibs);
        }
        if (options.hasBeenSet(EspressoOptions.BootClasspathAppend)) {
            bootClasspath.addAll((Collection)options.get(EspressoOptions.BootClasspathAppend));
        }
        if (options.hasBeenSet(EspressoOptions.BootClasspathPrepend)) {
            bootClasspath.addAll(0, (Collection)options.get(EspressoOptions.BootClasspathPrepend));
        }
        builder.bootClasspath(bootClasspath);
        if (options.hasBeenSet(EspressoOptions.BootLibraryPath)) {
            builder.bootLibraryPath((List)options.get(EspressoOptions.BootLibraryPath));
        }
        if (options.hasBeenSet(EspressoOptions.JavaLibraryPath)) {
            builder.javaLibraryPath((List)options.get(EspressoOptions.JavaLibraryPath));
        }
        if (options.hasBeenSet(EspressoOptions.ExtDirs)) {
            builder.extDirs((List)options.get(EspressoOptions.ExtDirs));
        }
        return builder;
    }

    public static Builder newPlatformBuilder(Path espressoLibs) {
        OS os = OS.getCurrent();
        switch (os) {
            case Linux: {
                return new LinuxBuilder(espressoLibs);
            }
            case Darwin: {
                return new DarwinBuilder(espressoLibs);
            }
            case Windows: {
                return new WindowsBuilder(espressoLibs);
            }
        }
        throw EspressoError.shouldNotReachHere(os + " not supported");
    }

    public static abstract class Builder {
        private final Path espressoLibs;
        private BootClassPathType version;
        private Path javaHome;
        private List<Path> jvmLibraryPath;
        private List<Path> classpath;
        private List<Path> bootClasspath;
        private List<Path> javaLibraryPath;
        private List<Path> bootLibraryPath;
        private List<Path> extDirs;

        protected Builder(Path espressoLibs) {
            this.espressoLibs = espressoLibs;
        }

        abstract Path defaultJavaHome();

        abstract List<Path> defaultJvmLibraryPath();

        abstract List<Path> defaultClasspath();

        abstract List<Path> defaultBootClasspath();

        abstract List<Path> defaultJavaLibraryPath();

        abstract List<Path> defaultBootLibraryPath();

        abstract List<Path> defaultExtDirs();

        public Path espressoLibs() {
            return this.espressoLibs;
        }

        public BootClassPathType bootClassPathVersion() {
            return this.version;
        }

        public Builder bootClassPathVersion(BootClassPathType bootClasspathVersion) {
            this.version = bootClasspathVersion;
            return this;
        }

        public Builder javaHome(Path newJavaHome) {
            this.javaHome = newJavaHome;
            return this;
        }

        public Path javaHome() {
            return this.javaHome != null ? this.javaHome : this.defaultJavaHome();
        }

        public Builder bootClasspath(List<Path> newBootClasspath) {
            this.bootClasspath = newBootClasspath;
            return this;
        }

        public List<Path> bootClasspath() {
            return this.bootClasspath != null ? this.bootClasspath : this.defaultBootClasspath();
        }

        public Builder classpath(List<Path> newClasspath) {
            this.classpath = newClasspath;
            return this;
        }

        public List<Path> classpath() {
            return this.classpath != null ? this.classpath : this.defaultClasspath();
        }

        public Builder javaLibraryPath(List<Path> newJavaLibraryPath) {
            this.javaLibraryPath = newJavaLibraryPath;
            return this;
        }

        public List<Path> javaLibraryPath() {
            return this.javaLibraryPath != null ? this.javaLibraryPath : this.defaultJavaLibraryPath();
        }

        public Builder bootLibraryPath(List<Path> newBootLibraryPath) {
            this.bootLibraryPath = newBootLibraryPath;
            return this;
        }

        public List<Path> bootLibraryPath() {
            return this.bootLibraryPath != null ? this.bootLibraryPath : this.defaultBootLibraryPath();
        }

        public Builder extDirs(List<Path> newExtDirs) {
            this.extDirs = newExtDirs;
            return this;
        }

        public List<Path> extDirs() {
            return this.extDirs != null ? this.extDirs : this.defaultExtDirs();
        }

        public List<Path> jvmLibraryPath() {
            return this.jvmLibraryPath != null ? this.jvmLibraryPath : this.defaultJvmLibraryPath();
        }

        public Builder jvmLibraryPath(List<Path> newJvmLibraryPath) {
            this.jvmLibraryPath = newJvmLibraryPath;
            return this;
        }

        public EspressoProperties build() {
            return new EspressoProperties(){
                private final Path espressoLibs;
                private final BootClassPathType javaVersion;
                private final Path javaHome;
                private final List<Path> classpath;
                private final List<Path> bootClasspath;
                private final List<Path> javaLibraryPath;
                private final List<Path> bootLibraryPath;
                private final List<Path> extDirs;
                private final List<Path> jvmLibraryPath;
                {
                    this.espressoLibs = espressoLibs;
                    this.javaVersion = this.bootClassPathVersion();
                    this.javaHome = Objects.requireNonNull(this.javaHome(), "javaHome not defined");
                    this.classpath = Objects.requireNonNull(this.classpath(), "classpath not defined");
                    this.bootClasspath = Objects.requireNonNull(this.bootClasspath(), "bootClasspath not defined");
                    this.javaLibraryPath = Objects.requireNonNull(this.javaLibraryPath(), "javaLibraryPath not defined");
                    this.bootLibraryPath = Objects.requireNonNull(this.bootLibraryPath(), "bootLibraryPath not defined");
                    this.extDirs = Objects.requireNonNull(this.extDirs(), "extDirs not defined");
                    this.jvmLibraryPath = Objects.requireNonNull(this.jvmLibraryPath(), "jvmLibraryPath not defined");
                }

                @Override
                public Path espressoLibs() {
                    return this.espressoLibs;
                }

                @Override
                public BootClassPathType bootClassPathType() {
                    return this.javaVersion;
                }

                @Override
                public Path javaHome() {
                    return this.javaHome;
                }

                @Override
                public List<Path> jvmLibraryPath() {
                    return this.jvmLibraryPath;
                }

                @Override
                public List<Path> classpath() {
                    return this.classpath;
                }

                @Override
                public List<Path> bootClasspath() {
                    return this.bootClasspath;
                }

                @Override
                public List<Path> javaLibraryPath() {
                    return this.javaLibraryPath;
                }

                @Override
                public List<Path> bootLibraryPath() {
                    return this.bootLibraryPath;
                }

                @Override
                public List<Path> extDirs() {
                    return this.extDirs;
                }
            };
        }
    }
}

