/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.redefinition.ClassInfo;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class ImmutableClassInfo
extends ClassInfo {
    private final Symbol<Symbol.Name> name;
    private final WeakReference<ObjectKlass> klass;
    private final StaticObject classLoader;
    private final byte[] bytes;
    private final String classFingerprint;
    private final String methodFingerprint;
    private final String fieldFingerprint;
    private final String enclosingMethodFingerprint;
    private final ArrayList<ImmutableClassInfo> innerClasses;

    ImmutableClassInfo(ObjectKlass klass, Symbol<Symbol.Name> originalName, StaticObject classLoader, String classFingerprint, String methodFingerprint, String fieldFingerprint, String enclosingMethodFingerprint, ArrayList<ImmutableClassInfo> inners, byte[] bytes, boolean isEnumSwitchmaphelper, boolean isInnerTestKlass) {
        super(isEnumSwitchmaphelper, isInnerTestKlass);
        this.klass = new WeakReference<ObjectKlass>(klass);
        this.name = originalName;
        this.classLoader = classLoader;
        this.classFingerprint = classFingerprint;
        this.methodFingerprint = methodFingerprint;
        this.fieldFingerprint = fieldFingerprint;
        this.enclosingMethodFingerprint = enclosingMethodFingerprint;
        this.innerClasses = inners;
        this.bytes = bytes;
    }

    @Override
    public Symbol<Symbol.Name> getName() {
        return this.name;
    }

    @Override
    public ObjectKlass getKlass() {
        return (ObjectKlass)this.klass.get();
    }

    @Override
    public StaticObject getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getClassFingerprint() {
        return this.classFingerprint;
    }

    @Override
    public String getMethodFingerprint() {
        return this.methodFingerprint;
    }

    @Override
    public String getFieldFingerprint() {
        return this.fieldFingerprint;
    }

    @Override
    public String getEnclosingMethodFingerprint() {
        return this.enclosingMethodFingerprint;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public ArrayList<? extends ClassInfo> getInnerClasses() {
        return this.innerClasses;
    }

    public ArrayList<ImmutableClassInfo> getImmutableInnerClasses() {
        return this.innerClasses;
    }
}

