/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.preinit;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.ContextDescription;
import com.oracle.truffle.espresso.impl.LinkedKlass;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.preinit.AbstractCachedKlassProvider;
import com.oracle.truffle.espresso.preinit.LinkedKlassProvider;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class CachedLinkedKlassProvider
extends AbstractCachedKlassProvider
implements LinkedKlassProvider {
    private final LinkedKlassProvider fallbackProvider;
    private final Map<LinkedKlassCacheKey, LinkedKlass> linkedKlassCache = new ConcurrentHashMap<LinkedKlassCacheKey, LinkedKlass>();

    public CachedLinkedKlassProvider(TruffleLogger logger, LinkedKlassProvider fallbackProvider) {
        super(logger);
        this.fallbackProvider = fallbackProvider;
    }

    @Override
    public LinkedKlass getLinkedKlass(ClassLoadingEnv env, ContextDescription description, StaticObject loader, ParserKlass parserKlass, LinkedKlass superKlass, LinkedKlass[] interfaces, ClassRegistry.ClassDefinitionInfo info) {
        if (env.shouldCacheClass(info, loader)) {
            LinkedKlassCacheKey key = new LinkedKlassCacheKey(parserKlass, superKlass, interfaces);
            LinkedKlass linkedKlass = this.linkedKlassCache.get(key);
            if (linkedKlass == null) {
                this.getLogger().finer(() -> "LinkedKlass cache miss: " + parserKlass.getName());
                linkedKlass = this.fallbackProvider.getLinkedKlass(env, description, loader, parserKlass, superKlass, interfaces, info);
                this.linkedKlassCache.put(key, linkedKlass);
            } else {
                this.getLogger().finer(() -> "LinkedKlass cache hit: " + parserKlass.getName());
            }
            return linkedKlass;
        }
        return this.fallbackProvider.getLinkedKlass(env, description, loader, parserKlass, superKlass, interfaces, info);
    }

    @Override
    public int getCachedLinkedKlassCount() {
        return this.linkedKlassCache.size();
    }

    private static final class LinkedKlassCacheKey {
        private final ParserKlass parserKlass;
        private final LinkedKlass superKlass;
        private final LinkedKlass[] interfaces;
        private final int hash;

        LinkedKlassCacheKey(ParserKlass parserKlass, LinkedKlass superKlass, LinkedKlass[] interfaces) {
            this.parserKlass = parserKlass;
            this.superKlass = superKlass;
            this.interfaces = interfaces;
            this.hash = 31 * Objects.hash(parserKlass, superKlass) + Arrays.hashCode(interfaces);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LinkedKlassCacheKey linkedKey = (LinkedKlassCacheKey)o;
            return this.parserKlass.equals(linkedKey.parserKlass) && Objects.equals(this.superKlass, linkedKey.superKlass) && Arrays.equals(this.interfaces, linkedKey.interfaces);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

