/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractGetFieldNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedFrameAccess;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies.InlinedFieldAccessNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

class InlinedGetterNode
extends InlinedFieldAccessNode {
    @Node.Child
    AbstractGetFieldNode getFieldNode;

    InlinedGetterNode(Method.MethodVersion method, char fieldCpi) {
        super(method, fieldCpi);
        this.getFieldNode = AbstractGetFieldNode.create(this.field);
    }

    @Override
    public void execute(VirtualFrame frame, InlinedFrameAccess frameAccess) {
        assert (!this.field.needsReResolution());
        StaticObject receiver = InlinedGetterNode.getReceiver(frame, this.field, frameAccess.top());
        this.getFieldNode.getField(frame, frameAccess.getBytecodeNode(), receiver, frameAccess.resultAt(), frameAccess.statementIndex());
    }

    private static StaticObject getReceiver(VirtualFrame frame, Field field, int top) {
        return field.isStatic() ? field.getDeclaringKlass().tryInitializeAndGetStatics() : EspressoFrame.popObject((Frame)frame, top - 1);
    }
}

