/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodPredicate;

public final class GuardedInlinedMethodNode
extends InlinedMethodNode {
    private final InlinedMethodPredicate guard;

    public GuardedInlinedMethodNode(Method inlinedMethod, int top, int opcode, int callerBCI, int statementIndex, InlinedMethodNode.BodyNode body, InlinedMethodPredicate guard) {
        this(inlinedMethod.getMethodVersion(), top, opcode, callerBCI, statementIndex, body, guard);
    }

    public GuardedInlinedMethodNode(Method.MethodVersion inlinedMethod, int top, int opcode, int callerBCI, int statementIndex, InlinedMethodNode.BodyNode body, InlinedMethodPredicate guard) {
        super(inlinedMethod, top, opcode, callerBCI, statementIndex, body);
        this.guard = guard;
    }

    @Override
    public int execute(VirtualFrame frame) {
        this.preludeChecks(frame);
        if (this.guard.isValid(this.getContext(), this.method, frame, this)) {
            return this.executeBody(frame);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.getBytecodeNode().reQuickenInvoke(frame, this.top, this.opcode, this.getCallerBCI(), this.statementIndex, this.method.getMethod());
    }
}

