/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.bytecodes.ReferenceArrayLoad;
import com.oracle.truffle.espresso.nodes.bytecodes.ReferenceArrayLoadNodeGen;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class ReferenceArrayLoadQuickNode
extends QuickNode {
    static final int stackEffectOf_AALOAD = Bytecodes.stackEffectOf(50);
    @Node.Child
    ReferenceArrayLoad.WithoutNullCheck objectArrayLoad = ReferenceArrayLoadNodeGen.WithoutNullCheckNodeGen.create();

    public ReferenceArrayLoadQuickNode(int top, int callerBCI) {
        super(top, callerBCI);
    }

    @Override
    public int execute(VirtualFrame frame) {
        int index = EspressoFrame.popInt((Frame)frame, this.top - 1);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, this.top - 2));
        StaticObject result = this.objectArrayLoad.execute(array, index);
        this.getBytecodeNode().checkNoForeignObjectAssumption(result);
        EspressoFrame.putObject((Frame)frame, this.top - 2, result);
        return stackEffectOf_AALOAD;
    }
}

