/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.bytecodes.IntArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.IntArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class IntArrayStoreQuickNode
extends QuickNode {
    static final int stackEffectOf_IASTORE = Bytecodes.stackEffectOf(79);
    @Node.Child
    IntArrayStore.WithoutNullCheck intArrayStore = IntArrayStoreNodeGen.WithoutNullCheckNodeGen.create();

    public IntArrayStoreQuickNode(int top, int callerBCI) {
        super(top, callerBCI);
    }

    @Override
    public int execute(VirtualFrame frame) {
        int value = EspressoFrame.popInt((Frame)frame, this.top - 1);
        int index = EspressoFrame.popInt((Frame)frame, this.top - 2);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, this.top - 3));
        this.intArrayStore.execute(array, index, value);
        return stackEffectOf_IASTORE;
    }
}

