/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.interop.LookupInternalTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.LookupProxyKlassNode;
import com.oracle.truffle.espresso.nodes.interop.LookupTypeConverterNode;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;
import com.oracle.truffle.espresso.nodes.interop.ProxyKlass;
import com.oracle.truffle.espresso.nodes.interop.ToPrimitiveFactory;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.nodes.interop.ToReferenceFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="Convert to Espresso")
public abstract class ToEspressoNode
extends EspressoNode {
    public abstract Object execute(Object var1) throws UnsupportedTypeException;

    @CompilerDirectives.TruffleBoundary
    public static ToEspressoNode createToEspresso(Klass targetType, Meta meta) {
        if (targetType.isPrimitive()) {
            switch (targetType.getJavaKind()) {
                case Boolean: {
                    return ToPrimitiveFactory.ToBooleanNodeGen.create();
                }
                case Byte: {
                    return ToPrimitiveFactory.ToByteNodeGen.create();
                }
                case Short: {
                    return ToPrimitiveFactory.ToShortNodeGen.create();
                }
                case Int: {
                    return ToPrimitiveFactory.ToIntNodeGen.create();
                }
                case Float: {
                    return ToPrimitiveFactory.ToFloatNodeGen.create();
                }
                case Long: {
                    return ToPrimitiveFactory.ToLongNodeGen.create();
                }
                case Double: {
                    return ToPrimitiveFactory.ToDoubleNodeGen.create();
                }
                case Char: {
                    return ToPrimitiveFactory.ToCharNodeGen.create();
                }
                case Void: {
                    return ToReferenceFactory.ToVoidNodeGen.create();
                }
            }
        }
        return ToReference.createToReference(targetType, meta);
    }

    @CompilerDirectives.TruffleBoundary
    public static ToEspressoNode getUncachedToEspresso(Klass targetType, Meta meta) {
        if (targetType.isPrimitive()) {
            switch (targetType.getJavaKind()) {
                case Boolean: {
                    return ToPrimitiveFactory.ToBooleanNodeGen.getUncached();
                }
                case Byte: {
                    return ToPrimitiveFactory.ToByteNodeGen.getUncached();
                }
                case Short: {
                    return ToPrimitiveFactory.ToShortNodeGen.getUncached();
                }
                case Int: {
                    return ToPrimitiveFactory.ToIntNodeGen.getUncached();
                }
                case Float: {
                    return ToPrimitiveFactory.ToFloatNodeGen.getUncached();
                }
                case Long: {
                    return ToPrimitiveFactory.ToLongNodeGen.getUncached();
                }
                case Double: {
                    return ToPrimitiveFactory.ToDoubleNodeGen.getUncached();
                }
                case Char: {
                    return ToPrimitiveFactory.ToCharNodeGen.getUncached();
                }
                case Void: {
                    return ToReferenceFactory.ToVoidNodeGen.getUncached();
                }
            }
        }
        return ToReference.getUncachedToReference(targetType, meta);
    }

    public static boolean isHostString(Object obj) {
        return obj instanceof String;
    }

    public static boolean isTypeMappingEnabled(Klass klass) {
        return klass.typeConversionState == 3;
    }

    public static boolean isTypeConverterEnabled(Klass klass) {
        return klass.isTypeMapped();
    }

    public static boolean isInternalTypeConverterEnabled(Klass klass) {
        return klass.isInternalTypeMapped();
    }

    public static boolean isForeignException(Klass klass, Meta meta) {
        return meta.polyglot != null && meta.polyglot.ForeignException.equals(klass);
    }

    public static String getMetaName(Object metaObject, InteropLibrary interop) {
        assert (interop.isMetaObject(metaObject));
        try {
            return interop.asString(interop.getMetaQualifiedName(metaObject));
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    public static Object getMetaObjectOrThrow(Object value, InteropLibrary interop) throws ClassCastException {
        try {
            return interop.getMetaObject(value);
        }
        catch (UnsupportedMessageException e) {
            throw new ClassCastException("Could not lookup meta object");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void checkHasAllFieldsOrThrow(Object value, ObjectKlass klass, InteropLibrary interopLibrary, Meta meta) {
        CompilerAsserts.partialEvaluationConstant((Object)klass);
        if (meta.isBoxed(klass)) {
            try {
                if (klass == meta.java_lang_Integer && interopLibrary.fitsInInt(value) || klass == meta.java_lang_Long && interopLibrary.fitsInLong(value) || klass == meta.java_lang_Float && interopLibrary.fitsInFloat(value) || klass == meta.java_lang_Double && interopLibrary.fitsInDouble(value) || klass == meta.java_lang_Boolean && interopLibrary.isBoolean(value) || klass == meta.java_lang_Short && interopLibrary.fitsInShort(value) || klass == meta.java_lang_Byte && interopLibrary.fitsInByte(value) || klass == meta.java_lang_Character && interopLibrary.isString(value) && interopLibrary.asString(value).length() == 1) {
                    return;
                }
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
        for (Field f : klass.getDeclaredFields()) {
            if (f.isStatic() || interopLibrary.isMemberExisting(value, f.getNameAsString())) continue;
            throw new ClassCastException("Missing field: " + f.getNameAsString());
        }
        if (klass.getSuperClass() != null) {
            ToEspressoNode.checkHasAllFieldsOrThrow(value, klass.getSuperKlass(), interopLibrary, meta);
        }
    }

    @NodeInfo(shortName="Generic toEspresso node")
    @GenerateUncached
    @ImportStatic(value={ToEspressoNode.class})
    public static abstract class GenericToEspresso
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public abstract Object execute(Object var1, Klass var2) throws UnsupportedTypeException;

        public static boolean isStaticObject(Object value) {
            return value instanceof StaticObject;
        }

        @Specialization
        public Object doStaticObject(StaticObject value, Klass targetType, @Cached InstanceOf.Dynamic instanceOf) throws UnsupportedTypeException {
            if (StaticObject.isNull(value) || instanceOf.execute(value.getKlass(), targetType)) {
                return value;
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.cat("Cannot cast ", value, " to ", targetType.getTypeAsString()));
        }

        @Specialization(guards={"interop.isNull(value)", "!isStaticObject(value)"})
        public Object doForeignNull(Object value, Klass targetType, @CachedLibrary(limit="LIMIT") InteropLibrary interop) {
            return StaticObject.createForeignNull(EspressoLanguage.get(this), value);
        }

        @Specialization(guards={"!interop.isNull(value)", "isTypeMappingEnabled(targetType)", "!isStaticObject(value)"})
        public Object doMappedInterface(Object value, Klass targetType, @Cached LookupProxyKlassNode lookupProxyKlassNode, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                Object metaObject = ToEspressoNode.getMetaObjectOrThrow(value, interop);
                ProxyKlass proxyKlass = lookupProxyKlassNode.execute(metaObject, ToEspressoNode.getMetaName(metaObject, interop), targetType);
                if (proxyKlass != null) {
                    targetType.safeInitialize();
                    return proxyKlass.createProxyInstance(value, this.getLanguage(), interop);
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", targetType.getTypeAsString()));
            }
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)"})
        public Object doArray(Object value, ArrayKlass targetType, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            if (targetType == this.getMeta()._byte_array && interop.hasBufferElements(value) && !ToEspressoNode.isHostString(value)) {
                return StaticObject.createForeign(EspressoLanguage.get(this), this.getMeta()._byte_array, value, interop);
            }
            if (interop.hasArrayElements(value) && !ToEspressoNode.isHostString(value)) {
                return StaticObject.createForeign(EspressoLanguage.get(this), targetType, value, interop);
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getTypeAsString());
        }

        @Specialization(guards={"!interop.isNull(value)", "isTypeConverterEnabled(targetType)", "!isStaticObject(value)"})
        public Object doTypeConverter(Object value, Klass targetType, @Cached LookupTypeConverterNode lookupTypeConverter, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                Object metaObject = ToEspressoNode.getMetaObjectOrThrow(value, interop);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.TypeConverter converter = lookupTypeConverter.execute(metaName);
                if (converter != null) {
                    return converter.convert(StaticObject.createForeign(this.getLanguage(), targetType, value, interop));
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", targetType.getNameAsString(), e.getMessage()));
            }
        }

        @Specialization(guards={"!interop.isNull(value)", "isInternalTypeConverterEnabled(targetType)", "!isStaticObject(value)"})
        public Object doInternalTypeConverter(Object value, Klass targetType, @Cached ToReference.DynamicToReference converterToEspresso, @Cached LookupInternalTypeConverterNode lookupInternalTypeConverter, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                Object metaObject = ToEspressoNode.getMetaObjectOrThrow(value, interop);
                String metaName = ToEspressoNode.getMetaName(metaObject, interop);
                PolyglotTypeMappings.InternalTypeConverter converter = lookupInternalTypeConverter.execute(metaName);
                if (converter != null) {
                    return converter.convertInternal(interop, value, this.getMeta(), converterToEspresso);
                }
                throw new ClassCastException();
            }
            catch (ClassCastException e) {
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)EspressoError.format("Could not cast foreign object to %s: ", targetType.getNameAsString(), e.getMessage()));
            }
        }

        @Specialization(guards={"!interop.isNull(value)", "!isStaticObject(value)", "!targetType.isArray()", "!isTypeConverterEnabled(targetType)", "!isTypeMappingEnabled(targetType)"})
        public Object doGeneric(Object value, Klass targetType, @Bind(value="getMeta()") Meta meta, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedTypeException {
            try {
                return ToEspressoNode.getUncachedToEspresso(targetType, meta).execute(value);
            }
            catch (IllegalStateException ex) {
                if (targetType instanceof ObjectKlass) {
                    try {
                        ToEspressoNode.checkHasAllFieldsOrThrow(value, (ObjectKlass)targetType, interop, this.getMeta());
                        return StaticObject.createForeign(this.getLanguage(), targetType, value, interop);
                    }
                    catch (ClassCastException e) {
                        throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getTypeAsString());
                    }
                }
                throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)targetType.getTypeAsString());
            }
        }
    }

    @NodeInfo(shortName="Dynamic toEspresso node")
    @GenerateUncached
    @ReportPolymorphism
    public static abstract class DynamicToEspresso
    extends EspressoNode {
        protected static final int LIMIT = 4;

        public abstract Object execute(Object var1, Klass var2) throws UnsupportedTypeException;

        protected static ToEspressoNode createToEspressoNode(Klass targetType) {
            return ToEspressoNode.createToEspresso(targetType, targetType.getMeta());
        }

        @Specialization(guards={"targetType == cachedTargetType"}, limit="LIMIT")
        public Object doCached(Object value, Klass targetType, @Cached(value="targetType") Klass cachedTargetType, @Cached(value="createToEspressoNode(cachedTargetType)") ToEspressoNode toEspressoNode) throws UnsupportedTypeException {
            return toEspressoNode.execute(value);
        }

        @Specialization(replaces={"doCached"})
        @ReportPolymorphism.Megamorphic
        public Object doGeneric(Object value, Klass targetType, @Cached GenericToEspresso genericToEspresso) throws UnsupportedTypeException {
            return genericToEspresso.execute(value, targetType);
        }
    }
}

