/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.interop.CandidateMethodWithArgs;
import com.oracle.truffle.espresso.nodes.interop.MethodArgsUtils;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@GenerateUncached
public abstract class OverLoadedMethodSelectorNode
extends EspressoNode {
    static final int LIMIT = 2;

    public abstract CandidateMethodWithArgs execute(Method[] var1, Object[] var2);

    @Specialization(guards={"same(candidates, cachedCandidates)"}, limit="LIMIT")
    CandidateMethodWithArgs doCached(Method[] candidates, Object[] arguments, @Cached(value="candidates", dimensions=1) Method[] cachedCandidates, @Cached(value="resolveParameterKlasses(candidates)", dimensions=2) Klass[][] parameterKlasses, @Cached ToEspressoNode.DynamicToEspresso toEspressoNode) {
        return OverLoadedMethodSelectorNode.selectMatchingOverloads(candidates, arguments, parameterKlasses, toEspressoNode);
    }

    @Specialization(replaces={"doCached"})
    CandidateMethodWithArgs doGeneric(Method[] candidates, Object[] arguments, @Cached ToEspressoNode.DynamicToEspresso toEspressoNode) {
        return OverLoadedMethodSelectorNode.selectMatchingOverloads(candidates, arguments, OverLoadedMethodSelectorNode.resolveParameterKlasses(candidates), toEspressoNode);
    }

    @CompilerDirectives.TruffleBoundary
    private static CandidateMethodWithArgs selectMatchingOverloads(Method[] candidates, Object[] arguments, Klass[][] parameterKlasses, ToEspressoNode.DynamicToEspresso toEspressoNode) {
        ArrayList<CandidateMethodWithArgs> fitByType = new ArrayList<CandidateMethodWithArgs>(candidates.length);
        for (int i = 0; i < candidates.length; ++i) {
            CandidateMethodWithArgs matched = MethodArgsUtils.matchCandidate(candidates[i], arguments, parameterKlasses[i], toEspressoNode);
            if (matched == null) continue;
            fitByType.add(matched);
        }
        if (fitByType.isEmpty()) {
            return null;
        }
        if (fitByType.size() == 1) {
            CandidateMethodWithArgs matched = (CandidateMethodWithArgs)fitByType.get(0);
            if (matched.getMethod().isVarargs()) {
                return MethodArgsUtils.ensureVarArgsArrayCreated(matched, toEspressoNode);
            }
            return matched;
        }
        CandidateMethodWithArgs mostSpecificOverload = OverLoadedMethodSelectorNode.findMostSpecificOverload(fitByType, arguments);
        if (mostSpecificOverload != null && mostSpecificOverload.getMethod().isVarargs()) {
            return MethodArgsUtils.ensureVarArgsArrayCreated(mostSpecificOverload, toEspressoNode);
        }
        return mostSpecificOverload;
    }

    private static CandidateMethodWithArgs findMostSpecificOverload(List<CandidateMethodWithArgs> candidates, Object[] args) {
        assert (candidates.size() >= 2);
        if (candidates.size() == 2) {
            int res = OverLoadedMethodSelectorNode.compareOverloads(candidates.get(0), candidates.get(1), args);
            return res == 0 ? null : (res < 0 ? candidates.get(0) : candidates.get(1));
        }
        Iterator<CandidateMethodWithArgs> candIt = candidates.iterator();
        LinkedList<CandidateMethodWithArgs> best = new LinkedList<CandidateMethodWithArgs>();
        best.add(candIt.next());
        while (candIt.hasNext()) {
            CandidateMethodWithArgs cand = candIt.next();
            boolean add = false;
            Iterator bestIt = best.iterator();
            while (bestIt.hasNext()) {
                int res = OverLoadedMethodSelectorNode.compareOverloads(cand, (CandidateMethodWithArgs)bestIt.next(), args);
                if (res == 0) {
                    add = true;
                    continue;
                }
                if (res < 0) {
                    bestIt.remove();
                    add = true;
                    continue;
                }
                assert (res > 0);
            }
            if (!add) continue;
            best.add(cand);
        }
        assert (!best.isEmpty());
        if (best.size() == 1) {
            return (CandidateMethodWithArgs)best.get(0);
        }
        return null;
    }

    private static int compareOverloads(CandidateMethodWithArgs m1, CandidateMethodWithArgs m2, Object[] arguments) {
        int exact = 0;
        int res = 0;
        for (int i = 0; i < arguments.length; ++i) {
            Klass t2;
            Klass t1 = OverLoadedMethodSelectorNode.getParameterType(i, m1);
            if (t1 == (t2 = OverLoadedMethodSelectorNode.getParameterType(i, m2))) continue;
            int r = OverLoadedMethodSelectorNode.compareKnownTypesExact(t1, t2, arguments[i]);
            if (r != 0) {
                if (exact == 0) {
                    exact = r;
                } else if (exact != r) {
                    return 0;
                }
                r = 0;
            }
            if (exact == 0) {
                r = OverLoadedMethodSelectorNode.compareAssignable(t1, t2);
            }
            if (r == 0) continue;
            if (res == 0) {
                res = r;
                continue;
            }
            if (res == r) continue;
            return 0;
        }
        return exact != 0 ? exact : res;
    }

    private static Klass getParameterType(int i, CandidateMethodWithArgs m1) {
        int length = m1.getParameterTypes().length;
        if (m1.getMethod().isVarargs() && i >= length - 1) {
            return ((ArrayKlass)m1.getParameterTypes()[length - 1]).getComponentType();
        }
        return m1.getParameterTypes()[i];
    }

    private static int compareKnownTypesExact(Klass t1, Klass t2, Object arg) {
        boolean t1IsPrimitive;
        Klass t1AsPrimitive;
        Klass compareType2;
        Klass compareType1;
        Meta meta = t1.getMeta();
        Class<?> hostClass = arg.getClass();
        if (t1.isArray() && t2.isArray()) {
            compareType1 = t1.getElementalType();
            compareType2 = t2.getElementalType();
            while (hostClass.isArray()) {
                hostClass = hostClass.getComponentType();
            }
        } else {
            compareType1 = t1;
            compareType2 = t2;
        }
        Klass klass = t1AsPrimitive = (t1IsPrimitive = compareType1.isPrimitive()) ? compareType1 : MethodArgsUtils.boxedTypeToPrimitiveType(compareType1);
        if (t1AsPrimitive != null) {
            Klass t2AsPrimitive;
            boolean t2Primitive = compareType2.isPrimitive();
            Klass klass2 = t2AsPrimitive = t2Primitive ? compareType2 : MethodArgsUtils.boxedTypeToPrimitiveType(compareType2);
            if (hostClass == Boolean.class) {
                if (t1AsPrimitive == meta._boolean) {
                    return -1;
                }
                if (t2AsPrimitive == meta._boolean) {
                    return 1;
                }
            }
            if (hostClass == Character.class) {
                if (t1AsPrimitive == meta._char) {
                    return -1;
                }
                if (t2AsPrimitive == meta._char) {
                    return 1;
                }
            }
            if (hostClass == Byte.class) {
                if (t1AsPrimitive == meta._byte) {
                    return -1;
                }
                if (t2AsPrimitive == meta._byte) {
                    return 1;
                }
            }
            if (hostClass == Short.class) {
                if (t1AsPrimitive == meta._short) {
                    return -1;
                }
                if (t2AsPrimitive == meta._short) {
                    return 1;
                }
            }
            if (hostClass == Integer.class) {
                if (t1AsPrimitive == meta._int) {
                    return -1;
                }
                if (t2AsPrimitive == meta._int) {
                    return 1;
                }
            }
            if (hostClass == Long.class) {
                if (t1AsPrimitive == meta._long) {
                    return -1;
                }
                if (t2AsPrimitive == meta._long) {
                    return 1;
                }
            }
            if (hostClass == Float.class) {
                if (t1AsPrimitive == meta._float) {
                    return -1;
                }
                if (t2AsPrimitive == meta._float) {
                    return 1;
                }
            }
            if (hostClass == Double.class) {
                if (t1AsPrimitive == meta._double) {
                    return -1;
                }
                if (t2AsPrimitive == meta._double) {
                    return 1;
                }
            }
        }
        if (hostClass == String.class) {
            if (compareType1 == meta.java_lang_String || compareType1 == meta.java_lang_CharSequence) {
                return -1;
            }
            if (compareType2 == meta.java_lang_String || compareType2 == meta.java_lang_CharSequence) {
                return 1;
            }
        }
        return 0;
    }

    private static int compareAssignable(Klass t1, Klass t2) {
        if (OverLoadedMethodSelectorNode.isAssignableFrom(t1, t2)) {
            return 1;
        }
        if (OverLoadedMethodSelectorNode.isAssignableFrom(t2, t1)) {
            return -1;
        }
        return 0;
    }

    private static boolean isAssignableFrom(Klass toType, Klass fromType) {
        PrimitiveKlass toAsPrimitive;
        if (toType.isAssignableFrom(fromType)) {
            return true;
        }
        Meta meta = toType.getMeta();
        boolean fromIsPrimitive = fromType.isPrimitive();
        boolean toIsPrimitive = toType.isPrimitive();
        PrimitiveKlass fromAsPrimitive = fromIsPrimitive ? (PrimitiveKlass)fromType : MethodArgsUtils.boxedTypeToPrimitiveType(fromType);
        PrimitiveKlass primitiveKlass = toAsPrimitive = toIsPrimitive ? (PrimitiveKlass)toType : MethodArgsUtils.boxedTypeToPrimitiveType(toType);
        if (toAsPrimitive != null && fromAsPrimitive != null) {
            if (toAsPrimitive == fromAsPrimitive) {
                assert (fromIsPrimitive != toIsPrimitive);
                return fromIsPrimitive;
            }
            if (MethodArgsUtils.isWideningPrimitiveConversion(toAsPrimitive, fromAsPrimitive)) {
                return true;
            }
        } else {
            if (fromAsPrimitive == meta._char && (toType == meta.java_lang_String || toType == meta.java_lang_CharSequence)) {
                return true;
            }
            if (toAsPrimitive == null && fromAsPrimitive != null && toType.isAssignableFrom(MethodArgsUtils.primitiveTypeToBoxedType(fromAsPrimitive))) {
                return true;
            }
        }
        return false;
    }

    static boolean same(Method[] methods, Method[] cachedMethods) {
        assert (methods != null);
        assert (cachedMethods != null);
        if (methods.length != cachedMethods.length) {
            return false;
        }
        for (int i = 0; i < cachedMethods.length; ++i) {
            if (methods[i] == cachedMethods[i]) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    static Klass[][] resolveParameterKlasses(Method[] methods) {
        Klass[][] resolved = new Klass[methods.length][];
        for (int i = 0; i < methods.length; ++i) {
            resolved[i] = methods[i].resolveParameterKlasses();
        }
        return resolved;
    }
}

