/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.interop.EspressoForeignProxyGenerator;
import com.oracle.truffle.espresso.nodes.interop.PolyglotTypeMappings;
import com.oracle.truffle.espresso.nodes.interop.ProxyKlass;
import com.oracle.truffle.espresso.nodes.interop.WrappedProxyKlass;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.HashSet;
import java.util.Set;

@GenerateUncached
public abstract class LookupProxyKlassNode
extends EspressoNode {
    static final int LIMIT = 3;

    LookupProxyKlassNode() {
    }

    public abstract ProxyKlass execute(Object var1, String var2, Klass var3) throws ClassCastException;

    @Specialization(guards={"targetType == cachedTargetType", "cachedMetaName.equals(metaName)"}, limit="LIMIT")
    ProxyKlass doCached(Object metaObject, String metaName, Klass targetType, @Cached(value="metaObject") Object cachedMetaObject, @Cached(value="targetType") Klass cachedTargetType, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached(value="metaName") String cachedMetaName, @Cached(value="doUncached(metaObject, metaName, targetType, interop)") ProxyKlass cachedProxyKlass) throws ClassCastException {
        return cachedProxyKlass;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(replaces={"doCached"})
    ProxyKlass doUncached(Object metaObject, String metaName, Klass targetType, @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws ClassCastException {
        Klass proxyKlass;
        if (!this.getContext().interfaceMappingsEnabled()) {
            return null;
        }
        assert (interop.isMetaObject(metaObject));
        EspressoForeignProxyGenerator.GeneratedProxyBytes proxyBytes = this.getContext().getProxyBytesOrNull(metaName);
        if (proxyBytes == null) {
            HashSet<ObjectKlass> parentInterfaces = new HashSet<ObjectKlass>();
            ObjectKlass superKlass = LookupProxyKlassNode.fillParents(metaObject, interop, this.getContext().getPolyglotTypeMappings(), parentInterfaces, this.getContext());
            if (parentInterfaces.isEmpty()) {
                if (superKlass != this.getMeta().java_lang_Object) {
                    if (!targetType.isAssignableFrom(superKlass)) {
                        throw new ClassCastException("super klass is not instance of expected type: " + targetType.getName());
                    }
                    if (superKlass == this.getMeta().polyglot.EspressoForeignList) {
                        return new WrappedProxyKlass(superKlass, this.getContext(), superKlass);
                    }
                    return new ProxyKlass(superKlass);
                }
                return null;
            }
            proxyBytes = EspressoForeignProxyGenerator.getProxyKlassBytes(metaName, parentInterfaces.toArray(new ObjectKlass[parentInterfaces.size()]), superKlass, this.getContext());
        }
        if (!targetType.isAssignableFrom(proxyKlass = LookupProxyKlassNode.lookupOrDefineInBindingsLoader(proxyBytes, this.getContext()))) {
            throw new ClassCastException("proxy object is not instance of expected type: " + targetType.getName());
        }
        return proxyBytes.getProxyKlass(this.getContext(), (ObjectKlass)proxyKlass);
    }

    private static Klass lookupOrDefineInBindingsLoader(EspressoForeignProxyGenerator.GeneratedProxyBytes proxyBytes, EspressoContext context) {
        ClassRegistry registry = context.getRegistries().getClassRegistry(context.getBindingsLoader());
        Symbol<Symbol.Type> proxyName = context.getTypes().fromClassGetName(proxyBytes.name);
        Klass proxyKlass = registry.findLoadedKlass(context.getClassLoadingEnv(), proxyName);
        if (proxyKlass == null) {
            try {
                proxyKlass = registry.defineKlass(context, proxyName, proxyBytes.bytes);
            }
            catch (EspressoClassLoadingException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }
        return proxyKlass;
    }

    private static ObjectKlass fillParents(Object metaObject, InteropLibrary interop, PolyglotTypeMappings mappings, Set<ObjectKlass> parents, EspressoContext context) throws ClassCastException {
        Meta meta = context.getMeta();
        ObjectKlass superKlass = meta.java_lang_Object;
        try {
            if (interop.hasMetaParents(metaObject)) {
                Object metaParents = interop.getMetaParents(metaObject);
                long arraySize = interop.getArraySize(metaParents);
                for (long i = 0L; i < arraySize; ++i) {
                    ObjectKlass mappedSuperKlass;
                    Object parent = interop.readArrayElement(metaParents, i);
                    String metaName = interop.asString(interop.getMetaQualifiedName(parent));
                    ObjectKlass mappedKlass = mappings.mapInterfaceName(metaName);
                    if (mappedKlass != null) {
                        parents.add(mappedKlass);
                    } else if (context.getEspressoEnv().BuiltInPolyglotCollections && (mappedSuperKlass = mappings.mapEspressoForeignCollection(metaName)) != null) {
                        superKlass = mappedSuperKlass;
                        continue;
                    }
                    ObjectKlass result = LookupProxyKlassNode.fillParents(parent, interop, mappings, parents, context);
                    if (superKlass != meta.java_lang_Object || result == meta.java_lang_Object) continue;
                    superKlass = result;
                }
            }
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw new ClassCastException();
        }
        return superKlass;
    }
}

