/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@GenerateUncached
public abstract class LookupAndInvokeKnownMethodNode
extends EspressoNode {
    static final int LIMIT = 3;
    static final Object[] EMPTY_ARGS = new Object[0];

    public final Object execute(StaticObject receiver, Method resolutionSeed) {
        return this.execute(receiver, resolutionSeed, EMPTY_ARGS);
    }

    public abstract Object execute(StaticObject var1, Method var2, Object[] var3);

    @Specialization(guards={"resolutionSeed == cachedSeed", "cachedSeed.getParameterCount() == 0", "cachedSeed.getDeclaringKlass().isInterface()", "receiver.getKlass() == cachedKlass"}, limit="LIMIT")
    Object doInterfaceCachedNoArg(StaticObject receiver, Method resolutionSeed, Object[] arguments, @Cached(value="resolutionSeed") Method cachedSeed, @Cached(value="receiver.getKlass()") Klass cachedKlass, @Cached(value="interfaceLookup(receiver, resolutionSeed)") Method m, @Cached(value="create(m.getCallTarget())") DirectCallNode callNode) {
        assert (0 == arguments.length);
        return callNode.call(new Object[]{receiver});
    }

    @Specialization(guards={"resolutionSeed == cachedSeed", "cachedSeed.getParameterCount() == 0", "!cachedSeed.getDeclaringKlass().isInterface()", "receiver.getKlass() == cachedKlass"}, limit="LIMIT")
    Object doVirtualCachedNoArg(StaticObject receiver, Method resolutionSeed, Object[] arguments, @Cached(value="resolutionSeed") Method cachedSeed, @Cached(value="receiver.getKlass()") Klass cachedKlass, @Cached(value="virtualLookup(receiver, resolutionSeed)") Method m, @Cached(value="create(m.getCallTarget())") DirectCallNode callNode) {
        assert (0 == arguments.length);
        return callNode.call(new Object[]{receiver});
    }

    @Specialization(guards={"resolutionSeed == cachedSeed", "cachedSeed.getDeclaringKlass().isInterface()", "receiver.getKlass() == cachedKlass"}, limit="LIMIT")
    Object doInterfaceCached(StaticObject receiver, Method resolutionSeed, Object[] arguments, @Cached(value="resolutionSeed") Method cachedSeed, @Cached(value="receiver.getKlass()") Klass cachedKlass, @Cached(value="interfaceLookup(receiver, resolutionSeed)") Method m, @Cached.Exclusive @Cached InvokeEspressoNode invoke) {
        assert (m.getParameterCount() == arguments.length);
        return LookupAndInvokeKnownMethodNode.invoke(invoke, m, receiver, arguments);
    }

    @Specialization(guards={"resolutionSeed == cachedSeed", "!cachedSeed.getDeclaringKlass().isInterface()", "receiver.getKlass() == cachedKlass"}, limit="LIMIT")
    Object doVirtualCached(StaticObject receiver, Method resolutionSeed, Object[] arguments, @Cached(value="resolutionSeed") Method cachedSeed, @Cached(value="receiver.getKlass()") Klass cachedKlass, @Cached(value="virtualLookup(receiver, resolutionSeed)") Method m, @Cached.Exclusive @Cached InvokeEspressoNode invoke) {
        assert (m.getParameterCount() == arguments.length);
        return LookupAndInvokeKnownMethodNode.invoke(invoke, m, receiver, arguments);
    }

    @Specialization(guards={"resolutionSeed == cachedSeed", "cachedSeed.getDeclaringKlass().isInterface()"}, replaces={"doInterfaceCachedNoArg", "doInterfaceCached"}, limit="1")
    Object doInterfaceUncached(StaticObject receiver, Method resolutionSeed, Object[] arguments, @Cached(value="resolutionSeed") Method cachedSeed, @Cached.Exclusive @Cached InvokeEspressoNode invoke) {
        return LookupAndInvokeKnownMethodNode.invoke(invoke, this.interfaceLookup(receiver, cachedSeed), receiver, arguments);
    }

    @Specialization(guards={"resolutionSeed == cachedSeed", "!cachedSeed.getDeclaringKlass().isInterface()"}, replaces={"doVirtualCachedNoArg", "doVirtualCached"}, limit="1")
    Object doVirtualUncached(StaticObject receiver, Method resolutionSeed, Object[] arguments, @Cached(value="resolutionSeed") Method cachedSeed, @Cached.Exclusive @Cached InvokeEspressoNode invoke) {
        return LookupAndInvokeKnownMethodNode.invoke(invoke, this.virtualLookup(receiver, cachedSeed), receiver, arguments);
    }

    @Specialization(guards={"resolutionSeed.getDeclaringKlass().isInterface()"}, replaces={"doInterfaceUncached"})
    Object doInterfaceUnknown(StaticObject receiver, Method resolutionSeed, Object[] arguments, @Cached.Exclusive @Cached InvokeEspressoNode invoke) {
        return LookupAndInvokeKnownMethodNode.invoke(invoke, this.interfaceLookup(receiver, resolutionSeed), receiver, arguments);
    }

    @Specialization(guards={"!resolutionSeed.getDeclaringKlass().isInterface()"}, replaces={"doVirtualUncached"})
    Object doVirtualUnknown(StaticObject receiver, Method resolutionSeed, Object[] arguments, @Cached.Exclusive @Cached InvokeEspressoNode invoke) {
        return LookupAndInvokeKnownMethodNode.invoke(invoke, this.virtualLookup(receiver, resolutionSeed), receiver, arguments);
    }

    Method interfaceLookup(StaticObject receiver, Method resolutionSeed) {
        assert (resolutionSeed.getDeclaringKlass().isAssignableFrom(receiver.getKlass()));
        return EspressoInterop.getInteropKlass(receiver).itableLookup(resolutionSeed.getDeclaringKlass(), resolutionSeed.getITableIndex());
    }

    Method virtualLookup(StaticObject receiver, Method resolutionSeed) {
        assert (resolutionSeed.getDeclaringKlass().isAssignableFrom(receiver.getKlass()));
        return EspressoInterop.getInteropKlass(receiver).vtableLookup(resolutionSeed.getVTableIndex());
    }

    private static Object invoke(InvokeEspressoNode invoke, Method m, StaticObject receiver, Object[] arguments) {
        try {
            return invoke.execute(m, receiver, arguments);
        }
        catch (ArityException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }
}

