/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractGetFieldNode;
import com.oracle.truffle.espresso.nodes.interop.ToPrimitive;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

abstract class ShortGetFieldNode
extends AbstractGetFieldNode {
    ShortGetFieldNode(Field f) {
        super(f);
        assert (f.getKind() == JavaKind.Short);
    }

    @Override
    public int getField(VirtualFrame frame, BytecodeNode root, StaticObject receiver, int at, int statementIndex) {
        root.notifyFieldAccess(frame, statementIndex, this.getField(), receiver);
        EspressoFrame.putInt((Frame)frame, at, this.executeGetField(receiver));
        return this.slotCount;
    }

    abstract short executeGetField(StaticObject var1);

    @Specialization(guards={"receiver.isEspressoObject()"})
    short doEspresso(StaticObject receiver) {
        return this.getField().getShort(receiver);
    }

    @Specialization(guards={"receiver.isForeignObject()", "isValueField(meta)"})
    short doForeignValue(StaticObject receiver, @Bind(value="getMeta()") Meta meta, @CachedLibrary(limit="CACHED_LIBRARY_LIMIT") InteropLibrary interopLibrary, @Cached BranchProfile error) {
        try {
            return interopLibrary.asShort(receiver.rawForeignObject(this.getLanguage()));
        }
        catch (UnsupportedMessageException e) {
            error.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Foreign object does not fit in short");
        }
    }

    @Specialization(guards={"receiver.isForeignObject()", "!isValueField(meta)"}, limit="CACHED_LIBRARY_LIMIT")
    short doForeign(StaticObject receiver, @Bind(value="getLanguage()") EspressoLanguage language, @Bind(value="getMeta()") Meta meta, @CachedLibrary(value="receiver.rawForeignObject(language)") InteropLibrary interopLibrary, @Cached ToPrimitive.ToShort toShort, @Cached BranchProfile error) {
        Object value = this.getForeignField(receiver, interopLibrary, language, meta, error);
        try {
            return (Short)toShort.execute(value);
        }
        catch (UnsupportedTypeException e) {
            error.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Foreign field %s cannot be cast to short", this.fieldName);
        }
    }

    @Idempotent
    boolean isValueField(Meta meta) {
        return this.getField() == meta.java_lang_Short_value;
    }
}

