/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.helper.BooleanGetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.ByteGetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.CharGetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.DoubleGetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.FloatGetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.IntGetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.LongGetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.ObjectGetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.ShortGetFieldNodeGen;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class AbstractGetFieldNode
extends EspressoNode {
    final Field field;
    final String fieldName;
    final int slotCount;
    static final int CACHED_LIBRARY_LIMIT = 3;

    AbstractGetFieldNode(Field field) {
        this.field = field;
        this.fieldName = this.getField().getNameAsString();
        this.slotCount = this.getField().getKind().getSlotCount();
    }

    Field getField() {
        return this.field;
    }

    public abstract int getField(VirtualFrame var1, BytecodeNode var2, StaticObject var3, int var4, int var5);

    public static AbstractGetFieldNode create(Field f) {
        switch (f.getKind()) {
            case Boolean: {
                return BooleanGetFieldNodeGen.create(f);
            }
            case Byte: {
                return ByteGetFieldNodeGen.create(f);
            }
            case Short: {
                return ShortGetFieldNodeGen.create(f);
            }
            case Char: {
                return CharGetFieldNodeGen.create(f);
            }
            case Int: {
                return IntGetFieldNodeGen.create(f);
            }
            case Float: {
                return FloatGetFieldNodeGen.create(f);
            }
            case Long: {
                return LongGetFieldNodeGen.create(f);
            }
            case Double: {
                return DoubleGetFieldNodeGen.create(f);
            }
            case Object: {
                return ObjectGetFieldNodeGen.create(f);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    protected Object getForeignField(StaticObject receiver, InteropLibrary interopLibrary, EspressoLanguage language, Meta meta, BranchProfile error) {
        Object value;
        assert (this.getField().getDeclaringKlass().isAssignableFrom(receiver.getKlass()));
        assert (!this.getField().isStatic());
        try {
            value = interopLibrary.readMember(receiver.rawForeignObject(language), this.fieldName);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            error.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchFieldError, "Foreign object has no readable field %s", this.fieldName);
        }
        return value;
    }
}

