/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.commands;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.List;

public final class ReferenceProcessCache
extends EspressoNode {
    private static final List<Symbol<Symbol.Type>> SHARED_SECRETS_TYPES = List.of(Symbol.Type.jdk_internal_access_SharedSecrets, Symbol.Type.sun_misc_SharedSecrets, Symbol.Type.jdk_internal_misc_SharedSecrets);
    private static final List<Symbol<Symbol.Type>> JAVA_LANG_ACCESS_TYPES = List.of(Symbol.Type.jdk_internal_access_JavaLangAccess, Symbol.Type.sun_misc_JavaLangAccess, Symbol.Type.jdk_internal_misc_JavaLangAccess);
    private static final List<Symbol<Symbol.Signature>> RUN_FINALIZER_SIGNATURES = List.of(Symbol.Signature._void_jdk_internal_access_JavaLangAccess, Symbol.Signature._void_sun_misc_JavaLangAccess, Symbol.Signature._void_jdk_internal_misc_JavaLangAccess);
    private final EspressoContext context;
    private final DirectCallNode processPendingReferences;
    private final StaticObject finalizerQueue;
    private final DirectCallNode queuePoll;
    private final DirectCallNode runFinalizer;
    private final StaticObject jla;

    public ReferenceProcessCache(EspressoContext context) {
        this.context = context;
        Method processPendingReferenceMethod = ReferenceProcessCache.findProcessPendingReferences(context);
        this.processPendingReferences = DirectCallNode.create((CallTarget)processPendingReferenceMethod.getCallTargetForceInit());
        Field queue = context.getMeta().java_lang_ref_Finalizer.lookupDeclaredField(Symbol.Name.queue, Symbol.Type.java_lang_ref_ReferenceQueue);
        this.finalizerQueue = queue.getObject(context.getMeta().java_lang_ref_Finalizer.tryInitializeAndGetStatics());
        Method poll = this.finalizerQueue.getKlass().lookupMethod(Symbol.Name.poll, Symbol.Signature.Reference);
        this.queuePoll = DirectCallNode.create((CallTarget)poll.getCallTargetForceInit());
        Klass sharedSecrets = ReferenceProcessCache.findSharedSecrets(context);
        Field jlaField = ReferenceProcessCache.findJlaField(sharedSecrets);
        this.jla = jlaField.getObject(sharedSecrets.tryInitializeAndGetStatics());
        this.runFinalizer = DirectCallNode.create((CallTarget)ReferenceProcessCache.findRunFinalizer(context).getCallTargetForceInit());
    }

    public void execute() {
        if (this.context.multiThreadingEnabled()) {
            throw this.throwIllegalStateException("Manual reference processing was requested, but the context is not in single-threaded mode.");
        }
        this.context.triggerDrain();
        this.processPendingReferences();
        this.processFinalizers();
    }

    private void processPendingReferences() {
        if (!this.context.hasReferencePendingList()) {
            return;
        }
        if (this.context.getJavaVersion().java8OrEarlier()) {
            this.processPendingReferences.call(new Object[]{false});
        } else {
            this.processPendingReferences.call(new Object[0]);
        }
    }

    private void processFinalizers() {
        StaticObject finalizer = (StaticObject)this.queuePoll.call(new Object[]{this.finalizerQueue});
        while (!StaticObject.isNull(finalizer)) {
            this.runFinalizer.call(new Object[]{finalizer, this.jla});
            finalizer = (StaticObject)this.queuePoll.call(new Object[]{this.finalizerQueue});
        }
    }

    private EspressoException throwIllegalStateException(String message) {
        return this.context.getMeta().throwExceptionWithMessage(this.context.getMeta().java_lang_IllegalStateException, message);
    }

    private static Klass findSharedSecrets(EspressoContext context) {
        for (Symbol<Symbol.Type> type : SHARED_SECRETS_TYPES) {
            Klass k = context.getMeta().loadKlassOrNull(type, StaticObject.NULL, StaticObject.NULL);
            if (k == null) continue;
            return k;
        }
        throw EspressoError.shouldNotReachHere("Could not find SharedSecrets for reference processing.");
    }

    private static Field findJlaField(Klass sharedSecrets) {
        for (Symbol<Symbol.Type> type : JAVA_LANG_ACCESS_TYPES) {
            Field f = sharedSecrets.lookupField(Symbol.Name.javaLangAccess, type, Klass.LookupMode.STATIC_ONLY);
            if (f == null) continue;
            return f;
        }
        throw EspressoError.shouldNotReachHere("Could not find SharedSecrets#javaLangAccess field for reference processing.");
    }

    private static Method findRunFinalizer(EspressoContext context) {
        for (Symbol<Symbol.Signature> signature : RUN_FINALIZER_SIGNATURES) {
            Method m = context.getMeta().java_lang_ref_Finalizer.lookupMethod(Symbol.Name.runFinalizer, signature, Klass.LookupMode.INSTANCE_ONLY);
            if (m == null) continue;
            return m;
        }
        throw EspressoError.shouldNotReachHere("Could not find Finalizer.runFinalizer method for reference processing.");
    }

    private static Method findProcessPendingReferences(EspressoContext context) {
        Method processPendingReferenceMethod = context.getJavaVersion().java8OrEarlier() ? context.getMeta().java_lang_ref_Reference.lookupDeclaredMethod(Symbol.Name.tryHandlePending, Symbol.Signature._boolean_boolean, Klass.LookupMode.STATIC_ONLY) : context.getMeta().java_lang_ref_Reference.lookupDeclaredMethod(Symbol.Name.processPendingReferences, Symbol.Signature._void, Klass.LookupMode.STATIC_ONLY);
        if (processPendingReferenceMethod == null) {
            throw EspressoError.shouldNotReachHere("Could not find pending reference processing method.");
        }
        return processPendingReferenceMethod;
    }
}

