/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.bytecodes.Utils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="INVOKESPECIAL")
public abstract class InvokeSpecial
extends EspressoNode {
    final Method method;

    InvokeSpecial(Method method) {
        this.method = method;
    }

    public abstract Object execute(Object[] var1);

    @Specialization
    Object doWithNullCheck(Object[] args, @Cached NullCheck nullCheck, @Cached(value="create(method)") WithoutNullCheck invokeSpecial) {
        StaticObject receiver = (StaticObject)args[0];
        nullCheck.execute(receiver);
        return invokeSpecial.execute(args);
    }

    static Method.MethodVersion methodLookup(Method method, StaticObject receiver) {
        if (method.isRemovedByRedefinition()) {
            return method.getContext().getClassRedefinition().handleRemovedMethod(method, receiver.getKlass()).getMethodVersion();
        }
        return method.getMethodVersion();
    }

    @NodeInfo(shortName="INVOKESPECIAL !nullcheck")
    @ImportStatic(value={InvokeSpecial.class, Utils.class})
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        final Method method;

        WithoutNullCheck(Method method) {
            this.method = method;
        }

        public abstract Object execute(Object[] var1);

        static StaticObject getReceiver(Object[] args) {
            return (StaticObject)args[0];
        }

        @Specialization(assumptions={"resolvedMethod.getRedefineAssumption()"})
        public Object callDirect(Object[] args, @Bind(value="getReceiver(args)") StaticObject receiver, @Cached(value="methodLookup(method, receiver)") Method.MethodVersion resolvedMethod, @Cached(value="createAndMaybeForceInline(resolvedMethod)") DirectCallNode directCallNode) {
            assert (!StaticObject.isNull(receiver));
            return directCallNode.call(args);
        }

        @Specialization(replaces={"callDirect"})
        @ReportPolymorphism.Megamorphic
        Object callIndirect(Object[] args, @Cached IndirectCallNode indirectCallNode) {
            StaticObject receiver = (StaticObject)args[0];
            assert (!StaticObject.isNull(receiver));
            Method.MethodVersion resolvedMethod = InvokeSpecial.methodLookup(this.method, receiver);
            return indirectCallNode.call(resolvedMethod.getCallTarget(), new Object[]{receiver, args});
        }
    }

    @NodeInfo(shortName="INVOKESPECIAL dynamic")
    @GenerateUncached
    public static abstract class Dynamic
    extends EspressoNode {
        public abstract Object execute(Method var1, Object[] var2);

        @Specialization
        Object doWithNullCheck(Method method, Object[] args, @Cached NullCheck nullCheck, @Cached WithoutNullCheck invokeSpecial) {
            StaticObject receiver = (StaticObject)args[0];
            nullCheck.execute(receiver);
            return invokeSpecial.execute(method, args);
        }

        @NodeInfo(shortName="INVOKESPECIAL dynamic !nullcheck")
        @GenerateUncached
        public static abstract class WithoutNullCheck
        extends EspressoNode {
            protected static final int LIMIT = 4;

            public abstract Object execute(Method var1, Object[] var2);

            static StaticObject getReceiver(Object[] args) {
                return (StaticObject)args[0];
            }

            @Specialization(limit="LIMIT", guards={"method == cachedMethod"})
            public Object callDirect(Method method, Object[] args, @Bind(value="getReceiver(args)") StaticObject receiver, @Cached(value="method") Method cachedMethod, @Cached(value="create(method)") InvokeSpecial invokeSpecial) {
                return invokeSpecial.execute(args);
            }

            @Specialization(replaces={"callDirect"})
            @ReportPolymorphism.Megamorphic
            Object callIndirect(Method method, Object[] args, @Cached IndirectCallNode indirectCallNode) {
                StaticObject receiver = (StaticObject)args[0];
                assert (!StaticObject.isNull(receiver));
                Method.MethodVersion resolvedMethod = InvokeSpecial.methodLookup(method, receiver);
                return indirectCallNode.call(resolvedMethod.getCallTarget(), args);
            }
        }
    }
}

