/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.quick.interop.ForeignArrayUtils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="FALOAD")
@GenerateUncached
public abstract class FloatArrayLoad
extends EspressoNode {
    public abstract float execute(StaticObject var1, int var2);

    @Specialization
    float doWithNullCheck(StaticObject array, int index, @Cached NullCheck nullCheck, @Cached WithoutNullCheck floatArrayLoad) {
        return floatArrayLoad.execute(nullCheck.execute(array), index);
    }

    @NodeInfo(shortName="FALOAD !nullcheck")
    @GenerateUncached
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public abstract float execute(StaticObject var1, int var2);

        @Specialization(guards={"array.isEspressoObject()"})
        float doEspresso(StaticObject array, int index) {
            assert (!StaticObject.isNull(array));
            return this.getContext().getInterpreterToVM().getArrayFloat(this.getLanguage(), index, array);
        }

        @Specialization(guards={"array.isForeignObject()"})
        float doArrayLike(StaticObject array, int index, @CachedLibrary(limit="LIMIT") InteropLibrary arrayInterop, @CachedLibrary(limit="LIMIT") InteropLibrary elemInterop, @Cached BranchProfile exceptionProfile) {
            assert (!StaticObject.isNull(array));
            Meta meta = this.getContext().getMeta();
            Object result = ForeignArrayUtils.readForeignArrayElement(array, index, this.getLanguage(), meta, arrayInterop, exceptionProfile);
            try {
                return elemInterop.asFloat(result);
            }
            catch (UnsupportedMessageException e) {
                exceptionProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Could not cast the foreign array element to float");
            }
        }
    }
}

