/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.quick.interop.Utils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;

@NodeInfo(shortName="ARRAYLENGTH")
@GenerateUncached
public abstract class ArrayLength {
    public abstract byte execute(StaticObject var1);

    @Specialization
    int executeWithNullCheck(StaticObject array, @Cached NullCheck nullCheck, @Cached WithoutNullCheck arrayLength) {
        return arrayLength.execute(nullCheck.execute(array));
    }

    @NodeInfo(shortName="ARRAYLENGTH !nullcheck")
    @GenerateUncached
    @ImportStatic(value={Utils.class})
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public abstract int execute(StaticObject var1);

        @Specialization(guards={"array.isEspressoObject()"})
        int doEspresso(StaticObject array) {
            assert (!StaticObject.isNull(array));
            return InterpreterToVM.arrayLength(array, this.getLanguage());
        }

        @Specialization(guards={"array.isForeignObject()", "isBufferLikeByteArray(language, getMeta(), interop, array)"})
        int doBufferLike(StaticObject array, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile sizeOverflowProfile) {
            assert (!StaticObject.isNull(array));
            try {
                long bufferLength = interop.getBufferSize(array.rawForeignObject(language));
                if (bufferLength > Integer.MAX_VALUE) {
                    sizeOverflowProfile.enter();
                    return Integer.MAX_VALUE;
                }
                return (int)bufferLength;
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        @Specialization(guards={"array.isForeignObject()", "!isBufferLikeByteArray(language, getMeta(), interop, array)", "isArrayLike(interop, array.rawForeignObject(language))"})
        int doArrayLike(StaticObject array, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached BranchProfile sizeOverflowProfile) {
            assert (!StaticObject.isNull(array));
            try {
                long arrayLength = interop.getArraySize(array.rawForeignObject(language));
                if (arrayLength > Integer.MAX_VALUE) {
                    sizeOverflowProfile.enter();
                    return Integer.MAX_VALUE;
                }
                return (int)arrayLength;
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
    }
}

