/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.impl.ContextAccess;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableNode;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNode;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.IntrinsicSubstitutorNode;
import com.oracle.truffle.espresso.nodes.IntrinsifiedNativeMethodNode;
import com.oracle.truffle.espresso.nodes.MethodWithBytecodeNode;
import com.oracle.truffle.espresso.nodes.NativeMethodNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.ForeignStackTraceElementObject;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.substitutions.JavaSubstitution;
import com.oracle.truffle.espresso.vm.FrameCookie;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.util.Arrays;

public abstract class EspressoRootNode
extends RootNode
implements ContextAccess {
    @Node.Child
    protected EspressoInstrumentableRootNode methodNode;
    private static final int SLOT_UNUSED = -2;
    private static final int SLOT_UNINITIALIZED = -1;
    private static final Object MONITOR_SLOT_KEY = new Object();
    private static final Object COOKIE_SLOT_KEY = new Object();
    @CompilerDirectives.CompilationFinal
    private int monitorSlot;
    @CompilerDirectives.CompilationFinal
    private int cookieSlot;
    private final BranchProfile unbalancedMonitorProfile = BranchProfile.create();

    private EspressoRootNode(FrameDescriptor frameDescriptor, EspressoInstrumentableRootNode methodNode, boolean usesMonitors) {
        super((TruffleLanguage)methodNode.getMethodVersion().getMethod().getLanguage(), frameDescriptor);
        this.methodNode = methodNode;
        this.monitorSlot = usesMonitors ? -1 : -2;
        this.cookieSlot = -1;
    }

    private EspressoRootNode(EspressoRootNode split, FrameDescriptor frameDescriptor, EspressoInstrumentableRootNode methodNode) {
        super((TruffleLanguage)methodNode.getMethodVersion().getMethod().getLanguage(), frameDescriptor);
        this.methodNode = methodNode.split();
        this.monitorSlot = split.monitorSlot;
        this.cookieSlot = split.cookieSlot;
    }

    public final Method getMethod() {
        return this.getMethodVersion().getMethod();
    }

    public final Method.MethodVersion getMethodVersion() {
        return this.getMethodNode().getMethodVersion();
    }

    public abstract EspressoRootNode split();

    public boolean isCloningAllowed() {
        return this.getMethodNode().canSplit();
    }

    protected boolean isCloneUninitializedSupported() {
        return this.getMethodNode().canSplit();
    }

    protected EspressoRootNode cloneUninitialized() {
        return this.split();
    }

    @Override
    public final EspressoContext getContext() {
        return this.getMethodNode().getContext();
    }

    @Override
    public Meta getMeta() {
        return this.getContext().getMeta();
    }

    public final String getName() {
        return this.getMethod().getName().toString() + this.getMethod().getRawSignature();
    }

    public String getQualifiedName() {
        return this.getMethod().getDeclaringKlass().getType() + "." + this.getMethod().getName() + this.getMethod().getRawSignature();
    }

    protected Object translateStackTraceElement(TruffleStackTraceElement element) {
        Node location = element.getLocation();
        return new ForeignStackTraceElementObject(this.getMethod(), location != null ? location.getEncapsulatingSourceSection() : this.getEncapsulatingSourceSection());
    }

    public final String toString() {
        return this.getQualifiedName();
    }

    public final SourceSection getSourceSection() {
        return this.getMethodNode().getSourceSection();
    }

    public final SourceSection getEncapsulatingSourceSection() {
        return this.getMethodNode().getEncapsulatingSourceSection();
    }

    public EspressoInstrumentableRootNode getMethodNode() {
        return this.methodNode;
    }

    private static EspressoRootNode create(FrameDescriptor descriptor, EspressoInstrumentableRootNode methodNode) {
        FrameDescriptor desc = descriptor != null ? descriptor : new FrameDescriptor();
        EspressoRootNode result = null;
        result = methodNode.getMethodVersion().isSynchronized() ? new Synchronized(desc, methodNode) : new Default(desc, methodNode);
        assert (EspressoRootNode.hasExactlyOneRootBodyTag(result.getMethodNode())) : result;
        return result;
    }

    public static boolean hasExactlyOneRootBodyTag(EspressoNode body) {
        return NodeUtil.countNodes((Node)body, node -> node instanceof EspressoInstrumentableNode && ((EspressoInstrumentableNode)node).hasTag(StandardTags.RootBodyTag.class)) == 1;
    }

    public static EspressoRootNode createForBytecodes(Method.MethodVersion methodVersion) {
        BytecodeNode bytecodeNode = new BytecodeNode(methodVersion);
        return EspressoRootNode.create(bytecodeNode.getFrameDescriptor(), new MethodWithBytecodeNode(bytecodeNode));
    }

    public static EspressoRootNode createNative(Method.MethodVersion methodVersion, TruffleObject nativeMethod) {
        return EspressoRootNode.create(null, new NativeMethodNode(nativeMethod, methodVersion));
    }

    public static EspressoRootNode createIntrinsifiedNative(Method.MethodVersion methodVersion, CallableFromNative.Factory factory, Object env) {
        return EspressoRootNode.create(null, new IntrinsifiedNativeMethodNode(methodVersion, factory, env));
    }

    public static EspressoRootNode createSubstitution(Method.MethodVersion methodVersion, JavaSubstitution.Factory factory) {
        return EspressoRootNode.create(null, new IntrinsicSubstitutorNode(methodVersion, factory));
    }

    public final int readBCI(Frame frame) {
        return this.getMethodNode().getBci(frame);
    }

    public final void setFrameId(Frame frame, long frameId) {
        this.initCookieSlot(frame);
        frame.setAuxiliarySlot(this.cookieSlot, (Object)FrameCookie.createPrivilegedCookie(frameId));
    }

    public final void setStackWalkAnchor(Frame frame, long anchor) {
        this.initCookieSlot(frame);
        frame.setAuxiliarySlot(this.cookieSlot, (Object)FrameCookie.createStackWalkCookie(anchor));
    }

    private FrameCookie getCookie(Frame frame) {
        this.initCookieSlot(frame);
        return (FrameCookie)frame.getAuxiliarySlot(this.cookieSlot);
    }

    private void initCookieSlot(Frame frame) {
        if (this.cookieSlot == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cookieSlot = frame.getFrameDescriptor().findOrAddAuxiliarySlot(COOKIE_SLOT_KEY);
        }
    }

    public final long readFrameIdOrZero(Frame frame) {
        FrameCookie cookie = this.getCookie(frame);
        if (cookie != null && cookie.isPrivileged()) {
            return cookie.getData();
        }
        return 0L;
    }

    public final long readStackAnchorOrZero(Frame frame) {
        FrameCookie cookie = this.getCookie(frame);
        if (cookie != null && cookie.isStackWalk()) {
            return cookie.getData();
        }
        return 0L;
    }

    public boolean usesMonitors() {
        return this.monitorSlot != -2;
    }

    final void initMonitorStack(VirtualFrame frame, MonitorStack monitorStack) {
        this.initMonitorSlot(frame);
        assert (monitorStack != null);
        frame.setAuxiliarySlot(this.monitorSlot, (Object)monitorStack);
    }

    private void initMonitorSlot(VirtualFrame frame) {
        if (this.monitorSlot == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.monitorSlot = frame.getFrameDescriptor().findOrAddAuxiliarySlot(MONITOR_SLOT_KEY);
        }
    }

    final void monitorExit(VirtualFrame frame, StaticObject monitor) {
        InterpreterToVM.monitorExit(monitor, this.getMeta());
        this.unregisterMonitor(frame, monitor);
    }

    final void unregisterMonitor(VirtualFrame frame, StaticObject monitor) {
        this.getMonitorStack((Frame)frame).exit(monitor, this);
    }

    final void monitorEnter(VirtualFrame frame, StaticObject monitor) {
        InterpreterToVM.monitorEnter(monitor, this.getMeta());
        this.registerMonitor(frame, monitor);
    }

    private void registerMonitor(VirtualFrame frame, StaticObject monitor) {
        this.getMonitorStack((Frame)frame).enter(monitor);
    }

    protected MonitorStack getMonitorStack(Frame frame) {
        assert (this.monitorSlot >= 0);
        return (MonitorStack)frame.getAuxiliarySlot(this.monitorSlot);
    }

    public final StaticObject[] getMonitorsOnFrame(Frame frame) {
        MonitorStack monitorStack = this.getMonitorStack(frame);
        return monitorStack != null ? monitorStack.getMonitors() : StaticObject.EMPTY_ARRAY;
    }

    public final void abortMonitor(VirtualFrame frame) {
        if (this.usesMonitors()) {
            this.getMonitorStack((Frame)frame).abort(this.getMeta());
        }
    }

    public void abortInternalMonitors(Frame frame) {
        this.getMonitorStack(frame).exitInternalMonitors(this.getMeta());
    }

    protected final boolean isTrivial() {
        return !this.methodNode.getMethodVersion().isSynchronized() && this.methodNode.isTrivial();
    }

    static final class Synchronized
    extends EspressoRootNode {
        Synchronized(FrameDescriptor frameDescriptor, EspressoInstrumentableRootNode methodNode) {
            super(frameDescriptor, methodNode, true);
        }

        private Synchronized(Synchronized split) {
            super(split, split.getFrameDescriptor(), split.getMethodNode());
        }

        @Override
        public EspressoRootNode split() {
            return new Synchronized(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(VirtualFrame frame) {
            Object result;
            Method method = this.getMethod();
            assert (method.isSynchronized());
            assert (method.getDeclaringKlass().isInitializedOrInitializing()) : method.getDeclaringKlass();
            this.methodNode.beforeInstumentation(frame);
            StaticObject monitor = method.isStatic() ? method.getDeclaringKlass().mirror() : (StaticObject)frame.getArguments()[0];
            this.enterSynchronized(frame, monitor);
            try {
                result = this.methodNode.execute(frame);
            }
            finally {
                InterpreterToVM.monitorExit(monitor, this.getMeta());
            }
            return result;
        }

        private void enterSynchronized(VirtualFrame frame, StaticObject monitor) {
            MonitorStack monitorStack = new MonitorStack();
            monitorStack.synchronizedMethodMonitor = monitor;
            this.initMonitorStack(frame, monitorStack);
            InterpreterToVM.monitorEnter(monitor, this.getMeta());
        }
    }

    static final class Default
    extends EspressoRootNode {
        Default(FrameDescriptor frameDescriptor, EspressoInstrumentableRootNode methodNode) {
            super(frameDescriptor, methodNode, methodNode.getMethodVersion().usesMonitors());
        }

        private Default(Default split) {
            super(split, split.getFrameDescriptor(), split.getMethodNode());
        }

        @Override
        public EspressoRootNode split() {
            return new Default(this);
        }

        public Object execute(VirtualFrame frame) {
            assert (this.getMethod().getDeclaringKlass().isInitializedOrInitializing() || this.getContext().anyHierarchyChanged()) : this.getMethod().toString() + (String)(this.getMethod().isStatic() ? "" : " recv: " + frame.getArguments()[0].toString());
            if (this.usesMonitors()) {
                this.initMonitorStack(frame, new MonitorStack());
            }
            this.methodNode.beforeInstumentation(frame);
            return this.methodNode.execute(frame);
        }
    }

    private static final class MonitorStack {
        private static final int DEFAULT_CAPACITY = 4;
        private StaticObject synchronizedMethodMonitor;
        private StaticObject[] monitors = new StaticObject[4];
        private int top = 0;
        private int capacity = 4;

        private MonitorStack() {
        }

        private void enter(StaticObject monitor) {
            if (this.top >= this.capacity) {
                this.monitors = Arrays.copyOf(this.monitors, this.capacity <<= 1);
            }
            this.monitors[this.top++] = monitor;
        }

        private void exit(StaticObject monitor, EspressoRootNode node) {
            if (this.top > 0 && monitor == this.monitors[this.top - 1]) {
                this.monitors[--this.top] = null;
            } else {
                node.unbalancedMonitorProfile.enter();
                for (int i = this.top - 1; i >= 0; --i) {
                    if (this.monitors[i] != monitor) continue;
                    System.arraycopy(this.monitors, i + 1, this.monitors, i, this.top - 1 - i);
                    this.monitors[--this.top] = null;
                    return;
                }
            }
        }

        private void abort(Meta meta) {
            for (int i = 0; i < this.top; ++i) {
                StaticObject monitor = this.monitors[i];
                try {
                    InterpreterToVM.monitorExit(monitor, meta);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public void exitInternalMonitors(Meta meta) {
            for (int i = 0; i < this.top; ++i) {
                InterpreterToVM.monitorExit(this.monitors[i], meta);
            }
        }

        private StaticObject[] getMonitors() {
            if (this.synchronizedMethodMonitor == null) {
                return this.monitors;
            }
            StaticObject[] result = new StaticObject[this.monitors.length + 1];
            result[0] = this.synchronizedMethodMonitor;
            System.arraycopy(this.monitors, 0, result, 1, this.monitors.length);
            return result;
        }
    }
}

