/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.analysis.liveness.LivenessAnalysis;
import com.oracle.truffle.espresso.bytecode.BytecodeLookupSwitch;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.bytecode.BytecodeTableSwitch;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.bytecode.MapperBCI;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.BootstrapMethodsAttribute;
import com.oracle.truffle.espresso.classfile.attributes.LineNumberTableAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DoubleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FloatConstant;
import com.oracle.truffle.espresso.classfile.constantpool.IntegerConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.LongConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodHandleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.StringConstant;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.ExceptionHandler;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.nodes.AbstractInstrumentableBytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoBaseStatementNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.nodes.EspressoStatementNode;
import com.oracle.truffle.espresso.nodes.helper.EspressoReferenceArrayStoreNode;
import com.oracle.truffle.espresso.nodes.quick.BaseQuickNode;
import com.oracle.truffle.espresso.nodes.quick.CheckCastQuickNode;
import com.oracle.truffle.espresso.nodes.quick.InstanceOfQuickNode;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.nodes.quick.VolatileArrayAccess;
import com.oracle.truffle.espresso.nodes.quick.interop.ArrayLengthQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ByteArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ByteArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.CharArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.CharArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.DoubleArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.DoubleArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.FloatArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.FloatArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.IntArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.IntArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.LongArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.LongArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.QuickenedGetFieldNode;
import com.oracle.truffle.espresso.nodes.quick.interop.QuickenedPutFieldNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ReferenceArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ReferenceArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ShortArrayLoadQuickNode;
import com.oracle.truffle.espresso.nodes.quick.interop.ShortArrayStoreQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeDynamicCallSiteNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeHandleNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeInterfaceQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeSpecialQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeStaticQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeVirtualQuickNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoExitException;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class BytecodeNode
extends AbstractInstrumentableBytecodeNode
implements BytecodeOSRNode,
GuestAllocator.AllocationProfiler {
    private static final DebugCounter EXECUTED_BYTECODES_COUNT = DebugCounter.create("Executed bytecodes");
    private static final DebugCounter QUICKENED_BYTECODES = DebugCounter.create("Quickened bytecodes");
    private static final DebugCounter QUICKENED_INVOKES = DebugCounter.create("Quickened invokes (excluding INDY)");
    private static final byte TRIVIAL_UNINITIALIZED = -1;
    private static final byte TRIVIAL_NO = 0;
    private static final byte TRIVIAL_YES = 1;
    private static final int REPORT_LOOP_STRIDE = 256;
    @Node.Children
    private BaseQuickNode[] nodes = QuickNode.EMPTY_ARRAY;
    @Node.Children
    private BaseQuickNode[] sparseNodes = QuickNode.EMPTY_ARRAY;
    @Node.Child
    private volatile EspressoReferenceArrayStoreNode refArrayStoreNode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] stackOverflowErrorInfo;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private volatile int[][] jsrBci = null;
    private final BytecodeStream bs;
    @CompilerDirectives.CompilationFinal
    private EspressoRootNode rootNode;
    @Node.Child
    private volatile InstrumentationSupport instrumentation;
    private final Assumption noForeignObjects;
    @CompilerDirectives.CompilationFinal
    private boolean implicitExceptionProfile;
    @CompilerDirectives.CompilationFinal
    private boolean linkageExceptionProfile;
    private final LivenessAnalysis livenessAnalysis;
    private byte trivialBytecodesCache = (byte)-1;
    @CompilerDirectives.CompilationFinal
    private Object osrMetadata;
    private final FrameDescriptor frameDescriptor;
    private final Method.MethodVersion methodVersion;

    public BytecodeNode(Method.MethodVersion methodVersion) {
        CompilerAsserts.neverPartOfCompilation();
        Method method = methodVersion.getMethod();
        assert (method.hasBytecodes());
        this.methodVersion = methodVersion;
        this.bs = new BytecodeStream(methodVersion.getCode());
        this.stackOverflowErrorInfo = method.getSOEHandlerInfo();
        this.frameDescriptor = EspressoFrame.createFrameDescriptor(methodVersion.getMaxLocals(), methodVersion.getMaxStackSize());
        this.noForeignObjects = Truffle.getRuntime().createAssumption("noForeignObjects");
        this.implicitExceptionProfile = false;
        this.livenessAnalysis = LivenessAnalysis.analyze(methodVersion);
        this.trivialBytecodesCache = (byte)(method.getOriginalCode().length <= method.getContext().getEspressoEnv().TrivialMethodSize ? -1 : 0);
    }

    public FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    Source getSource() {
        return this.getMethodVersion().getSource();
    }

    public SourceSection getSourceSectionAtBCI(int bci) {
        Source s = this.getSource();
        if (s == null) {
            return null;
        }
        LineNumberTableAttribute table = this.getMethodVersion().getLineNumberTableAttribute();
        if (table == LineNumberTableAttribute.EMPTY) {
            return null;
        }
        int line = table.getLineNumber(bci);
        return s.createSection(line);
    }

    @ExplodeLoop
    private void initArguments(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        boolean hasReceiver = !this.getMethod().isStatic();
        int receiverSlot = hasReceiver ? 1 : 0;
        int curSlot = 0;
        if (hasReceiver) {
            assert (StaticObject.notNull((StaticObject)arguments[0])) : "null receiver in init arguments !";
            StaticObject receiver = (StaticObject)arguments[0];
            EspressoFrame.setLocalObject((Frame)frame, curSlot, receiver);
            this.checkNoForeignObjectAssumption(receiver);
            curSlot += JavaKind.Object.getSlotCount();
        }
        Symbol<Symbol.Type>[] methodSignature = this.getMethod().getParsedSignature();
        int argCount = Signatures.parameterCount(methodSignature);
        CompilerAsserts.partialEvaluationConstant((int)argCount);
        for (int i = 0; i < argCount; ++i) {
            Symbol<Symbol.Type> argType = Signatures.parameterType(methodSignature, i);
            switch (argType.byteAt(0)) {
                case 90: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, (Boolean)arguments[i + receiverSlot] != false ? 1 : 0);
                    break;
                }
                case 66: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, ((Byte)arguments[i + receiverSlot]).byteValue());
                    break;
                }
                case 83: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, ((Short)arguments[i + receiverSlot]).shortValue());
                    break;
                }
                case 67: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, ((Character)arguments[i + receiverSlot]).charValue());
                    break;
                }
                case 73: {
                    EspressoFrame.setLocalInt((Frame)frame, curSlot, (Integer)arguments[i + receiverSlot]);
                    break;
                }
                case 70: {
                    EspressoFrame.setLocalFloat((Frame)frame, curSlot, ((Float)arguments[i + receiverSlot]).floatValue());
                    break;
                }
                case 74: {
                    EspressoFrame.setLocalLong((Frame)frame, curSlot, (Long)arguments[i + receiverSlot]);
                    ++curSlot;
                    break;
                }
                case 68: {
                    EspressoFrame.setLocalDouble((Frame)frame, curSlot, (Double)arguments[i + receiverSlot]);
                    ++curSlot;
                    break;
                }
                case 76: 
                case 91: {
                    StaticObject argument = (StaticObject)arguments[i + receiverSlot];
                    EspressoFrame.setLocalObject((Frame)frame, curSlot, argument);
                    this.checkNoForeignObjectAssumption(argument);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
            ++curSlot;
        }
    }

    public void checkNoForeignObjectAssumption(StaticObject object) {
        if (this.noForeignObjects.isValid() && object.isForeignObject()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.noForeignObjects.invalidate();
        }
    }

    @Override
    void initializeFrame(VirtualFrame frame) {
        this.initArguments(frame);
    }

    public Object executeOSR(VirtualFrame osrFrame, int target, Object interpreterState) {
        EspressoOSRInterpreterState state = (EspressoOSRInterpreterState)interpreterState;
        return this.executeBodyFromBCI(osrFrame, target, state.top, state.nextStatementIndex, true);
    }

    public Object getOSRMetadata() {
        return this.osrMetadata;
    }

    public void setOSRMetadata(Object osrMetadata) {
        this.osrMetadata = osrMetadata;
    }

    public void prepareOSR(int target) {
        this.getRoot();
    }

    public void copyIntoOSRFrame(VirtualFrame frame, VirtualFrame parentFrame, int target, Object entryMetadata) {
        super.copyIntoOSRFrame(frame, parentFrame, target, entryMetadata);
        EspressoFrame.setBCI((Frame)frame, target);
    }

    public void restoreParentFrame(VirtualFrame osrFrame, VirtualFrame parentFrame) {
        super.restoreParentFrame(osrFrame, parentFrame);
        EspressoFrame.setBCI((Frame)parentFrame, this.getBci((Frame)osrFrame));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int startTop = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
        return this.executeBodyFromBCI(frame, 0, startTop, 0, false);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    @HostCompilerDirectives.BytecodeInterpreterSwitch
    Object executeBodyFromBCI(VirtualFrame frame, int startBCI, int startTop, int startStatementIndex, boolean isOSR) {
        CompilerAsserts.partialEvaluationConstant((int)startBCI);
        int curBCI = startBCI;
        int top = startTop;
        InstrumentationSupport instrument = this.instrumentation;
        int statementIndex = -1;
        int nextStatementIndex = startStatementIndex;
        boolean skipEntryInstrumentation = isOSR;
        boolean skipLivenessActions = false;
        Counter loopCount = new Counter();
        EspressoFrame.setBCI((Frame)frame, curBCI);
        if (instrument != null && !skipEntryInstrumentation) {
            instrument.notifyEntry(frame, this);
        }
        if (!isOSR) {
            this.livenessAnalysis.onStart(frame, skipLivenessActions);
        }
        block149: while (true) {
            int curOpcode = this.bs.opcode(curBCI);
            EXECUTED_BYTECODES_COUNT.inc();
            try {
                CompilerAsserts.partialEvaluationConstant((int)top);
                CompilerAsserts.partialEvaluationConstant((int)curBCI);
                CompilerAsserts.partialEvaluationConstant((boolean)skipEntryInstrumentation);
                CompilerAsserts.partialEvaluationConstant((int)curOpcode);
                CompilerAsserts.partialEvaluationConstant((int)statementIndex);
                CompilerAsserts.partialEvaluationConstant((int)nextStatementIndex);
                if (instrument != null || Bytecodes.canTrap(curOpcode)) {
                    EspressoFrame.setBCI((Frame)frame, curBCI);
                }
                if (instrument != null) {
                    if (!skipEntryInstrumentation) {
                        instrument.notifyStatement(frame, statementIndex, nextStatementIndex);
                    }
                    skipEntryInstrumentation = false;
                    statementIndex = nextStatementIndex;
                }
                switch (curOpcode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        EspressoFrame.putObject((Frame)frame, top, StaticObject.NULL);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        EspressoFrame.putInt((Frame)frame, top, curOpcode - 3);
                        break;
                    }
                    case 9: 
                    case 10: {
                        EspressoFrame.putLong((Frame)frame, top, curOpcode - 9);
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        EspressoFrame.putFloat((Frame)frame, top, curOpcode - 11);
                        break;
                    }
                    case 14: 
                    case 15: {
                        EspressoFrame.putDouble((Frame)frame, top, curOpcode - 14);
                        break;
                    }
                    case 16: {
                        EspressoFrame.putInt((Frame)frame, top, this.bs.readByte(curBCI));
                        break;
                    }
                    case 17: {
                        EspressoFrame.putInt((Frame)frame, top, this.bs.readShort(curBCI));
                        break;
                    }
                    case 18: {
                        this.putPoolConstant(frame, top, this.bs.readCPI1(curBCI), curOpcode);
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.putPoolConstant(frame, top, this.bs.readCPI2(curBCI), curOpcode);
                        break;
                    }
                    case 21: {
                        EspressoFrame.putInt((Frame)frame, top, EspressoFrame.getLocalInt((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 22: {
                        EspressoFrame.putLong((Frame)frame, top, EspressoFrame.getLocalLong((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 23: {
                        EspressoFrame.putFloat((Frame)frame, top, EspressoFrame.getLocalFloat((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 24: {
                        EspressoFrame.putDouble((Frame)frame, top, EspressoFrame.getLocalDouble((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 25: {
                        EspressoFrame.putObject((Frame)frame, top, EspressoFrame.getLocalObject((Frame)frame, this.bs.readLocalIndex1(curBCI)));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        EspressoFrame.putInt((Frame)frame, top, EspressoFrame.getLocalInt((Frame)frame, curOpcode - 26));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        EspressoFrame.putLong((Frame)frame, top, EspressoFrame.getLocalLong((Frame)frame, curOpcode - 30));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        EspressoFrame.putFloat((Frame)frame, top, EspressoFrame.getLocalFloat((Frame)frame, curOpcode - 34));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        EspressoFrame.putDouble((Frame)frame, top, EspressoFrame.getLocalDouble((Frame)frame, curOpcode - 38));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 42: {
                        EspressoFrame.putObject((Frame)frame, top, EspressoFrame.getLocalObject((Frame)frame, 0));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 43: 
                    case 44: 
                    case 45: {
                        EspressoFrame.putObject((Frame)frame, top, EspressoFrame.getLocalObject((Frame)frame, curOpcode - 42));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: {
                        this.arrayLoad(frame, top, curBCI, curOpcode);
                        break;
                    }
                    case 50: {
                        this.arrayLoad(frame, top, curBCI, 50);
                        this.checkNoForeignObjectAssumption(EspressoFrame.peekObject((Frame)frame, top - 2));
                        break;
                    }
                    case 54: {
                        EspressoFrame.setLocalInt((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popInt((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 55: {
                        EspressoFrame.setLocalLong((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popLong((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 56: {
                        EspressoFrame.setLocalFloat((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popFloat((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 57: {
                        EspressoFrame.setLocalDouble((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popDouble((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 58: {
                        EspressoFrame.setLocalObjectOrReturnAddress((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.popReturnAddressOrObject((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        EspressoFrame.setLocalInt((Frame)frame, curOpcode - 59, EspressoFrame.popInt((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: {
                        EspressoFrame.setLocalLong((Frame)frame, curOpcode - 63, EspressoFrame.popLong((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        EspressoFrame.setLocalFloat((Frame)frame, curOpcode - 67, EspressoFrame.popFloat((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        EspressoFrame.setLocalDouble((Frame)frame, curOpcode - 71, EspressoFrame.popDouble((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: {
                        EspressoFrame.setLocalObjectOrReturnAddress((Frame)frame, curOpcode - 75, EspressoFrame.popReturnAddressOrObject((Frame)frame, top - 1));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        this.arrayStore(frame, top, curBCI, curOpcode);
                        break;
                    }
                    case 88: {
                        EspressoFrame.clear((Frame)frame, top - 1);
                        EspressoFrame.clear((Frame)frame, top - 2);
                        break;
                    }
                    case 87: {
                        EspressoFrame.clear((Frame)frame, top - 1);
                        break;
                    }
                    case 89: {
                        EspressoFrame.dup1((Frame)frame, top);
                        break;
                    }
                    case 90: {
                        EspressoFrame.dupx1((Frame)frame, top);
                        break;
                    }
                    case 91: {
                        EspressoFrame.dupx2((Frame)frame, top);
                        break;
                    }
                    case 92: {
                        EspressoFrame.dup2((Frame)frame, top);
                        break;
                    }
                    case 93: {
                        EspressoFrame.dup2x1((Frame)frame, top);
                        break;
                    }
                    case 94: {
                        EspressoFrame.dup2x2((Frame)frame, top);
                        break;
                    }
                    case 95: {
                        EspressoFrame.swapSingle((Frame)frame, top);
                        break;
                    }
                    case 96: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) + EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 97: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) + EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 98: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, EspressoFrame.popFloat((Frame)frame, top - 1) + EspressoFrame.popFloat((Frame)frame, top - 2));
                        break;
                    }
                    case 99: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, EspressoFrame.popDouble((Frame)frame, top - 1) + EspressoFrame.popDouble((Frame)frame, top - 3));
                        break;
                    }
                    case 100: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 2) - EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 101: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 3) - EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 102: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, EspressoFrame.popFloat((Frame)frame, top - 2) - EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 103: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, EspressoFrame.popDouble((Frame)frame, top - 3) - EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 104: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) * EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 105: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) * EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 106: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, EspressoFrame.popFloat((Frame)frame, top - 1) * EspressoFrame.popFloat((Frame)frame, top - 2));
                        break;
                    }
                    case 107: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, EspressoFrame.popDouble((Frame)frame, top - 1) * EspressoFrame.popDouble((Frame)frame, top - 3));
                        break;
                    }
                    case 108: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.divInt(this.checkNonZero(EspressoFrame.popInt((Frame)frame, top - 1)), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 109: {
                        EspressoFrame.putLong((Frame)frame, top - 4, BytecodeNode.divLong(this.checkNonZero(EspressoFrame.popLong((Frame)frame, top - 1)), EspressoFrame.popLong((Frame)frame, top - 3)));
                        break;
                    }
                    case 110: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, BytecodeNode.divFloat(EspressoFrame.popFloat((Frame)frame, top - 1), EspressoFrame.popFloat((Frame)frame, top - 2)));
                        break;
                    }
                    case 111: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, BytecodeNode.divDouble(EspressoFrame.popDouble((Frame)frame, top - 1), EspressoFrame.popDouble((Frame)frame, top - 3)));
                        break;
                    }
                    case 112: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.remInt(this.checkNonZero(EspressoFrame.popInt((Frame)frame, top - 1)), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 113: {
                        EspressoFrame.putLong((Frame)frame, top - 4, BytecodeNode.remLong(this.checkNonZero(EspressoFrame.popLong((Frame)frame, top - 1)), EspressoFrame.popLong((Frame)frame, top - 3)));
                        break;
                    }
                    case 114: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, BytecodeNode.remFloat(EspressoFrame.popFloat((Frame)frame, top - 1), EspressoFrame.popFloat((Frame)frame, top - 2)));
                        break;
                    }
                    case 115: {
                        EspressoFrame.putDouble((Frame)frame, top - 4, BytecodeNode.remDouble(EspressoFrame.popDouble((Frame)frame, top - 1), EspressoFrame.popDouble((Frame)frame, top - 3)));
                        break;
                    }
                    case 116: {
                        EspressoFrame.putInt((Frame)frame, top - 1, -EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 117: {
                        EspressoFrame.putLong((Frame)frame, top - 2, -EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 118: {
                        EspressoFrame.putFloat((Frame)frame, top - 1, -EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 119: {
                        EspressoFrame.putDouble((Frame)frame, top - 2, -EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 120: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.shiftLeftInt(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 121: {
                        EspressoFrame.putLong((Frame)frame, top - 3, BytecodeNode.shiftLeftLong(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popLong((Frame)frame, top - 2)));
                        break;
                    }
                    case 122: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.shiftRightSignedInt(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 123: {
                        EspressoFrame.putLong((Frame)frame, top - 3, BytecodeNode.shiftRightSignedLong(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popLong((Frame)frame, top - 2)));
                        break;
                    }
                    case 124: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.shiftRightUnsignedInt(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popInt((Frame)frame, top - 2)));
                        break;
                    }
                    case 125: {
                        EspressoFrame.putLong((Frame)frame, top - 3, BytecodeNode.shiftRightUnsignedLong(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popLong((Frame)frame, top - 2)));
                        break;
                    }
                    case 126: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) & EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 127: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) & EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 128: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) | EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 129: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) | EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 130: {
                        EspressoFrame.putInt((Frame)frame, top - 2, EspressoFrame.popInt((Frame)frame, top - 1) ^ EspressoFrame.popInt((Frame)frame, top - 2));
                        break;
                    }
                    case 131: {
                        EspressoFrame.putLong((Frame)frame, top - 4, EspressoFrame.popLong((Frame)frame, top - 1) ^ EspressoFrame.popLong((Frame)frame, top - 3));
                        break;
                    }
                    case 132: {
                        EspressoFrame.setLocalInt((Frame)frame, this.bs.readLocalIndex1(curBCI), EspressoFrame.getLocalInt((Frame)frame, this.bs.readLocalIndex1(curBCI)) + this.bs.readIncrement1(curBCI));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        break;
                    }
                    case 133: {
                        EspressoFrame.putLong((Frame)frame, top - 1, EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 134: {
                        EspressoFrame.putFloat((Frame)frame, top - 1, EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 135: {
                        EspressoFrame.putDouble((Frame)frame, top - 1, EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 136: {
                        EspressoFrame.putInt((Frame)frame, top - 2, (int)EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 137: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 138: {
                        EspressoFrame.putDouble((Frame)frame, top - 2, EspressoFrame.popLong((Frame)frame, top - 1));
                        break;
                    }
                    case 139: {
                        EspressoFrame.putInt((Frame)frame, top - 1, (int)EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 140: {
                        EspressoFrame.putLong((Frame)frame, top - 1, (long)EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 141: {
                        EspressoFrame.putDouble((Frame)frame, top - 1, EspressoFrame.popFloat((Frame)frame, top - 1));
                        break;
                    }
                    case 142: {
                        EspressoFrame.putInt((Frame)frame, top - 2, (int)EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 143: {
                        EspressoFrame.putLong((Frame)frame, top - 2, (long)EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 144: {
                        EspressoFrame.putFloat((Frame)frame, top - 2, (float)EspressoFrame.popDouble((Frame)frame, top - 1));
                        break;
                    }
                    case 145: {
                        EspressoFrame.putInt((Frame)frame, top - 1, (byte)EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 146: {
                        EspressoFrame.putInt((Frame)frame, top - 1, (char)EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 147: {
                        EspressoFrame.putInt((Frame)frame, top - 1, (short)EspressoFrame.popInt((Frame)frame, top - 1));
                        break;
                    }
                    case 148: {
                        EspressoFrame.putInt((Frame)frame, top - 4, BytecodeNode.compareLong(EspressoFrame.popLong((Frame)frame, top - 1), EspressoFrame.popLong((Frame)frame, top - 3)));
                        break;
                    }
                    case 149: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.compareFloatLess(EspressoFrame.popFloat((Frame)frame, top - 1), EspressoFrame.popFloat((Frame)frame, top - 2)));
                        break;
                    }
                    case 150: {
                        EspressoFrame.putInt((Frame)frame, top - 2, BytecodeNode.compareFloatGreater(EspressoFrame.popFloat((Frame)frame, top - 1), EspressoFrame.popFloat((Frame)frame, top - 2)));
                        break;
                    }
                    case 151: {
                        EspressoFrame.putInt((Frame)frame, top - 4, BytecodeNode.compareDoubleLess(EspressoFrame.popDouble((Frame)frame, top - 1), EspressoFrame.popDouble((Frame)frame, top - 3)));
                        break;
                    }
                    case 152: {
                        EspressoFrame.putInt((Frame)frame, top - 4, BytecodeNode.compareDoubleGreater(EspressoFrame.popDouble((Frame)frame, top - 1), EspressoFrame.popDouble((Frame)frame, top - 3)));
                        break;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        if (BytecodeNode.takeBranchPrimitive1(EspressoFrame.popInt((Frame)frame, top - 1), curOpcode)) {
                            int targetBCI = this.bs.readBranchDest2(curBCI);
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(158), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block149;
                        }
                        break;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        if (BytecodeNode.takeBranchPrimitive2(EspressoFrame.popInt((Frame)frame, top - 1), EspressoFrame.popInt((Frame)frame, top - 2), curOpcode)) {
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, this.bs.readBranchDest2(curBCI), top += Bytecodes.stackEffectOf(164), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = this.bs.readBranchDest2(curBCI);
                            continue block149;
                        }
                        break;
                    }
                    case 165: 
                    case 166: {
                        if (this.takeBranchRef2(EspressoFrame.popObject((Frame)frame, top - 1), EspressoFrame.popObject((Frame)frame, top - 2), curOpcode)) {
                            int targetBCI = this.bs.readBranchDest2(curBCI);
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(166), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block149;
                        }
                        break;
                    }
                    case 198: 
                    case 199: {
                        if (BytecodeNode.takeBranchRef1(EspressoFrame.popObject((Frame)frame, top - 1), curOpcode)) {
                            int targetBCI = this.bs.readBranchDest2(curBCI);
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(199), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block149;
                        }
                        break;
                    }
                    case 167: {
                        int targetBCI = this.bs.readBranchDest2(curBCI);
                        nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top, statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block149;
                    }
                    case 200: {
                        int targetBCI = this.bs.readBranchDest4(curBCI);
                        nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top, statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block149;
                    }
                    case 168: {
                        EspressoFrame.putReturnAddress((Frame)frame, top, this.bs.nextBCI(curBCI));
                        int targetBCI = this.bs.readBranchDest2(curBCI);
                        nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(168), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block149;
                    }
                    case 201: {
                        EspressoFrame.putReturnAddress((Frame)frame, top, this.bs.nextBCI(curBCI));
                        int targetBCI = this.bs.readBranchDest4(curBCI);
                        nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(201), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block149;
                    }
                    case 169: {
                        int[] knownRets;
                        int retOpBci = curBCI;
                        int targetBCI = EspressoFrame.getLocalReturnAddress((Frame)frame, this.bs.readLocalIndex1(curBCI));
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        int[][] knownTargets = this.jsrBci;
                        if (knownTargets == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.atomic(() -> {
                                if (this.jsrBci == null) {
                                    this.jsrBci = new int[this.bs.endBCI()][];
                                }
                            });
                            knownTargets = this.jsrBci;
                        }
                        if ((knownRets = (int[])VolatileArrayAccess.volatileRead(knownTargets, retOpBci)) == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.atomic(() -> {
                                if (VolatileArrayAccess.volatileRead(this.jsrBci, retOpBci) != null) {
                                    return;
                                }
                                int[] targets = new int[]{targetBCI};
                                VolatileArrayAccess.volatileWrite(this.jsrBci, retOpBci, targets);
                            });
                            knownRets = (int[])VolatileArrayAccess.volatileRead(knownTargets, retOpBci);
                        }
                        assert (knownRets != null);
                        for (int jsr : knownRets) {
                            if (jsr != targetBCI) continue;
                            CompilerAsserts.partialEvaluationConstant((int)jsr);
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, jsr, top += Bytecodes.stackEffectOf(169), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = jsr;
                            continue block149;
                        }
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.atomic(() -> {
                            int[] currentRets;
                            for (int jsr : currentRets = (int[])VolatileArrayAccess.volatileRead(this.jsrBci, retOpBci)) {
                                if (jsr != targetBCI) continue;
                                return;
                            }
                            int[] updatedTargets = Arrays.copyOf(currentRets, currentRets.length + 1);
                            updatedTargets[updatedTargets.length - 1] = targetBCI;
                            VolatileArrayAccess.volatileWrite(this.jsrBci, retOpBci, updatedTargets);
                        });
                        nextStatementIndex = this.beforeJumpChecks(frame, retOpBci, targetBCI, top += Bytecodes.stackEffectOf(169), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block149;
                    }
                    case 170: {
                        int targetBCI;
                        int index = EspressoFrame.popInt((Frame)frame, top - 1);
                        BytecodeTableSwitch switchHelper = BytecodeTableSwitch.INSTANCE;
                        int low = switchHelper.lowKey(this.bs, curBCI);
                        int high = switchHelper.highKey(this.bs, curBCI);
                        assert (low <= high);
                        if (CompilerDirectives.inInterpreter()) {
                            int targetBCI2 = low <= index && index <= high ? switchHelper.targetAt(this.bs, curBCI, index - low) : switchHelper.defaultTarget(this.bs, curBCI);
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI2, top += Bytecodes.stackEffectOf(170), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI2;
                            continue block149;
                        }
                        for (int i = low; i != high + 1; ++i) {
                            if (i != index) continue;
                            targetBCI = switchHelper.targetAt(this.bs, curBCI, i - low);
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(170), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block149;
                        }
                        int targetBCI3 = switchHelper.defaultTarget(this.bs, curBCI);
                        nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI3, top += Bytecodes.stackEffectOf(170), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI3;
                        continue block149;
                    }
                    case 171: {
                        int key = EspressoFrame.popInt((Frame)frame, top - 1);
                        BytecodeLookupSwitch switchHelper = BytecodeLookupSwitch.INSTANCE;
                        int low = 0;
                        int high = switchHelper.numberOfCases(this.bs, curBCI) - 1;
                        while (low <= high) {
                            int mid = low + high >>> 1;
                            int midVal = switchHelper.keyAt(this.bs, curBCI, mid);
                            if (midVal < key) {
                                low = mid + 1;
                                continue;
                            }
                            if (midVal > key) {
                                high = mid - 1;
                                continue;
                            }
                            int targetBCI = curBCI + switchHelper.offsetAt(this.bs, curBCI, mid);
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(171), statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block149;
                        }
                        int targetBCI = switchHelper.defaultTarget(this.bs, curBCI);
                        nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, top += Bytecodes.stackEffectOf(171), statementIndex, instrument, loopCount, skipLivenessActions);
                        curBCI = targetBCI;
                        continue block149;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        if (CompilerDirectives.hasNextTier() && loopCount.value > 0) {
                            LoopNode.reportLoopCount((Node)this, (int)loopCount.value);
                        }
                        Object returnValue = this.getReturnValueAsObject(frame, top);
                        if (instrument != null) {
                            instrument.notifyReturn(frame, statementIndex, returnValue);
                        }
                        return returnValue;
                    }
                    case 178: 
                    case 180: {
                        top += this.getField(frame, top, this.resolveField(curOpcode, this.readOriginalCPI(curBCI)), curBCI, curOpcode, statementIndex);
                        break;
                    }
                    case 179: 
                    case 181: {
                        top += this.putField(frame, top, this.resolveField(curOpcode, this.readOriginalCPI(curBCI)), curBCI, curOpcode, statementIndex);
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        top += this.quickenInvoke(frame, top, curBCI, curOpcode, statementIndex);
                        break;
                    }
                    case 187: {
                        Klass klass = this.resolveType(187, this.bs.readCPI2(curBCI));
                        EspressoFrame.putObject((Frame)frame, top, this.newReferenceObject(klass));
                        break;
                    }
                    case 188: {
                        byte jvmPrimitiveType = this.bs.readByte(curBCI);
                        int length = EspressoFrame.popInt((Frame)frame, top - 1);
                        EspressoFrame.putObject((Frame)frame, top - 1, this.newPrimitiveArray(jvmPrimitiveType, length));
                        break;
                    }
                    case 189: {
                        EspressoFrame.putObject((Frame)frame, top - 1, this.newReferenceArray(this.resolveType(189, this.bs.readCPI2(curBCI)), EspressoFrame.popInt((Frame)frame, top - 1)));
                        break;
                    }
                    case 190: {
                        this.arrayLength(frame, top, curBCI);
                        break;
                    }
                    case 191: {
                        throw this.getMeta().throwException(this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 1)));
                    }
                    case 192: {
                        StaticObject receiver = EspressoFrame.peekObject((Frame)frame, top - 1);
                        if (!StaticObject.isNull(receiver)) {
                            if (receiver.getKlass() == this.resolveType(192, this.readOriginalCPI(curBCI))) break;
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.quickenCheckCast(frame, top, curBCI, 192);
                        }
                        break;
                    }
                    case 193: {
                        StaticObject receiver = EspressoFrame.popObject((Frame)frame, top - 1);
                        if (StaticObject.isNull(receiver)) {
                            EspressoFrame.putInt((Frame)frame, top - 1, 0);
                            break;
                        }
                        if (receiver.getKlass() == this.resolveType(193, this.readOriginalCPI(curBCI))) {
                            EspressoFrame.putInt((Frame)frame, top - 1, 1);
                            break;
                        }
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        EspressoFrame.putObject((Frame)frame, top - 1, receiver);
                        this.quickenInstanceOf(frame, top, curBCI, 193);
                        break;
                    }
                    case 194: {
                        this.getRoot().monitorEnter(frame, this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 1)));
                        break;
                    }
                    case 195: {
                        this.getRoot().monitorExit(frame, this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 1)));
                        break;
                    }
                    case 196: {
                        int targetBCI;
                        int wideOpcode = this.bs.opcode(curBCI + 1);
                        switch (wideOpcode) {
                            case 21: {
                                EspressoFrame.putInt((Frame)frame, top, EspressoFrame.getLocalInt((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 22: {
                                EspressoFrame.putLong((Frame)frame, top, EspressoFrame.getLocalLong((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 23: {
                                EspressoFrame.putFloat((Frame)frame, top, EspressoFrame.getLocalFloat((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 24: {
                                EspressoFrame.putDouble((Frame)frame, top, EspressoFrame.getLocalDouble((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 25: {
                                EspressoFrame.putObject((Frame)frame, top, EspressoFrame.getLocalObject((Frame)frame, this.bs.readLocalIndex2(curBCI)));
                                break;
                            }
                            case 54: {
                                EspressoFrame.setLocalInt((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popInt((Frame)frame, top - 1));
                                break;
                            }
                            case 55: {
                                EspressoFrame.setLocalLong((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popLong((Frame)frame, top - 1));
                                break;
                            }
                            case 56: {
                                EspressoFrame.setLocalFloat((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popFloat((Frame)frame, top - 1));
                                break;
                            }
                            case 57: {
                                EspressoFrame.setLocalDouble((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popDouble((Frame)frame, top - 1));
                                break;
                            }
                            case 58: {
                                EspressoFrame.setLocalObjectOrReturnAddress((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.popReturnAddressOrObject((Frame)frame, top - 1));
                                break;
                            }
                            case 132: {
                                EspressoFrame.setLocalInt((Frame)frame, this.bs.readLocalIndex2(curBCI), EspressoFrame.getLocalInt((Frame)frame, this.bs.readLocalIndex2(curBCI)) + this.bs.readIncrement2(curBCI));
                                break;
                            }
                            case 169: {
                                int[] knownRets;
                                int retOpBci = curBCI;
                                targetBCI = EspressoFrame.getLocalReturnAddress((Frame)frame, this.bs.readLocalIndex2(curBCI));
                                this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                                int[][] knownTargets = this.jsrBci;
                                if (knownTargets == null) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    this.atomic(() -> {
                                        if (this.jsrBci == null) {
                                            this.jsrBci = new int[this.bs.endBCI()][];
                                        }
                                    });
                                    knownTargets = this.jsrBci;
                                }
                                if ((knownRets = (int[])VolatileArrayAccess.volatileRead(knownTargets, retOpBci)) == null) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    this.atomic(() -> {
                                        if (VolatileArrayAccess.volatileRead(this.jsrBci, retOpBci) != null) {
                                            return;
                                        }
                                        int[] targets = new int[]{targetBCI};
                                        VolatileArrayAccess.volatileWrite(this.jsrBci, retOpBci, targets);
                                    });
                                    knownRets = (int[])VolatileArrayAccess.volatileRead(knownTargets, retOpBci);
                                }
                                assert (knownRets != null);
                                for (int jsr : knownRets) {
                                    if (jsr != targetBCI) continue;
                                    CompilerAsserts.partialEvaluationConstant((int)jsr);
                                    nextStatementIndex = this.beforeJumpChecks(frame, curBCI, jsr, top += Bytecodes.stackEffectOf(169), statementIndex, instrument, loopCount, skipLivenessActions);
                                    curBCI = jsr;
                                    continue block149;
                                }
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.atomic(() -> {
                                    int[] currentRets;
                                    for (int jsr : currentRets = (int[])VolatileArrayAccess.volatileRead(this.jsrBci, retOpBci)) {
                                        if (jsr != targetBCI) continue;
                                        return;
                                    }
                                    int[] updatedTargets = Arrays.copyOf(currentRets, currentRets.length + 1);
                                    updatedTargets[updatedTargets.length - 1] = targetBCI;
                                    VolatileArrayAccess.volatileWrite(this.jsrBci, retOpBci, updatedTargets);
                                });
                                nextStatementIndex = this.beforeJumpChecks(frame, retOpBci, targetBCI, top += Bytecodes.stackEffectOf(169), statementIndex, instrument, loopCount, skipLivenessActions);
                                curBCI = targetBCI;
                                continue block149;
                            }
                            default: {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                throw EspressoError.shouldNotReachHere(Bytecodes.nameOf(curOpcode));
                            }
                        }
                        this.livenessAnalysis.performPostBCI(frame, curBCI, skipLivenessActions);
                        int targetBCI4 = this.bs.nextBCI(curBCI);
                        this.livenessAnalysis.performOnEdge(frame, curBCI, targetBCI4, skipLivenessActions);
                        top += Bytecodes.stackEffectOf(wideOpcode);
                        curBCI = targetBCI4;
                        continue block149;
                    }
                    case 197: {
                        top += this.allocateMultiArray(frame, top, this.resolveType(197, this.bs.readCPI2(curBCI)), this.bs.readUByte(curBCI + 3));
                        break;
                    }
                    case 202: {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw EspressoError.unimplemented(Bytecodes.nameOf(curOpcode) + " not supported.");
                    }
                    case 186: {
                        top += this.quickenInvokeDynamic(frame, top, curBCI, 186);
                        break;
                    }
                    case 203: {
                        if (this.bs.currentVolatileBC(curBCI) != 203) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            continue block149;
                        }
                        BaseQuickNode quickNode = this.nodes[this.bs.readCPI2(curBCI)];
                        if (quickNode.removedByRedefinition()) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            quickNode = this.getBaseQuickNode(curBCI, top, statementIndex, quickNode);
                        }
                        top += quickNode.execute(frame);
                        break;
                    }
                    case 204: {
                        top += this.sparseNodes[curBCI].execute(frame);
                        break;
                    }
                    default: {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw EspressoError.shouldNotReachHere(Bytecodes.nameOf(curOpcode));
                    }
                }
            }
            catch (AbstractTruffleException | OutOfMemoryError | StackOverflowError e) {
                EspressoException wrappedException;
                if (instrument != null && e instanceof EspressoException) {
                    instrument.notifyExceptionAt(frame, e, statementIndex);
                }
                CompilerAsserts.partialEvaluationConstant((int)curBCI);
                if (e == this.getContext().getStackOverflow() || e instanceof StackOverflowError) {
                    CompilerDirectives.transferToInterpreter();
                    EspressoException wrappedStackOverflowError = null;
                    wrappedStackOverflowError = e == this.getContext().getStackOverflow() ? (EspressoException)((Object)e) : this.getContext().getStackOverflow();
                    if (this.stackOverflowErrorInfo != null) {
                        for (int i = 0; i < this.stackOverflowErrorInfo.length; i += 3) {
                            if (curBCI < this.stackOverflowErrorInfo[i] || curBCI >= this.stackOverflowErrorInfo[i + 1]) continue;
                            this.clearOperandStack(frame, top);
                            top = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
                            EspressoFrame.putObject((Frame)frame, top, wrappedStackOverflowError.getGuestException());
                            int targetBCI = this.stackOverflowErrorInfo[i + 2];
                            nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, ++top, statementIndex, instrument, loopCount, skipLivenessActions);
                            curBCI = targetBCI;
                            continue block149;
                        }
                    }
                    if (instrument != null) {
                        instrument.notifyExceptionAt(frame, (Throwable)((Object)wrappedStackOverflowError), statementIndex);
                    }
                    if (CompilerDirectives.hasNextTier() && loopCount.value > 0) {
                        LoopNode.reportLoopCount((Node)this, (int)loopCount.value);
                    }
                    throw wrappedStackOverflowError;
                }
                if (e instanceof EspressoException) {
                    wrappedException = (EspressoException)((Object)e);
                } else if (e instanceof AbstractTruffleException) {
                    if (e instanceof EspressoExitException) {
                        CompilerDirectives.transferToInterpreter();
                        this.getRoot().abortMonitor(frame);
                        throw e;
                    }
                    assert (this.getContext().getEspressoEnv().Polyglot);
                    this.getMeta().polyglot.ForeignException.safeInitialize();
                    wrappedException = EspressoException.wrap(this.getAllocator().createForeignException(this.getContext(), e, InteropLibrary.getUncached((Object)e)), this.getMeta());
                } else {
                    assert (e instanceof OutOfMemoryError);
                    CompilerDirectives.transferToInterpreter();
                    wrappedException = this.getContext().getOutOfMemory();
                }
                ExceptionHandler[] handlers = this.getMethodVersion().getExceptionHandlers();
                ExceptionHandler handler = null;
                for (ExceptionHandler toCheck : handlers) {
                    CompilerAsserts.partialEvaluationConstant((Object)toCheck);
                    if (curBCI < toCheck.getStartBCI() || curBCI >= toCheck.getEndBCI()) continue;
                    Klass catchType = null;
                    if (!toCheck.isCatchAll()) {
                        catchType = this.resolveType(193, (char)toCheck.catchTypeCPI());
                    }
                    CompilerAsserts.partialEvaluationConstant(catchType);
                    if (catchType != null && !InterpreterToVM.instanceOf(wrappedException.getGuestException(), catchType)) continue;
                    handler = toCheck;
                    break;
                }
                if (handler != null) {
                    this.clearOperandStack(frame, top);
                    top = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
                    this.checkNoForeignObjectAssumption(wrappedException.getGuestException());
                    EspressoFrame.putObject((Frame)frame, top, wrappedException.getGuestException());
                    int targetBCI = handler.getHandlerBCI();
                    nextStatementIndex = this.beforeJumpChecks(frame, curBCI, targetBCI, ++top, statementIndex, instrument, loopCount, skipLivenessActions);
                    curBCI = targetBCI;
                    continue;
                }
                if (instrument != null) {
                    instrument.notifyExceptionAt(frame, (Throwable)((Object)wrappedException), statementIndex);
                }
                if (CompilerDirectives.hasNextTier() && loopCount.value > 0) {
                    LoopNode.reportLoopCount((Node)this, (int)loopCount.value);
                }
                throw e;
            }
            catch (EspressoOSRReturnException e) {
                if (CompilerDirectives.hasNextTier() && loopCount.value > 0) {
                    LoopNode.reportLoopCount((Node)this, (int)loopCount.value);
                }
                return e.getResultOrRethrow();
            }
            assert (curOpcode != 196 && curOpcode != 171 && curOpcode != 170);
            int targetBCI = curBCI + Bytecodes.lengthOf(curOpcode);
            this.livenessAnalysis.performOnEdge(frame, curBCI, targetBCI, skipLivenessActions);
            if (instrument != null) {
                nextStatementIndex = instrument.getNextStatementIndex(statementIndex, targetBCI);
            }
            top += Bytecodes.stackEffectOf(curOpcode);
            curBCI = targetBCI;
        }
    }

    @Override
    public void enterNewReference() {
        this.enterImplicitExceptionProfile();
    }

    @Override
    public void enterNewArray() {
        this.enterImplicitExceptionProfile();
    }

    @Override
    public void enterNewMultiArray() {
        this.enterImplicitExceptionProfile();
    }

    private StaticObject newReferenceObject(Klass klass) {
        assert (!klass.isPrimitive()) : "Verifier guarantee";
        GuestAllocator.AllocationChecks.checkCanAllocateNewReference(this.getMeta(), klass, true, this);
        return this.getAllocator().createNew((ObjectKlass)klass);
    }

    private StaticObject newPrimitiveArray(byte jvmPrimitiveType, int length) {
        GuestAllocator.AllocationChecks.checkCanAllocateArray(this.getMeta(), length, this);
        return this.getAllocator().createNewPrimitiveArray(this.getMeta(), jvmPrimitiveType, length);
    }

    private StaticObject newReferenceArray(Klass componentType, int length) {
        GuestAllocator.AllocationChecks.checkCanAllocateArray(this.getMeta(), length, this);
        return this.getAllocator().createNewReferenceArray(componentType, length);
    }

    private BaseQuickNode getBaseQuickNode(int curBCI, int top, int statementIndex, BaseQuickNode quickNode) {
        quickNode.getContext().getClassRedefinition().check();
        BaseQuickNode result = quickNode;
        result = (BaseQuickNode)this.atomic(() -> {
            BaseQuickNode toInsert;
            if (quickNode != this.nodes[this.readCPI(curBCI)]) {
                return this.nodes[this.readCPI(curBCI)];
            }
            BytecodeStream original = new BytecodeStream(this.getMethodVersion().getCodeAttribute().getOriginalCode());
            char cpi = original.readCPI(curBCI);
            int nodeOpcode = original.currentBC(curBCI);
            Method resolutionSeed = this.resolveMethodNoCache(nodeOpcode, cpi);
            this.nodes[this.readCPI((int)curBCI)] = toInsert = (BaseQuickNode)this.insert(this.dispatchQuickened(top, curBCI, cpi, nodeOpcode, statementIndex, resolutionSeed, this.getContext().getEspressoEnv().bytecodeLevelInlining));
            return toInsert;
        });
        return result;
    }

    private Object getReturnValueAsObject(VirtualFrame frame, int top) {
        Symbol<Symbol.Type> returnType = Signatures.returnType(this.getMethod().getParsedSignature());
        switch (returnType.byteAt(0)) {
            case 90: {
                return this.stackIntToBoolean(EspressoFrame.popInt((Frame)frame, top - 1));
            }
            case 66: {
                return (byte)EspressoFrame.popInt((Frame)frame, top - 1);
            }
            case 83: {
                return (short)EspressoFrame.popInt((Frame)frame, top - 1);
            }
            case 67: {
                return Character.valueOf((char)EspressoFrame.popInt((Frame)frame, top - 1));
            }
            case 73: {
                return EspressoFrame.popInt((Frame)frame, top - 1);
            }
            case 74: {
                return EspressoFrame.popLong((Frame)frame, top - 1);
            }
            case 70: {
                return Float.valueOf(EspressoFrame.popFloat((Frame)frame, top - 1));
            }
            case 68: {
                return EspressoFrame.popDouble((Frame)frame, top - 1);
            }
            case 86: {
                return StaticObject.NULL;
            }
            case 76: 
            case 91: {
                return EspressoFrame.popObject((Frame)frame, top - 1);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    @ExplodeLoop
    private void clearOperandStack(VirtualFrame frame, int top) {
        int stackStart = EspressoFrame.startingStackOffset(this.getMethodVersion().getMaxLocals());
        for (int slot = top - 1; slot >= stackStart; --slot) {
            EspressoFrame.clear((Frame)frame, slot);
        }
    }

    @Override
    Method.MethodVersion getMethodVersion() {
        return this.methodVersion;
    }

    private ObjectKlass getDeclaringKlass() {
        return this.methodVersion.getDeclaringKlass();
    }

    private EspressoRootNode getRoot() {
        if (this.rootNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.rootNode = (EspressoRootNode)this.getRootNode();
        }
        return this.rootNode;
    }

    @Override
    public int getBci(Frame frame) {
        return EspressoFrame.getBCI(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        InstrumentationSupport info = this.instrumentation;
        if (info == null && materializedTags.contains(StandardTags.StatementTag.class)) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                info = this.instrumentation;
                if (info == null) {
                    this.generifyBytecodeLevelInlining();
                    this.instrumentation = info = (InstrumentationSupport)this.insert(new InstrumentationSupport(this.getMethodVersion()));
                    this.notifyInserted(info);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this;
    }

    private static boolean takeBranchRef1(StaticObject operand, int opcode) {
        assert (198 <= opcode && opcode <= 199);
        switch (opcode) {
            case 198: {
                return StaticObject.isNull(operand);
            }
            case 199: {
                return StaticObject.notNull(operand);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("expected IFNULL or IFNONNULL bytecode");
    }

    private static boolean takeBranchPrimitive1(int operand, int opcode) {
        assert (153 <= opcode && opcode <= 158);
        switch (opcode) {
            case 153: {
                return operand == 0;
            }
            case 154: {
                return operand != 0;
            }
            case 155: {
                return operand < 0;
            }
            case 156: {
                return operand >= 0;
            }
            case 157: {
                return operand > 0;
            }
            case 158: {
                return operand <= 0;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("expecting IFEQ,IFNE,IFLT,IFGE,IFGT,IFLE");
    }

    private static boolean takeBranchPrimitive2(int operand1, int operand2, int opcode) {
        assert (159 <= opcode && opcode <= 164);
        switch (opcode) {
            case 159: {
                return operand1 == operand2;
            }
            case 160: {
                return operand1 != operand2;
            }
            case 161: {
                return operand1 > operand2;
            }
            case 162: {
                return operand1 <= operand2;
            }
            case 163: {
                return operand1 < operand2;
            }
            case 164: {
                return operand1 >= operand2;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("expecting IF_ICMPEQ,IF_ICMPNE,IF_ICMPLT,IF_ICMPGE,IF_ICMPGT,IF_ICMPLE");
    }

    private boolean takeBranchRef2(StaticObject operand1, StaticObject operand2, int opcode) {
        assert (165 <= opcode && opcode <= 166);
        if (this.noForeignObjects.isValid()) {
            switch (opcode) {
                case 165: {
                    return operand1 == operand2;
                }
                case 166: {
                    return operand1 != operand2;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("expecting IF_ACMPEQ,IF_ACMPNE");
        }
        boolean equal = InterpreterToVM.referenceIdentityEqual(operand1, operand2, this.getLanguage());
        switch (opcode) {
            case 165: {
                return equal;
            }
            case 166: {
                return !equal;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("expecting IF_ACMPEQ,IF_ACMPNE");
    }

    private void arrayLength(VirtualFrame frame, int top, int curBCI) {
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 1));
        if (this.noForeignObjects.isValid() || array.isEspressoObject()) {
            EspressoFrame.putInt((Frame)frame, top - 1, InterpreterToVM.arrayLength(array, this.getLanguage()));
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoFrame.putObject((Frame)frame, top - 1, array);
            this.quickenArrayLength(frame, top, curBCI);
        }
    }

    private void arrayLoad(VirtualFrame frame, int top, int curBCI, int loadOpcode) {
        assert (46 <= loadOpcode && loadOpcode <= 53);
        CompilerAsserts.partialEvaluationConstant((int)loadOpcode);
        int index = EspressoFrame.popInt((Frame)frame, top - 1);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 2));
        if (this.noForeignObjects.isValid() || array.isEspressoObject()) {
            EspressoLanguage language = this.getLanguage();
            switch (loadOpcode) {
                case 51: {
                    EspressoFrame.putInt((Frame)frame, top - 2, this.getInterpreterToVM().getArrayByte(language, index, array, this));
                    break;
                }
                case 53: {
                    EspressoFrame.putInt((Frame)frame, top - 2, this.getInterpreterToVM().getArrayShort(language, index, array, this));
                    break;
                }
                case 52: {
                    EspressoFrame.putInt((Frame)frame, top - 2, this.getInterpreterToVM().getArrayChar(language, index, array, this));
                    break;
                }
                case 46: {
                    EspressoFrame.putInt((Frame)frame, top - 2, this.getInterpreterToVM().getArrayInt(language, index, array, this));
                    break;
                }
                case 48: {
                    EspressoFrame.putFloat((Frame)frame, top - 2, this.getInterpreterToVM().getArrayFloat(language, index, array, this));
                    break;
                }
                case 47: {
                    EspressoFrame.putLong((Frame)frame, top - 2, this.getInterpreterToVM().getArrayLong(language, index, array, this));
                    break;
                }
                case 49: {
                    EspressoFrame.putDouble((Frame)frame, top - 2, this.getInterpreterToVM().getArrayDouble(language, index, array, this));
                    break;
                }
                case 50: {
                    EspressoFrame.putObject((Frame)frame, top - 2, this.getInterpreterToVM().getArrayObject(language, index, array, this));
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoFrame.putInt((Frame)frame, top - 1, index);
            EspressoFrame.putObject((Frame)frame, top - 2, array);
            this.quickenArrayLoad(frame, top, curBCI, loadOpcode);
        }
    }

    private void arrayStore(VirtualFrame frame, int top, int curBCI, int storeOpcode) {
        assert (79 <= storeOpcode && storeOpcode <= 86);
        CompilerAsserts.partialEvaluationConstant((int)storeOpcode);
        int offset = storeOpcode == 80 || storeOpcode == 82 ? 2 : 1;
        int index = EspressoFrame.popInt((Frame)frame, top - 1 - offset);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, top - 2 - offset));
        if (this.noForeignObjects.isValid() || array.isEspressoObject()) {
            EspressoLanguage language = this.getLanguage();
            switch (storeOpcode) {
                case 84: {
                    this.getInterpreterToVM().setArrayByte(language, (byte)EspressoFrame.popInt((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 86: {
                    this.getInterpreterToVM().setArrayShort(language, (short)EspressoFrame.popInt((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 85: {
                    this.getInterpreterToVM().setArrayChar(language, (char)EspressoFrame.popInt((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 79: {
                    this.getInterpreterToVM().setArrayInt(language, EspressoFrame.popInt((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 81: {
                    this.getInterpreterToVM().setArrayFloat(language, EspressoFrame.popFloat((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 80: {
                    this.getInterpreterToVM().setArrayLong(language, EspressoFrame.popLong((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 82: {
                    this.getInterpreterToVM().setArrayDouble(language, EspressoFrame.popDouble((Frame)frame, top - 1), index, array, this);
                    break;
                }
                case 83: {
                    this.referenceArrayStore(frame, top, index, array);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere();
                }
            }
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoFrame.putInt((Frame)frame, top - 1 - offset, index);
            EspressoFrame.putObject((Frame)frame, top - 2 - offset, array);
            this.quickenArrayStore(frame, top, curBCI, storeOpcode);
        }
    }

    private void referenceArrayStore(VirtualFrame frame, int top, int index, StaticObject array) {
        if (this.refArrayStoreNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.atomic(() -> {
                if (this.refArrayStoreNode == null) {
                    this.refArrayStoreNode = (EspressoReferenceArrayStoreNode)this.insert(new EspressoReferenceArrayStoreNode());
                }
            });
        }
        this.refArrayStoreNode.arrayStore(this.getLanguage(), this.getContext().getMeta(), EspressoFrame.popObject((Frame)frame, top - 1), index, array);
    }

    private int beforeJumpChecks(VirtualFrame frame, int curBCI, int targetBCI, int top, int statementIndex, InstrumentationSupport instrument, Counter loopCount, boolean skipLivenessActions) {
        int nextStatementIndex;
        CompilerAsserts.partialEvaluationConstant((int)targetBCI);
        int n = nextStatementIndex = instrument == null ? 0 : instrument.getStatementIndexAfterJump(statementIndex, curBCI, targetBCI);
        if (targetBCI <= curBCI) {
            TruffleSafepoint.poll((Node)this);
            if (CompilerDirectives.hasNextTier() && ++loopCount.value >= 256) {
                LoopNode.reportLoopCount((Node)this, (int)256);
                loopCount.value = 0;
            }
            if (CompilerDirectives.inInterpreter() && BytecodeOSRNode.pollOSRBackEdge((BytecodeOSRNode)this)) {
                Object osrResult;
                Runnable beforeTransfer = instrument != null && statementIndex != nextStatementIndex ? () -> instrument.notifyStatement(frame, statementIndex, nextStatementIndex) : null;
                this.livenessAnalysis.catchUpOSR(frame, targetBCI, skipLivenessActions);
                try {
                    osrResult = BytecodeOSRNode.tryOSR((BytecodeOSRNode)this, (int)targetBCI, (Object)new EspressoOSRInterpreterState(top, nextStatementIndex), (Runnable)beforeTransfer, (VirtualFrame)frame);
                }
                catch (Throwable any) {
                    throw new EspressoOSRReturnException(any);
                }
                if (osrResult != null) {
                    throw new EspressoOSRReturnException(osrResult);
                }
            }
        }
        this.livenessAnalysis.performOnEdge(frame, curBCI, targetBCI, skipLivenessActions);
        return nextStatementIndex;
    }

    @ExplodeLoop
    private ExceptionHandler resolveExceptionHandlers(int bci, StaticObject ex) {
        CompilerAsserts.partialEvaluationConstant((int)bci);
        ExceptionHandler[] handlers = this.getMethodVersion().getExceptionHandlers();
        ExceptionHandler resolved = null;
        for (ExceptionHandler toCheck : handlers) {
            if (bci < toCheck.getStartBCI() || bci >= toCheck.getEndBCI()) continue;
            Klass catchType = null;
            if (!toCheck.isCatchAll()) {
                catchType = this.resolveType(193, (char)toCheck.catchTypeCPI());
            }
            if (catchType != null && !InterpreterToVM.instanceOf(ex, catchType)) continue;
            resolved = toCheck;
            break;
        }
        return resolved;
    }

    private void putPoolConstant(VirtualFrame frame, int top, char cpi, int opcode) {
        assert (opcode == 18 || opcode == 19 || opcode == 20);
        RuntimeConstantPool pool = this.getConstantPool();
        PoolConstant constant = pool.at(cpi);
        if (constant instanceof IntegerConstant) {
            assert (opcode == 18 || opcode == 19);
            EspressoFrame.putInt((Frame)frame, top, ((IntegerConstant)constant).value());
        } else if (constant instanceof LongConstant) {
            assert (opcode == 20);
            EspressoFrame.putLong((Frame)frame, top, ((LongConstant)constant).value());
        } else if (constant instanceof DoubleConstant) {
            assert (opcode == 20);
            EspressoFrame.putDouble((Frame)frame, top, ((DoubleConstant)constant).value());
        } else if (constant instanceof FloatConstant) {
            assert (opcode == 18 || opcode == 19);
            EspressoFrame.putFloat((Frame)frame, top, ((FloatConstant)constant).value());
        } else if (constant instanceof StringConstant) {
            assert (opcode == 18 || opcode == 19);
            StaticObject internedString = pool.resolvedStringAt(cpi);
            EspressoFrame.putObject((Frame)frame, top, internedString);
        } else if (constant instanceof ClassConstant) {
            assert (opcode == 18 || opcode == 19);
            Klass klass = pool.resolvedKlassAt(this.getDeclaringKlass(), cpi);
            EspressoFrame.putObject((Frame)frame, top, klass.mirror());
        } else if (constant instanceof MethodHandleConstant) {
            assert (opcode == 18 || opcode == 19);
            StaticObject methodHandle = pool.resolvedMethodHandleAt(this.getDeclaringKlass(), cpi);
            EspressoFrame.putObject((Frame)frame, top, methodHandle);
        } else if (constant instanceof MethodTypeConstant) {
            assert (opcode == 18 || opcode == 19);
            StaticObject methodType = pool.resolvedMethodTypeAt(this.getDeclaringKlass(), cpi);
            EspressoFrame.putObject((Frame)frame, top, methodType);
        } else if (constant instanceof DynamicConstant) {
            DynamicConstant.Resolved dynamicConstant = pool.resolvedDynamicConstantAt(this.getDeclaringKlass(), cpi);
            dynamicConstant.putResolved(frame, top, this);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.unimplemented(constant.toString());
        }
    }

    protected RuntimeConstantPool getConstantPool() {
        return this.getMethodVersion().getPool();
    }

    @CompilerDirectives.TruffleBoundary
    private BootstrapMethodsAttribute getBootstrapMethods() {
        return (BootstrapMethodsAttribute)this.getDeclaringKlass().getAttribute(BootstrapMethodsAttribute.NAME);
    }

    private char readCPI(int curBCI) {
        assert (!Bytecodes.isQuickenable(this.bs.currentBC(curBCI)) || this.lockIsHeld()) : "Reading the CPI for a quickenable bytecode must be done under the BytecodeNode lock. Please obtain the lock, or use readOriginalCPI.";
        return this.bs.readCPI(curBCI);
    }

    private char readOriginalCPI(int curBCI) {
        return BytecodeStream.readCPI(this.getMethodVersion().getOriginalCode(), curBCI);
    }

    private char addQuickNode(BaseQuickNode node) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(node);
        this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + 1);
        int nodeIndex = this.nodes.length - 1;
        this.nodes[nodeIndex] = (BaseQuickNode)this.insert(node);
        return (char)nodeIndex;
    }

    private void addSlimQuickNode(BaseQuickNode node, int curBCI) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(node);
        if (this.sparseNodes == QuickNode.EMPTY_ARRAY) {
            this.sparseNodes = new QuickNode[this.getMethodVersion().getCode().length];
        }
        this.sparseNodes[curBCI] = (BaseQuickNode)this.insert(node);
    }

    private void patchBci(int bci, byte opcode, char nodeIndex) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Bytecodes.isQuickened(opcode));
        byte[] code = this.getMethodVersion().getCode();
        byte oldBC = code[bci];
        if (opcode == -53) {
            code[bci + 1] = (byte)(nodeIndex >> 8 & 0xFF);
            code[bci + 2] = (byte)(nodeIndex & 0xFF);
        }
        for (int i = Bytecodes.lengthOf(opcode); i < Bytecodes.lengthOf(oldBC); ++i) {
            code[bci + i] = 0;
        }
        VolatileArrayAccess.volatileWrite(code, bci, opcode);
    }

    private BaseQuickNode injectQuick(int curBCI, BaseQuickNode quick, int opcode) {
        QUICKENED_BYTECODES.inc();
        CompilerAsserts.neverPartOfCompilation();
        if (opcode == 204) {
            this.addSlimQuickNode(quick, curBCI);
            this.patchBci(curBCI, (byte)-52, '\u0000');
        } else {
            char nodeIndex = this.addQuickNode(quick);
            this.patchBci(curBCI, (byte)-53, nodeIndex);
        }
        return quick;
    }

    private BaseQuickNode tryPatchQuick(int curBCI, Supplier<BaseQuickNode> newQuickNode) {
        return (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 203) {
                return this.nodes[this.readCPI(curBCI)];
            }
            return this.injectQuick(curBCI, (BaseQuickNode)newQuickNode.get(), 203);
        });
    }

    private int quickenCheckCast(VirtualFrame frame, int top, int curBCI, int opcode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (opcode == 192);
        BaseQuickNode quick = this.tryPatchQuick(curBCI, () -> new CheckCastQuickNode(this.resolveType(192, this.readCPI(curBCI)), top, curBCI));
        quick.execute(frame);
        assert (Bytecodes.stackEffectOf(opcode) == 0);
        return 0;
    }

    private int quickenInstanceOf(VirtualFrame frame, int top, int curBCI, int opcode) {
        CompilerAsserts.neverPartOfCompilation();
        assert (opcode == 193);
        BaseQuickNode quick = this.tryPatchQuick(curBCI, () -> new InstanceOfQuickNode(this.resolveType(193, this.readCPI(curBCI)), top, curBCI));
        quick.execute(frame);
        assert (Bytecodes.stackEffectOf(opcode) == 0);
        return 0;
    }

    private int quickenInvoke(VirtualFrame frame, int top, int curBCI, int opcode, int statementIndex) {
        QUICKENED_INVOKES.inc();
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (Bytecodes.isInvoke(opcode));
        BaseQuickNode quick = this.tryPatchQuick(curBCI, () -> {
            char cpi = this.readCPI(curBCI);
            Method resolutionSeed = this.resolveMethod(opcode, cpi);
            return this.dispatchQuickened(top, curBCI, cpi, opcode, statementIndex, resolutionSeed, this.getContext().getEspressoEnv().bytecodeLevelInlining);
        });
        return quick.execute(frame) - Bytecodes.stackEffectOf(opcode);
    }

    public int reQuickenInvoke(VirtualFrame frame, int top, int opcode, int curBCI, int statementIndex, Method resolutionSeed) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Bytecodes.isInvoke(opcode));
        BaseQuickNode invoke = this.generifyInlinedMethodNode(top, opcode, curBCI, statementIndex, resolutionSeed);
        return invoke.execute(frame);
    }

    public int replaceQuickAt(VirtualFrame frame, int opcode, int curBCI, BaseQuickNode old, BaseQuickNode replacement) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Bytecodes.isInvoke(opcode));
        BaseQuickNode invoke = (BaseQuickNode)this.atomic(() -> {
            assert (this.bs.currentBC(curBCI) == 203);
            char nodeIndex = this.readCPI(curBCI);
            BaseQuickNode currentQuick = this.nodes[nodeIndex];
            if (currentQuick != old) {
                return currentQuick;
            }
            this.nodes[nodeIndex] = (BaseQuickNode)currentQuick.replace(replacement);
            return replacement;
        });
        return invoke.execute(frame);
    }

    public BaseQuickNode generifyInlinedMethodNode(int top, int opcode, int curBCI, int statementIndex, Method resolutionSeed) {
        CompilerAsserts.neverPartOfCompilation();
        return (BaseQuickNode)this.atomic(() -> {
            assert (this.bs.currentBC(curBCI) == 203);
            char nodeIndex = this.readCPI(curBCI);
            BaseQuickNode currentQuick = this.nodes[nodeIndex];
            if (!(currentQuick instanceof InlinedMethodNode)) {
                return currentQuick;
            }
            BaseQuickNode invoke = this.dispatchQuickened(top, curBCI, this.readOriginalCPI(curBCI), opcode, statementIndex, resolutionSeed, false);
            this.nodes[nodeIndex] = (BaseQuickNode)currentQuick.replace(invoke);
            return invoke;
        });
    }

    private void generifyBytecodeLevelInlining() {
        this.atomic(() -> {
            for (BaseQuickNode quick : this.nodes) {
                if (!(quick instanceof InlinedMethodNode)) continue;
                this.notifyInserted(((InlinedMethodNode)quick).revertToGeneric(this));
            }
        });
    }

    public int quickenGetField(VirtualFrame frame, int top, int curBCI, int opcode, int statementIndex, Field field) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (opcode == 180);
        BaseQuickNode getField = this.tryPatchQuick(curBCI, () -> new QuickenedGetFieldNode(top, curBCI, statementIndex, field));
        return getField.execute(frame) - Bytecodes.stackEffectOf(opcode);
    }

    public int quickenPutField(VirtualFrame frame, int top, int curBCI, int opcode, int statementIndex, Field field) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (opcode == 181);
        BaseQuickNode putField = this.tryPatchQuick(curBCI, () -> new QuickenedPutFieldNode(top, curBCI, field, statementIndex));
        return putField.execute(frame) - Bytecodes.stackEffectOf(opcode);
    }

    private int quickenArrayLength(VirtualFrame frame, int top, int curBCI) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        BaseQuickNode arrayLengthNode = (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 204) {
                return this.sparseNodes[curBCI];
            }
            return this.injectQuick(curBCI, new ArrayLengthQuickNode(top, curBCI), 204);
        });
        return arrayLengthNode.execute(frame) - Bytecodes.stackEffectOf(190);
    }

    private int quickenArrayLoad(VirtualFrame frame, int top, int curBCI, int loadOpcode) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (46 <= loadOpcode && loadOpcode <= 53);
        BaseQuickNode arrayLoadNode = (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 204) {
                return this.sparseNodes[curBCI];
            }
            return this.injectQuick(curBCI, switch (loadOpcode) {
                case 51 -> new ByteArrayLoadQuickNode(top, curBCI);
                case 53 -> new ShortArrayLoadQuickNode(top, curBCI);
                case 52 -> new CharArrayLoadQuickNode(top, curBCI);
                case 46 -> new IntArrayLoadQuickNode(top, curBCI);
                case 48 -> new FloatArrayLoadQuickNode(top, curBCI);
                case 47 -> new LongArrayLoadQuickNode(top, curBCI);
                case 49 -> new DoubleArrayLoadQuickNode(top, curBCI);
                case 50 -> new ReferenceArrayLoadQuickNode(top, curBCI);
                default -> {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("unexpected kind");
                }
            }, 204);
        });
        return arrayLoadNode.execute(frame) - Bytecodes.stackEffectOf(loadOpcode);
    }

    private int quickenArrayStore(VirtualFrame frame, int top, int curBCI, int storeOpcode) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (79 <= storeOpcode && storeOpcode <= 86);
        BaseQuickNode arrayStoreNode = (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 204) {
                return this.sparseNodes[curBCI];
            }
            return this.injectQuick(curBCI, switch (storeOpcode) {
                case 84 -> new ByteArrayStoreQuickNode(top, curBCI);
                case 86 -> new ShortArrayStoreQuickNode(top, curBCI);
                case 85 -> new CharArrayStoreQuickNode(top, curBCI);
                case 79 -> new IntArrayStoreQuickNode(top, curBCI);
                case 81 -> new FloatArrayStoreQuickNode(top, curBCI);
                case 80 -> new LongArrayStoreQuickNode(top, curBCI);
                case 82 -> new DoubleArrayStoreQuickNode(top, curBCI);
                case 83 -> new ReferenceArrayStoreQuickNode(top, curBCI);
                default -> {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.shouldNotReachHere("unexpected kind");
                }
            }, 204);
        });
        return arrayStoreNode.execute(frame) - Bytecodes.stackEffectOf(storeOpcode);
    }

    private BaseQuickNode dispatchQuickened(int top, int curBCI, char cpi, int opcode, int statementIndex, Method resolutionSeed, boolean allowBytecodeInlining) {
        InvokeQuickNode invoke;
        boolean tryBytecodeLevelInlining;
        Method resolved = resolutionSeed;
        int resolvedOpCode = opcode;
        switch (opcode) {
            case 184: {
                if (resolved.isStatic()) break;
                this.enterLinkageExceptionProfile();
                throw this.throwBoundary(this.getMeta().java_lang_IncompatibleClassChangeError);
            }
            case 185: {
                if (resolved.isStatic() || this.getContext().getJavaVersion().java8OrEarlier() && resolved.isPrivate()) {
                    this.enterLinkageExceptionProfile();
                    throw this.throwBoundary(this.getMeta().java_lang_IncompatibleClassChangeError);
                }
                if (resolved.getITableIndex() >= 0) break;
                if (resolved.isPrivate()) {
                    assert (this.getJavaVersion().java9OrLater());
                    resolvedOpCode = 183;
                    break;
                }
                resolvedOpCode = 182;
                break;
            }
            case 182: {
                if (resolved.isStatic()) {
                    this.enterLinkageExceptionProfile();
                    throw this.throwBoundary(this.getMeta().java_lang_IncompatibleClassChangeError);
                }
                if (!resolved.isFinalFlagSet() && !resolved.getDeclaringKlass().isFinalFlagSet() && !resolved.isPrivate()) break;
                resolvedOpCode = 183;
                break;
            }
            case 183: {
                if (resolved.isConstructor() && resolved.getDeclaringKlass().getName() != this.getConstantPool().methodAt(cpi).getHolderKlassName(this.getConstantPool())) {
                    this.enterLinkageExceptionProfile();
                    throw this.throwBoundary(this.getMeta().java_lang_NoSuchMethodError, "%s.%s%s", resolved.getDeclaringKlass().getNameAsString(), resolved.getNameAsString(), resolved.getSignatureAsString());
                }
                if (resolved.isStatic()) {
                    this.enterLinkageExceptionProfile();
                    throw this.throwBoundary(this.getMeta().java_lang_IncompatibleClassChangeError);
                }
                if (resolved.isConstructor()) break;
                ObjectKlass declaringKlass = this.getMethod().getDeclaringKlass();
                Klass symbolicRef = ((MethodRefConstant.Indexes)this.getConstantPool().methodAt(cpi)).getResolvedHolderKlass(declaringKlass, this.getConstantPool());
                if (symbolicRef.isInterface() || symbolicRef == declaringKlass || ((Klass)declaringKlass).getSuperKlass() == null || symbolicRef == ((Klass)declaringKlass).getSuperKlass() || !symbolicRef.isAssignableFrom(declaringKlass)) break;
                resolved = ((Klass)declaringKlass).getSuperKlass().lookupMethod(resolved.getName(), resolved.getRawSignature(), Klass.LookupMode.INSTANCE_ONLY);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.unimplemented("Quickening for " + Bytecodes.nameOf(opcode));
            }
        }
        assert (this.lockIsHeld());
        boolean bl = tryBytecodeLevelInlining = this.instrumentation == null && allowBytecodeInlining;
        if (tryBytecodeLevelInlining && (invoke = InlinedMethodNode.createFor(resolved, top, resolvedOpCode, curBCI, statementIndex)) != null) {
            return invoke;
        }
        if (resolved.isPolySignatureIntrinsic()) {
            invoke = new InvokeHandleNode(resolved, this.getDeclaringKlass(), top, curBCI);
        } else {
            switch (resolvedOpCode) {
                case 184: {
                    invoke = new InvokeStaticQuickNode(resolved, top, curBCI);
                    break;
                }
                case 185: {
                    invoke = new InvokeInterfaceQuickNode(resolved, top, curBCI);
                    break;
                }
                case 182: {
                    invoke = new InvokeVirtualQuickNode(resolved, top, curBCI);
                    break;
                }
                case 183: {
                    invoke = new InvokeSpecialQuickNode(resolved, top, curBCI);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw EspressoError.unimplemented("Quickening for " + Bytecodes.nameOf(resolvedOpCode));
                }
            }
        }
        return invoke;
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException throwBoundary(ObjectKlass exceptionKlass) {
        throw this.getMeta().throwException(exceptionKlass);
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException throwBoundary(ObjectKlass exceptionKlass, String message) {
        throw this.getMeta().throwExceptionWithMessage(exceptionKlass, message);
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException throwBoundary(ObjectKlass exceptionKlass, String messageFormat, String ... args) {
        throw this.getMeta().throwExceptionWithMessage(exceptionKlass, String.format(Locale.ENGLISH, messageFormat, (Object[])args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int quickenInvokeDynamic(VirtualFrame frame, int top, int curBCI, int opcode) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (186 == opcode);
        RuntimeConstantPool pool = this.getConstantPool();
        BaseQuickNode quick = null;
        int indyIndex = -1;
        Lock lock = this.getLock();
        try {
            lock.lock();
            if (this.bs.currentVolatileBC(curBCI) == 203) {
                quick = this.nodes[this.readCPI(curBCI)];
            } else {
                indyIndex = this.readCPI(curBCI);
            }
        }
        finally {
            lock.unlock();
        }
        if (quick != null) {
            return quick.execute(frame) - Bytecodes.stackEffectOf(opcode);
        }
        InvokeDynamicConstant.CallSiteLink link = pool.linkInvokeDynamic(this.getMethod().getDeclaringKlass(), indyIndex);
        quick = (BaseQuickNode)this.atomic(() -> {
            if (this.bs.currentVolatileBC(curBCI) == 203) {
                return this.nodes[this.readCPI(curBCI)];
            }
            return this.injectQuick(curBCI, new InvokeDynamicCallSiteNode(link.getMemberName(), link.getUnboxedAppendix(), link.getParsedSignature(), this.getMeta(), top, curBCI), 203);
        });
        return quick.execute(frame) - Bytecodes.stackEffectOf(opcode);
    }

    public Klass resolveType(int opcode, char cpi) {
        assert (opcode == 193 || opcode == 192 || opcode == 187 || opcode == 189 || opcode == 197);
        return this.getConstantPool().resolvedKlassAt(this.getDeclaringKlass(), cpi);
    }

    public Method resolveMethod(int opcode, char cpi) {
        assert (Bytecodes.isInvoke(opcode));
        return this.getConstantPool().resolvedMethodAt(this.getDeclaringKlass(), cpi);
    }

    private Method resolveMethodNoCache(int opcode, char cpi) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Bytecodes.isInvoke(opcode));
        return this.getConstantPool().resolvedMethodAtNoCache(this.getDeclaringKlass(), cpi);
    }

    private Field resolveField(int opcode, char cpi) {
        assert (opcode == 180 || opcode == 178 || opcode == 181 || opcode == 179);
        Field field = this.getConstantPool().resolvedFieldAt(this.getMethod().getDeclaringKlass(), cpi);
        if (field.needsReResolution()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getMethod().getContext().getClassRedefinition().check();
            field = this.getConstantPool().resolveFieldAndUpdate(this.getMethod().getDeclaringKlass(), cpi, field);
        }
        return field;
    }

    @ExplodeLoop
    private int allocateMultiArray(VirtualFrame frame, int top, Klass klass, int allocatedDimensions) {
        assert (klass.isArray());
        CompilerAsserts.partialEvaluationConstant((int)allocatedDimensions);
        CompilerAsserts.partialEvaluationConstant((Object)klass);
        int[] dimensions = new int[allocatedDimensions];
        for (int i = 0; i < allocatedDimensions; ++i) {
            dimensions[i] = EspressoFrame.popInt((Frame)frame, top - allocatedDimensions + i);
        }
        Klass component = ((ArrayKlass)klass).getComponentType();
        GuestAllocator.AllocationChecks.checkCanAllocateMultiArray(this.getMeta(), component, dimensions, this);
        StaticObject value = this.getAllocator().createNewMultiArray(component, dimensions);
        EspressoFrame.putObject((Frame)frame, top - allocatedDimensions, value);
        return -allocatedDimensions;
    }

    private boolean stackIntToBoolean(int result) {
        return this.getJavaVersion().java9OrLater() ? (result & 1) != 0 : result != 0;
    }

    private static int divInt(int divisor, int dividend) {
        return dividend / divisor;
    }

    private static long divLong(long divisor, long dividend) {
        return dividend / divisor;
    }

    private static float divFloat(float divisor, float dividend) {
        return dividend / divisor;
    }

    private static double divDouble(double divisor, double dividend) {
        return dividend / divisor;
    }

    private static int remInt(int divisor, int dividend) {
        return dividend % divisor;
    }

    private static long remLong(long divisor, long dividend) {
        return dividend % divisor;
    }

    private static float remFloat(float divisor, float dividend) {
        return dividend % divisor;
    }

    private static double remDouble(double divisor, double dividend) {
        return dividend % divisor;
    }

    private static int shiftLeftInt(int bits, int value) {
        return value << bits;
    }

    private static long shiftLeftLong(int bits, long value) {
        return value << bits;
    }

    private static int shiftRightSignedInt(int bits, int value) {
        return value >> bits;
    }

    private static long shiftRightSignedLong(int bits, long value) {
        return value >> bits;
    }

    private static int shiftRightUnsignedInt(int bits, int value) {
        return value >>> bits;
    }

    private static long shiftRightUnsignedLong(int bits, long value) {
        return value >>> bits;
    }

    private static int compareLong(long y, long x) {
        return Long.compare(x, y);
    }

    private static int compareFloatGreater(float y, float x) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static int compareFloatLess(float y, float x) {
        return x > y ? 1 : (x == y ? 0 : -1);
    }

    private static int compareDoubleGreater(double y, double x) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static int compareDoubleLess(double y, double x) {
        return x > y ? 1 : (x == y ? 0 : -1);
    }

    public void enterImplicitExceptionProfile() {
        if (!this.implicitExceptionProfile) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.implicitExceptionProfile = true;
        }
    }

    public void enterLinkageExceptionProfile() {
        if (!this.linkageExceptionProfile) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.linkageExceptionProfile = true;
        }
    }

    private StaticObject nullCheck(StaticObject value) {
        if (!StaticObject.isNull(value)) {
            return value;
        }
        this.enterImplicitExceptionProfile();
        throw this.getMeta().throwNullPointerException();
    }

    private int checkNonZero(int value) {
        if (value != 0) {
            return value;
        }
        this.enterImplicitExceptionProfile();
        throw this.throwBoundary(this.getMeta().java_lang_ArithmeticException, "/ by zero");
    }

    private long checkNonZero(long value) {
        if (value != 0L) {
            return value;
        }
        this.enterImplicitExceptionProfile();
        throw this.throwBoundary(this.getMeta().java_lang_ArithmeticException, "/ by zero");
    }

    private int putField(VirtualFrame frame, int top, Field field, int curBCI, int opcode, int statementIndex) {
        StaticObject receiver;
        int slotCount;
        assert (opcode == 181 || opcode == 179);
        CompilerAsserts.partialEvaluationConstant((Object)field);
        if (field.isStatic() != (opcode == 179)) {
            this.enterLinkageExceptionProfile();
            throw this.throwBoundary(this.getMeta().java_lang_IncompatibleClassChangeError, "Expected %s field %s.%s", opcode == 179 ? "static" : "non-static", field.getDeclaringKlass().getNameAsString(), field.getNameAsString());
        }
        if (field.isFinalFlagSet()) {
            boolean enforceInitializerCheck;
            if (field.getDeclaringKlass() != this.getDeclaringKlass()) {
                this.enterLinkageExceptionProfile();
                throw this.throwBoundary(this.getMeta().java_lang_IllegalAccessError, "Update to %s final field %s.%s attempted from a different class (%s) than the field's declaring class", opcode == 179 ? "static" : "non-static", field.getDeclaringKlass().getNameAsString(), field.getNameAsString(), this.getDeclaringKlass().getNameAsString());
            }
            boolean bl = enforceInitializerCheck = this.getLanguage().getSpecComplianceMode() == EspressoOptions.SpecComplianceMode.STRICT || field.getDeclaringKlass().getMajorVersion() >= 53;
            if (enforceInitializerCheck && (opcode == 181 && !this.getMethod().isConstructor() || opcode == 179 && !this.getMethod().isClassInitializer())) {
                this.enterLinkageExceptionProfile();
                throw this.throwBoundary(this.getMeta().java_lang_IllegalAccessError, "Update to %s final field %s.%s attempted from a different method (%s) than the initializer method %s ", opcode == 179 ? "static" : "non-static", field.getDeclaringKlass().getNameAsString(), field.getNameAsString(), this.getMethod().getNameAsString(), opcode == 179 ? "<clinit>" : "<init>");
            }
        }
        assert (field.isStatic() == (opcode == 179));
        byte typeHeader = field.getType().byteAt(0);
        int n = slotCount = typeHeader == 74 || typeHeader == 68 ? 2 : 1;
        assert (slotCount == field.getKind().getSlotCount());
        int slot = top - slotCount - 1;
        StaticObject staticObject = receiver = opcode == 179 ? field.getDeclaringKlass().tryInitializeAndGetStatics() : this.nullCheck(EspressoFrame.popObject((Frame)frame, slot));
        if (!this.noForeignObjects.isValid() && opcode == 181 && receiver.isForeignObject()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoFrame.putObject((Frame)frame, slot, receiver);
            return this.quickenPutField(frame, top, curBCI, opcode, statementIndex, field);
        }
        switch (typeHeader) {
            case 90: {
                boolean booleanValue = this.stackIntToBoolean(EspressoFrame.popInt((Frame)frame, top - 1));
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, booleanValue);
                }
                InterpreterToVM.setFieldBoolean(booleanValue, receiver, field);
                break;
            }
            case 66: {
                byte byteValue = (byte)EspressoFrame.popInt((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, byteValue);
                }
                InterpreterToVM.setFieldByte(byteValue, receiver, field);
                break;
            }
            case 67: {
                char charValue = (char)EspressoFrame.popInt((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, Character.valueOf(charValue));
                }
                InterpreterToVM.setFieldChar(charValue, receiver, field);
                break;
            }
            case 83: {
                short shortValue = (short)EspressoFrame.popInt((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, shortValue);
                }
                InterpreterToVM.setFieldShort(shortValue, receiver, field);
                break;
            }
            case 73: {
                int intValue = EspressoFrame.popInt((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, intValue);
                }
                InterpreterToVM.setFieldInt(intValue, receiver, field);
                break;
            }
            case 68: {
                double doubleValue = EspressoFrame.popDouble((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, doubleValue);
                }
                InterpreterToVM.setFieldDouble(doubleValue, receiver, field);
                break;
            }
            case 70: {
                float floatValue = EspressoFrame.popFloat((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, Float.valueOf(floatValue));
                }
                InterpreterToVM.setFieldFloat(floatValue, receiver, field);
                break;
            }
            case 74: {
                long longValue = EspressoFrame.popLong((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, longValue);
                }
                InterpreterToVM.setFieldLong(longValue, receiver, field);
                break;
            }
            case 76: 
            case 91: {
                StaticObject value = EspressoFrame.popObject((Frame)frame, top - 1);
                if (this.instrumentation != null) {
                    this.instrumentation.notifyFieldModification(frame, statementIndex, field, receiver, value);
                }
                InterpreterToVM.setFieldObject(value, receiver, field);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("unexpected kind");
            }
        }
        return -slotCount;
    }

    private int getField(VirtualFrame frame, int top, Field field, int curBCI, int opcode, int statementIndex) {
        int slotCount;
        StaticObject receiver;
        assert (opcode == 180 || opcode == 178);
        CompilerAsserts.partialEvaluationConstant((Object)field);
        if (field.isStatic() != (opcode == 178)) {
            this.enterLinkageExceptionProfile();
            throw this.throwBoundary(this.getMeta().java_lang_IncompatibleClassChangeError, "Expected %s field %s.%s", opcode == 178 ? "static" : "non-static", field.getDeclaringKlass().getNameAsString(), field.getNameAsString());
        }
        assert (field.isStatic() == (opcode == 178));
        int slot = top - 1;
        StaticObject staticObject = receiver = opcode == 178 ? field.getDeclaringKlass().tryInitializeAndGetStatics() : this.nullCheck(EspressoFrame.peekObject((Frame)frame, slot));
        if (!this.noForeignObjects.isValid() && opcode == 180 && receiver.isForeignObject()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoFrame.putObject((Frame)frame, slot, receiver);
            return this.quickenGetField(frame, top, curBCI, opcode, statementIndex, field);
        }
        if (this.instrumentation != null) {
            this.instrumentation.notifyFieldAccess(frame, statementIndex, field, receiver);
        }
        int resultAt = field.isStatic() ? top : top - 1;
        byte typeHeader = field.getType().byteAt(0);
        switch (typeHeader) {
            case 90: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldBoolean(receiver, field) ? 1 : 0);
                break;
            }
            case 66: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldByte(receiver, field));
                break;
            }
            case 67: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldChar(receiver, field));
                break;
            }
            case 83: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldShort(receiver, field));
                break;
            }
            case 73: {
                EspressoFrame.putInt((Frame)frame, resultAt, InterpreterToVM.getFieldInt(receiver, field));
                break;
            }
            case 68: {
                EspressoFrame.putDouble((Frame)frame, resultAt, InterpreterToVM.getFieldDouble(receiver, field));
                break;
            }
            case 70: {
                EspressoFrame.putFloat((Frame)frame, resultAt, InterpreterToVM.getFieldFloat(receiver, field));
                break;
            }
            case 74: {
                EspressoFrame.putLong((Frame)frame, resultAt, InterpreterToVM.getFieldLong(receiver, field));
                break;
            }
            case 76: 
            case 91: {
                StaticObject value = InterpreterToVM.getFieldObject(receiver, field);
                EspressoFrame.putObject((Frame)frame, resultAt, value);
                this.checkNoForeignObjectAssumption(value);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("unexpected kind");
            }
        }
        int n = slotCount = typeHeader == 74 || typeHeader == 68 ? 2 : 1;
        assert (slotCount == field.getKind().getSlotCount());
        return slotCount;
    }

    public String toString() {
        return this.getRootNode().getQualifiedName();
    }

    public void notifyFieldModification(VirtualFrame frame, int index, Field field, StaticObject receiver, Object value) {
        if (this.instrumentation != null && (this.noForeignObjects.isValid() || receiver.isEspressoObject())) {
            this.instrumentation.notifyFieldModification(frame, index, field, receiver, value);
        }
    }

    public void notifyFieldAccess(VirtualFrame frame, int index, Field field, StaticObject receiver) {
        if (this.instrumentation != null && (this.noForeignObjects.isValid() || receiver.isEspressoObject())) {
            this.instrumentation.notifyFieldAccess(frame, index, field, receiver);
        }
    }

    private boolean lockIsHeld() {
        return ((ReentrantLock)this.getLock()).isHeldByCurrentThread();
    }

    private boolean trivialBytecodes() {
        if (this.getMethod().isSynchronized()) {
            return false;
        }
        byte[] originalCode = this.getMethodVersion().getOriginalCode();
        BytecodeStream stream = new BytecodeStream(originalCode);
        int bci = 0;
        while (bci < stream.endBCI()) {
            int dest;
            int bc = stream.currentBC(bci);
            if (Bytecodes.isInvoke(bc)) {
                return false;
            }
            if (171 == bc || 170 == bc) {
                return false;
            }
            if (194 == bc || 195 == bc) {
                return false;
            }
            if (189 == bc || 197 == bc) {
                return false;
            }
            if (Bytecodes.isBranch(bc) && (dest = stream.readBranchDest(bci)) <= bci) {
                return false;
            }
            bci = stream.nextBCI(bci);
        }
        return true;
    }

    @Override
    protected boolean isTrivial() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.noForeignObjects.isValid() || this.implicitExceptionProfile) {
            return false;
        }
        if (this.trivialBytecodesCache == -1) {
            this.trivialBytecodesCache = this.trivialBytecodes() ? (byte)1 : 0;
        }
        return this.trivialBytecodesCache == 1;
    }

    static {
        assert (Integer.bitCount(256) == 1) : "must be a power of 2";
    }

    private static final class EspressoOSRInterpreterState {
        final int top;
        final int nextStatementIndex;

        EspressoOSRInterpreterState(int top, int nextStatementIndex) {
            this.top = top;
            this.nextStatementIndex = nextStatementIndex;
        }
    }

    static final class InstrumentationSupport
    extends EspressoNode {
        static final int NO_STATEMENT = -1;
        @Node.Children
        private final EspressoBaseStatementNode[] statementNodes;
        @Node.Child
        private MapperBCI hookBCIToNodeIndex;
        private final EspressoContext context;
        private final Method.MethodVersion method;

        InstrumentationSupport(Method.MethodVersion method) {
            this.method = method;
            this.context = method.getMethod().getContext();
            LineNumberTableAttribute table = method.getLineNumberTableAttribute();
            if (table != LineNumberTableAttribute.EMPTY) {
                List<LineNumberTableAttribute.Entry> entries = table.getEntries();
                int[] seenLines = new int[entries.size()];
                Arrays.fill(seenLines, -1);
                int maxSeenLine = -1;
                this.statementNodes = new EspressoBaseStatementNode[entries.size()];
                this.hookBCIToNodeIndex = new MapperBCI(table);
                for (int i = 0; i < entries.size(); ++i) {
                    boolean checkSeen;
                    LineNumberTableAttribute.Entry entry = entries.get(i);
                    int lineNumber = entry.getLineNumber();
                    boolean seen = false;
                    boolean bl = checkSeen = maxSeenLine >= lineNumber;
                    if (checkSeen) {
                        for (int seenLine : seenLines) {
                            if (seenLine != lineNumber) continue;
                            seen = true;
                            break;
                        }
                    }
                    if (seen) continue;
                    this.statementNodes[this.hookBCIToNodeIndex.initIndex((int)i, (int)entry.getBCI())] = new EspressoStatementNode(entry.getBCI(), lineNumber);
                    seenLines[i] = lineNumber;
                    maxSeenLine = Math.max(maxSeenLine, lineNumber);
                }
            } else {
                this.statementNodes = null;
                this.hookBCIToNodeIndex = null;
            }
        }

        void notifyStatement(VirtualFrame frame, int statementIndex, int nextStatementIndex) {
            CompilerAsserts.partialEvaluationConstant((int)statementIndex);
            CompilerAsserts.partialEvaluationConstant((int)nextStatementIndex);
            if (statementIndex == nextStatementIndex) {
                return;
            }
            this.exitAt(frame, statementIndex);
            this.enterAt(frame, nextStatementIndex);
        }

        public void notifyEntry(VirtualFrame frame, AbstractInstrumentableBytecodeNode instrumentableNode) {
            if (this.context.shouldReportVMEvents() && this.method.hasActiveHook() && this.context.reportOnMethodEntry(this.method, instrumentableNode.getScope((Frame)frame, true))) {
                this.enterAt(frame, 0);
            }
        }

        public void notifyReturn(VirtualFrame frame, int statementIndex, Object returnValue) {
            if (this.context.shouldReportVMEvents() && this.method.hasActiveHook() && this.context.reportOnMethodReturn(this.method, returnValue)) {
                this.enterAt(frame, statementIndex);
            }
        }

        void notifyExceptionAt(VirtualFrame frame, Throwable t, int statementIndex) {
            InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(statementIndex);
            if (wrapperNode == null) {
                return;
            }
            ProbeNode probeNode = wrapperNode.getProbeNode();
            probeNode.onReturnExceptionalOrUnwind(frame, t, false);
        }

        public void notifyFieldModification(VirtualFrame frame, int index, Field field, StaticObject receiver, Object value) {
            if (this.context.shouldReportVMEvents() && field.hasActiveBreakpoint() && this.context.reportOnFieldModification(field, receiver, value)) {
                this.enterAt(frame, index);
            }
        }

        public void notifyFieldAccess(VirtualFrame frame, int index, Field field, StaticObject receiver) {
            if (this.context.shouldReportVMEvents() && field.hasActiveBreakpoint() && this.context.reportOnFieldAccess(field, receiver)) {
                this.enterAt(frame, index);
            }
        }

        private void enterAt(VirtualFrame frame, int index) {
            InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(index);
            if (wrapperNode == null) {
                return;
            }
            ProbeNode probeNode = wrapperNode.getProbeNode();
            try {
                probeNode.onEnter(frame);
            }
            catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, false);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException();
                }
                if (result != null) {
                    return;
                }
                throw t;
            }
        }

        private void exitAt(VirtualFrame frame, int index) {
            InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(index);
            if (wrapperNode == null) {
                return;
            }
            ProbeNode probeNode = wrapperNode.getProbeNode();
            try {
                probeNode.onReturnValue(frame, (Object)StaticObject.NULL);
            }
            catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, true);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException();
                }
                if (result != null) {
                    return;
                }
                throw t;
            }
        }

        int getStatementIndexAfterJump(int statementIndex, int curBCI, int targetBCI) {
            if (this.hookBCIToNodeIndex == null) {
                return 0;
            }
            return this.hookBCIToNodeIndex.lookup(statementIndex, curBCI, targetBCI);
        }

        int getNextStatementIndex(int statementIndex, int nextBCI) {
            if (this.hookBCIToNodeIndex == null) {
                return 0;
            }
            return this.hookBCIToNodeIndex.checkNext(statementIndex, nextBCI);
        }

        private InstrumentableNode.WrapperNode getWrapperAt(int index) {
            if (this.statementNodes == null || index < 0) {
                return null;
            }
            EspressoBaseStatementNode node = this.statementNodes[index];
            if (!(node instanceof InstrumentableNode.WrapperNode)) {
                return null;
            }
            CompilerAsserts.partialEvaluationConstant((Object)node);
            return (InstrumentableNode.WrapperNode)node;
        }
    }

    private static final class Counter {
        int value;

        private Counter() {
        }
    }

    private static final class EspressoOSRReturnException
    extends ControlFlowException {
        private final Object result;
        private final Throwable throwable;

        EspressoOSRReturnException(Object result) {
            this.result = result;
            this.throwable = null;
        }

        EspressoOSRReturnException(Throwable throwable) {
            this.result = null;
            this.throwable = throwable;
        }

        Object getResultOrRethrow() {
            if (this.throwable != null) {
                throw EspressoOSRReturnException.sneakyThrow(this.throwable);
            }
            return this.result;
        }

        private static <T extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws T {
            throw ex;
        }
    }
}

