/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.espresso.jdwp.api.CallFrame;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jdwp.impl.ThreadJob;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class SuspendedInfo {
    protected final JDWPContext context;
    private final DebuggerController controller;
    private final SuspendedEvent event;
    private final CallFrame[] stackFrames;
    private final Object thread;
    private final RootNode callerRootNode;
    private boolean forceEarlyInProgress;
    private final HashMap<Object, Integer> monitorEntryCounts;

    SuspendedInfo(DebuggerController controller, SuspendedEvent event, CallFrame[] stackFrames, Object thread, RootNode callerRootNode) {
        this.controller = controller;
        this.context = controller.getContext();
        this.event = event;
        this.stackFrames = stackFrames;
        this.thread = thread;
        this.callerRootNode = callerRootNode;
        this.monitorEntryCounts = null;
    }

    SuspendedInfo(JDWPContext context, CallFrame[] stackFrames, Object thread, HashMap<Object, Integer> monitorEntryCounts) {
        this.controller = null;
        this.context = context;
        this.event = null;
        this.stackFrames = stackFrames;
        this.thread = thread;
        this.callerRootNode = null;
        this.monitorEntryCounts = monitorEntryCounts;
    }

    public SuspendedEvent getEvent() {
        return this.event;
    }

    public CallFrame[] getStackFrames() {
        return this.stackFrames;
    }

    public Object getThread() {
        return this.thread;
    }

    public RootNode getCallerRootNode() {
        return this.callerRootNode;
    }

    public Frame getCallerFrame() {
        return this.stackFrames.length > 1 ? this.stackFrames[1].getFrame() : null;
    }

    public void setForceEarlyReturnInProgress() {
        this.forceEarlyInProgress = true;
    }

    public boolean isForceEarlyReturnInProgress() {
        return this.forceEarlyInProgress;
    }

    public int getMonitorEntryCount(final Object monitor) {
        if (this.monitorEntryCounts != null) {
            return this.monitorEntryCounts.get(monitor);
        }
        ThreadJob<Integer> job = new ThreadJob<Integer>(this.thread, new Callable<Integer>(){

            @Override
            public Integer call() {
                return SuspendedInfo.this.context.getMonitorEntryCount(monitor);
            }
        });
        this.controller.postJobForThread(job);
        return job.getResult().getResult();
    }
}

