/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.impl.NoSuchSourceLineException;
import com.oracle.truffle.espresso.jdwp.impl.SourceLocator;

public final class SourceLocation {
    private final int lineNumber;
    private final JDWPContext context;
    private final String slashName;

    public SourceLocation(String slashName, int lineNumber, JDWPContext context) {
        this.lineNumber = lineNumber;
        this.context = context;
        this.slashName = slashName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Source getSource() throws NoSuchSourceLineException {
        return new SourceLocator(this.context).lookupSource(this.slashName, this.lineNumber);
    }

    public String toString() {
        return "Location: " + this.slashName + ":" + this.lineNumber;
    }
}

