/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.impl.BreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.StepInfo;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class RequestFilter {
    private final int requestId;
    private final byte eventKind;
    private final byte suspendPolicy;
    private Pattern[] classExcludePatterns = new Pattern[0];
    private KlassRef[] klassRefPatterns = new KlassRef[0];
    private int count = 0;
    private Object thread;
    private Pattern[] positivePatterns = new Pattern[0];
    private BreakpointInfo breakpointInfo;
    private long thisFilterId = 0L;
    private StepInfo stepInfo;

    public RequestFilter(int requestId, byte eventKind, byte suspendPolicy) {
        this.requestId = requestId;
        this.eventKind = eventKind;
        this.suspendPolicy = suspendPolicy;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public byte getEventKind() {
        return this.eventKind;
    }

    public void addExcludePattern(Pattern pattern) {
        int length = this.classExcludePatterns.length;
        this.classExcludePatterns = Arrays.copyOf(this.classExcludePatterns, length + 1);
        this.classExcludePatterns[length] = pattern;
    }

    public void setStepInfo(StepInfo info) {
        this.stepInfo = info;
    }

    public StepInfo getStepInfo() {
        return this.stepInfo;
    }

    public void addRefTypeLimit(KlassRef klassRef) {
        int length = this.klassRefPatterns.length;
        this.klassRefPatterns = Arrays.copyOf(this.klassRefPatterns, length + 1);
        this.klassRefPatterns[length] = klassRef;
    }

    public boolean isKlassExcluded(KlassRef klass) {
        for (Pattern pattern : this.classExcludePatterns) {
            if (pattern == null || !pattern.matcher(klass.getNameAsString().replace('/', '.')).matches()) continue;
            return true;
        }
        return false;
    }

    public void addEventCount(int eventCount) {
        this.count = eventCount;
    }

    public int getIgnoreCount() {
        return this.count;
    }

    public void addThread(Object guestThread) {
        this.thread = guestThread;
    }

    public Object getThread() {
        return this.thread;
    }

    public void addPositivePattern(Pattern pattern) {
        int length = this.positivePatterns.length;
        this.positivePatterns = Arrays.copyOf(this.positivePatterns, length + 1);
        this.positivePatterns[length] = pattern;
    }

    public Pattern[] getIncludePatterns() {
        return this.positivePatterns;
    }

    public Pattern[] getExcludePatterns() {
        return this.classExcludePatterns;
    }

    public KlassRef[] getKlassRefPatterns() {
        return this.klassRefPatterns;
    }

    public void addBreakpointInfo(BreakpointInfo info) {
        this.breakpointInfo = info;
    }

    public BreakpointInfo getBreakpointInfo() {
        return this.breakpointInfo;
    }

    public void addThisFilterId(long thisId) {
        this.thisFilterId = thisId;
    }

    public long getThisFilterId() {
        return this.thisFilterId;
    }

    public byte getSuspendPolicy() {
        return this.suspendPolicy;
    }
}

