/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.Packet;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class PacketStream {
    private final Packet packet;
    private int readPosition;
    private final ByteArrayOutputStream dataStream = new ByteArrayOutputStream();

    public PacketStream() {
        this.packet = new Packet();
    }

    public PacketStream(Packet packet) {
        this.packet = packet;
    }

    public int getPacketId() {
        return this.packet.id;
    }

    public PacketStream commandPacket() {
        this.packet.id = Packet.uID;
        return this;
    }

    public PacketStream command(int command) {
        this.packet.cmd = (short)command;
        return this;
    }

    public PacketStream commandSet(int commandSet) {
        this.packet.cmdSet = (short)commandSet;
        return this;
    }

    public PacketStream replyPacket() {
        this.packet.flags = (short)128;
        this.packet.errorCode = 0;
        return this;
    }

    public PacketStream id(int id) {
        this.packet.id = id;
        return this;
    }

    PacketStream errorCode(int errorCode) {
        this.packet.errorCode = (short)errorCode;
        return this;
    }

    public byte[] prepareForShipment() {
        this.packet.data = this.dataStream.toByteArray();
        return this.packet.toByteArray();
    }

    public void writeBoolean(boolean data) {
        if (data) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    public void writeByte(byte data) {
        this.dataStream.write(data);
    }

    public void writeChar(char data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    public void writeShort(short data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    public void writeInt(int data) {
        this.dataStream.write((byte)(data >>> 24 & 0xFF));
        this.dataStream.write((byte)(data >>> 16 & 0xFF));
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    public void writeLong(long data) {
        this.dataStream.write((byte)(data >>> 56 & 0xFFL));
        this.dataStream.write((byte)(data >>> 48 & 0xFFL));
        this.dataStream.write((byte)(data >>> 40 & 0xFFL));
        this.dataStream.write((byte)(data >>> 32 & 0xFFL));
        this.dataStream.write((byte)(data >>> 24 & 0xFFL));
        this.dataStream.write((byte)(data >>> 16 & 0xFFL));
        this.dataStream.write((byte)(data >>> 8 & 0xFFL));
        this.dataStream.write((byte)(data >>> 0 & 0xFFL));
    }

    public void writeFloat(float data) {
        this.writeInt(Float.floatToIntBits(data));
    }

    public void writeDouble(double data) {
        this.writeLong(Double.doubleToLongBits(data));
    }

    public void writeByteArray(byte[] data) {
        this.dataStream.write(data, 0, data.length);
    }

    public void writeString(String string) {
        byte[] stringBytes = string.getBytes(StandardCharsets.UTF_8);
        this.writeInt(stringBytes.length);
        this.writeByteArray(stringBytes);
    }

    public byte readByte() {
        byte ret = this.packet.data[this.readPosition];
        ++this.readPosition;
        return ret;
    }

    public boolean readBoolean() {
        byte ret = this.readByte();
        return ret != 0;
    }

    public char readChar() {
        int b1 = this.packet.data[this.readPosition++] & 0xFF;
        int b2 = this.packet.data[this.readPosition++] & 0xFF;
        return (char)((b1 << 8) + b2);
    }

    public short readShort() {
        int b1 = this.packet.data[this.readPosition++] & 0xFF;
        int b2 = this.packet.data[this.readPosition++] & 0xFF;
        return (short)((b1 << 8) + b2);
    }

    public int readInt() {
        int b1 = this.packet.data[this.readPosition++] & 0xFF;
        int b2 = this.packet.data[this.readPosition++] & 0xFF;
        int b3 = this.packet.data[this.readPosition++] & 0xFF;
        int b4 = this.packet.data[this.readPosition++] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public long readLong() {
        long b1 = this.packet.data[this.readPosition++] & 0xFF;
        long b2 = this.packet.data[this.readPosition++] & 0xFF;
        long b3 = this.packet.data[this.readPosition++] & 0xFF;
        long b4 = this.packet.data[this.readPosition++] & 0xFF;
        long b5 = this.packet.data[this.readPosition++] & 0xFF;
        long b6 = this.packet.data[this.readPosition++] & 0xFF;
        long b7 = this.packet.data[this.readPosition++] & 0xFF;
        long b8 = this.packet.data[this.readPosition++] & 0xFF;
        return (b1 << 56) + (b2 << 48) + (b3 << 40) + (b4 << 32) + (b5 << 24) + (b6 << 16) + (b7 << 8) + b8;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public byte[] readByteArray(int length) {
        byte[] result = Arrays.copyOfRange(this.packet.data, this.readPosition, this.readPosition + length);
        this.readPosition += length;
        return result;
    }

    public String readString() {
        String ret;
        int len = this.readInt();
        try {
            ret = new String(this.packet.data, this.readPosition, len, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            ret = "Conversion error!";
        }
        this.readPosition += len;
        return ret;
    }
}

