/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.api.MethodHook;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.api.MethodVariable;
import com.oracle.truffle.espresso.jdwp.impl.AbstractBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import java.util.Arrays;

public final class MethodBreakpointInfo
extends AbstractBreakpointInfo
implements MethodHook {
    private MethodRef[] methods = new MethodRef[0];
    private final boolean isMethodEntry;
    private final boolean isMethodExit;

    public MethodBreakpointInfo(RequestFilter filter) {
        super(filter);
        this.isMethodEntry = filter.getEventKind() == 40;
        this.isMethodExit = filter.getEventKind() == 41 || filter.getEventKind() == 42;
    }

    public void addMethod(MethodRef method) {
        this.methods = Arrays.copyOf(this.methods, this.methods.length + 1);
        this.methods[this.methods.length - 1] = method;
    }

    public MethodRef[] getMethods() {
        return this.methods;
    }

    @Override
    public MethodHook.Kind getKind() {
        return MethodHook.Kind.INDEFINITE;
    }

    @Override
    public boolean onMethodEnter(MethodRef method, MethodVariable[] variables) {
        return this.isMethodEntry;
    }

    @Override
    public boolean onMethodExit(MethodRef method, Object returnValue) {
        return this.isMethodExit;
    }
}

