/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.SocketConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collection;

public final class HandshakeController {
    private static final String JDWP_HANDSHAKE = "JDWP-Handshake";
    private ServerSocket currentServerSocket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketConnection createSocketConnection(boolean server, String host, int port, Collection<Thread> activeThreads) throws IOException {
        Socket connectionSocket;
        String connectionHost = host;
        if (connectionHost == null) {
            connectionHost = "localhost";
        }
        if (server) {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setSoTimeout(0);
            serverSocket.setReuseAddress(true);
            if ("*".equals(host)) {
                serverSocket.bind(new InetSocketAddress((InetAddress)null, port));
            } else {
                serverSocket.bind(new InetSocketAddress(connectionHost, port));
            }
            String address = host != null ? host + ":" + port : "" + port;
            System.out.println("Listening for transport dt_socket at address: " + address);
            HandshakeController handshakeController = this;
            synchronized (handshakeController) {
                assert (this.currentServerSocket == null);
                this.currentServerSocket = serverSocket;
            }
            connectionSocket = serverSocket.accept();
        } else {
            connectionSocket = new Socket(connectionHost, port);
        }
        if (!HandshakeController.handshake(connectionSocket)) {
            throw new IOException("Unable to handshake with debubgger");
        }
        SocketConnection connection = new SocketConnection(connectionSocket);
        Thread jdwpSender = new Thread((Runnable)connection, "jdwp-transmitter");
        jdwpSender.setDaemon(true);
        jdwpSender.start();
        activeThreads.add(jdwpSender);
        return connection;
    }

    public synchronized void close() {
        if (this.currentServerSocket != null) {
            if (!this.currentServerSocket.isClosed()) {
                try {
                    this.currentServerSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close the server socket used to listen for transport dt_socket", e);
                }
            }
            this.currentServerSocket = null;
        }
    }

    private static boolean handshake(Socket s) throws IOException {
        int n;
        byte[] hello = JDWP_HANDSHAKE.getBytes("UTF-8");
        byte[] b = new byte[hello.length];
        for (int received = 0; received < hello.length; received += n) {
            try {
                n = s.getInputStream().read(b, received, hello.length - received);
            }
            catch (SocketTimeoutException x) {
                throw new IOException("handshake timeout");
            }
            if (n >= 0) continue;
            s.close();
            throw new IOException("handshake failed - connection prematurally closed");
        }
        for (int i = 0; i < hello.length; ++i) {
            if (b[i] == hello[i]) continue;
            throw new IOException("handshake failed - unrecognized message from the debugger");
        }
        s.getOutputStream().write(hello);
        return true;
    }
}

