/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.impl.BreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.CommandResult;
import com.oracle.truffle.espresso.jdwp.impl.Commands;
import com.oracle.truffle.espresso.jdwp.impl.ConnectionClosedException;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerCommand;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jdwp.impl.JDWP;
import com.oracle.truffle.espresso.jdwp.impl.LineBreakpointInfo;
import com.oracle.truffle.espresso.jdwp.impl.Packet;
import com.oracle.truffle.espresso.jdwp.impl.PacketStream;
import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import com.oracle.truffle.espresso.jdwp.impl.RequestedJDWPEvents;
import com.oracle.truffle.espresso.jdwp.impl.SocketConnection;
import com.oracle.truffle.espresso.jdwp.impl.SourceLocation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;

public final class DebuggerConnection
implements Commands {
    private final DebuggerController controller;
    private final JDWPContext context;
    private final SocketConnection connection;
    private final BlockingQueue<DebuggerCommand> queue = new ArrayBlockingQueue<DebuggerCommand>(512);
    private Thread commandProcessor;
    private Thread jdwpTransport;

    public DebuggerConnection(SocketConnection connection, DebuggerController controller) {
        this.connection = connection;
        this.controller = controller;
        this.context = controller.getContext();
    }

    public void doProcessCommands(boolean suspend, Collection<Thread> activeThreads, Callable<Void> job) {
        this.commandProcessor = new Thread((Runnable)new CommandProcessorThread(), "jdwp-command-processor");
        this.commandProcessor.setDaemon(true);
        this.commandProcessor.start();
        activeThreads.add(this.commandProcessor);
        this.jdwpTransport = new Thread((Runnable)new JDWPTransportThread(), "jdwp-transport");
        this.jdwpTransport.setDaemon(true);
        this.jdwpTransport.start();
        activeThreads.add(this.jdwpTransport);
        if (suspend) {
            Object guestThread = this.context.asGuestThread(Thread.currentThread());
            if (guestThread == null) {
                return;
            }
            this.controller.suspend(this.context.asGuestThread(Thread.currentThread()), (byte)1, Collections.singletonList(job), true);
        }
    }

    public void close() {
        try {
            this.connection.close(this.controller);
            this.controller.getEventListener().setConnection(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Closing socket connection failed", e);
        }
    }

    @Override
    public void stepInto(Object thread, RequestFilter filter) {
        DebuggerCommand debuggerCommand = new DebuggerCommand(DebuggerCommand.Kind.STEP_INTO, filter);
        this.controller.setCommandRequestId(thread, filter.getRequestId(), filter.getSuspendPolicy(), false, false, DebuggerCommand.Kind.STEP_INTO);
        this.addBlocking(debuggerCommand);
    }

    @Override
    public void stepOver(Object thread, RequestFilter filter) {
        DebuggerCommand debuggerCommand = new DebuggerCommand(DebuggerCommand.Kind.STEP_OVER, filter);
        this.controller.setCommandRequestId(thread, filter.getRequestId(), filter.getSuspendPolicy(), false, false, DebuggerCommand.Kind.STEP_OVER);
        this.addBlocking(debuggerCommand);
    }

    @Override
    public void stepOut(Object thread, RequestFilter filter) {
        DebuggerCommand debuggerCommand = new DebuggerCommand(DebuggerCommand.Kind.STEP_OUT, filter);
        this.controller.setCommandRequestId(thread, filter.getRequestId(), filter.getSuspendPolicy(), false, false, DebuggerCommand.Kind.STEP_OUT);
        this.addBlocking(debuggerCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBlocking(DebuggerCommand command) {
        this.queue.add(command);
        DebuggerCommand debuggerCommand = command;
        synchronized (debuggerCommand) {
            while (!command.isSubmitted()) {
                try {
                    command.wait();
                }
                catch (InterruptedException e) {
                    this.controller.warning(() -> "could not submit debugger command due to " + e.getMessage());
                }
            }
        }
    }

    @Override
    public Callable<Void> createLineBreakpointCommand(final BreakpointInfo info) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                LineBreakpointInfo lineInfo = (LineBreakpointInfo)info;
                DebuggerCommand debuggerCommand = new DebuggerCommand(DebuggerCommand.Kind.SUBMIT_LINE_BREAKPOINT, info.getFilter());
                debuggerCommand.setSourceLocation(new SourceLocation(lineInfo.getSlashName(), (int)lineInfo.getLine(), DebuggerConnection.this.context));
                debuggerCommand.setBreakpointInfo(info);
                DebuggerConnection.this.addBlocking(debuggerCommand);
                return null;
            }
        };
    }

    @Override
    public Callable<Void> createExceptionBreakpoint(final BreakpointInfo info) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                DebuggerCommand debuggerCommand = new DebuggerCommand(DebuggerCommand.Kind.SUBMIT_EXCEPTION_BREAKPOINT, null);
                debuggerCommand.setBreakpointInfo(info);
                DebuggerConnection.this.addBlocking(debuggerCommand);
                return null;
            }
        };
    }

    boolean isDebuggerThread(Thread thread) {
        return thread == this.jdwpTransport || thread == this.commandProcessor;
    }

    private CommandResult unknownCommandSet(Packet packet) {
        this.controller.warning(() -> "Unknown command set: " + packet.cmdSet);
        return DebuggerConnection.notImplemented(packet);
    }

    private CommandResult unknownCommand(Packet packet) {
        this.controller.warning(() -> "Unknown command " + packet.cmd + " in command set " + packet.cmdSet);
        return DebuggerConnection.notImplemented(packet);
    }

    private static CommandResult notImplemented(Packet packet) {
        PacketStream reply = new PacketStream().replyPacket().id(packet.id);
        reply.errorCode(99);
        return new CommandResult(reply);
    }

    void handleReply(Packet packet, CommandResult result) {
        if (result == null) {
            return;
        }
        if (result.getPreFutures() != null) {
            try {
                for (Callable<Void> future : result.getPreFutures()) {
                    if (future == null) continue;
                    future.call();
                }
            }
            catch (Exception e) {
                this.controller.warning(() -> "Failed to run future for command(" + packet.cmdSet + "." + packet.cmd + ")");
            }
        }
        if (result.getReply() != null) {
            this.controller.fine(() -> "replying to command(" + packet.cmdSet + "." + packet.cmd + ")");
            this.connection.queuePacket(result.getReply());
        } else {
            this.controller.warning(() -> "no result for command(" + packet.cmdSet + "." + packet.cmd + ")");
        }
        if (result.getPostFutures() != null) {
            try {
                for (Callable<Void> future : result.getPostFutures()) {
                    if (future == null) continue;
                    future.call();
                }
            }
            catch (Exception e) {
                this.controller.severe(() -> "Failed to run future for command(" + packet.cmdSet + "." + packet.cmd + ")");
            }
        }
    }

    private class CommandProcessorThread
    implements Runnable {
        private CommandProcessorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                DebuggerCommand debuggerCommand = this.awaitNextCommand();
                if (debuggerCommand == null) continue;
                switch (debuggerCommand.kind) {
                    case SUBMIT_LINE_BREAKPOINT: {
                        DebuggerConnection.this.controller.submitLineBreakpoint(debuggerCommand);
                        break;
                    }
                    case SUBMIT_EXCEPTION_BREAKPOINT: {
                        DebuggerConnection.this.controller.submitExceptionBreakpoint(debuggerCommand);
                        break;
                    }
                    case STEP_OUT: {
                        DebuggerConnection.this.controller.stepOut(debuggerCommand.getRequestFilter());
                        break;
                    }
                }
                DebuggerCommand debuggerCommand2 = debuggerCommand;
                synchronized (debuggerCommand2) {
                    debuggerCommand.markSubmitted();
                    debuggerCommand.notifyAll();
                }
            }
        }

        private DebuggerCommand awaitNextCommand() {
            DebuggerCommand debuggerCommand = null;
            try {
                debuggerCommand = DebuggerConnection.this.queue.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return debuggerCommand;
        }
    }

    private class JDWPTransportThread
    implements Runnable {
        private RequestedJDWPEvents requestedJDWPEvents;

        private JDWPTransportThread() {
            this.requestedJDWPEvents = new RequestedJDWPEvents(DebuggerConnection.this.controller);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.processPacket(Packet.fromByteArray(DebuggerConnection.this.connection.readPacket()));
                }
                catch (IOException e) {
                    if (Thread.currentThread().isInterrupted()) continue;
                    DebuggerConnection.this.controller.warning(() -> "Failed to process jdwp packet with message: " + e.getMessage());
                }
                catch (ConnectionClosedException connectionClosedException) {}
            }
        }

        private void processPacket(Packet packet) {
            CommandResult result = null;
            try {
                if (packet.flags == 128) {
                    DebuggerConnection.this.controller.warning(() -> "Should not get any reply packet from debugger");
                } else {
                    DebuggerConnection.this.controller.fine(() -> "received command(" + packet.cmdSet + "." + packet.cmd + ")");
                    block1 : switch (packet.cmdSet) {
                        case 1: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.VirtualMachine.VERSION.createReply(packet, DebuggerConnection.this.controller.getVirtualMachine());
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.VirtualMachine.CLASSES_BY_SIGNATURE.createReply(packet, DebuggerConnection.this.controller, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.VirtualMachine.ALL_CLASSES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.VirtualMachine.ALL_THREADS.createReply(packet, DebuggerConnection.this.context, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.VirtualMachine.TOP_LEVEL_THREAD_GROUPS.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 6: {
                                    result = JDWP.VirtualMachine.DISPOSE.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 7: {
                                    result = JDWP.VirtualMachine.IDSIZES.createReply(packet, DebuggerConnection.this.controller.getVirtualMachine());
                                    break block1;
                                }
                                case 8: {
                                    result = JDWP.VirtualMachine.SUSPEND.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 9: {
                                    result = JDWP.VirtualMachine.RESUME.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 10: {
                                    result = JDWP.VirtualMachine.EXIT.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 11: {
                                    result = JDWP.VirtualMachine.CREATE_STRING.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 12: {
                                    result = JDWP.VirtualMachine.CAPABILITIES.createReply(packet);
                                    break block1;
                                }
                                case 13: {
                                    result = JDWP.VirtualMachine.CLASS_PATHS.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 14: {
                                    result = JDWP.VirtualMachine.DISPOSE_OBJECTS.createReply(packet);
                                    break block1;
                                }
                                case 15: {
                                    result = JDWP.VirtualMachine.HOLD_EVENTS.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 16: {
                                    result = JDWP.VirtualMachine.RELEASE_EVENTS.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 17: {
                                    result = JDWP.VirtualMachine.CAPABILITIES_NEW.createReply(packet);
                                    break block1;
                                }
                                case 18: {
                                    result = JDWP.VirtualMachine.REDEFINE_CLASSES.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 19: {
                                    result = JDWP.VirtualMachine.SET_DEFAULT_STRATUM.createReply(packet);
                                    break block1;
                                }
                                case 20: {
                                    result = JDWP.VirtualMachine.ALL_CLASSES_WITH_GENERIC.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 21: {
                                    result = JDWP.VirtualMachine.INSTANCE_COUNTS.createReply(packet);
                                    break block1;
                                }
                                case 22: {
                                    result = JDWP.VirtualMachine.ALL_MODULES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 2: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ReferenceType.SIGNATURE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ReferenceType.CLASSLOADER.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ReferenceType.MODIFIERS.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.ReferenceType.FIELDS.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.ReferenceType.METHODS.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 6: {
                                    result = JDWP.ReferenceType.GET_VALUES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 7: {
                                    result = JDWP.ReferenceType.SOURCE_FILE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 8: {
                                    result = JDWP.ReferenceType.NESTED_TYPES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 9: {
                                    result = JDWP.ReferenceType.STATUS.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 10: {
                                    result = JDWP.ReferenceType.INTERFACES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 11: {
                                    result = JDWP.ReferenceType.CLASS_OBJECT.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 12: {
                                    result = JDWP.ReferenceType.SOURCE_DEBUG_EXTENSION.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 13: {
                                    result = JDWP.ReferenceType.SIGNATURE_WITH_GENERIC.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 14: {
                                    result = JDWP.ReferenceType.FIELDS_WITH_GENERIC.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 15: {
                                    result = JDWP.ReferenceType.METHODS_WITH_GENERIC.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 16: {
                                    result = JDWP.ReferenceType.INSTANCES.createReply(packet);
                                    break block1;
                                }
                                case 17: {
                                    result = JDWP.ReferenceType.CLASS_FILE_VERSION.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 18: {
                                    result = JDWP.ReferenceType.CONSTANT_POOL.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 19: {
                                    result = JDWP.ReferenceType.MODULE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 3: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ClassType.SUPERCLASS.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ClassType.SET_VALUES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ClassType.INVOKE_METHOD.createReply(packet, DebuggerConnection.this.controller, DebuggerConnection.this);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.ClassType.NEW_INSTANCE.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 4: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ArrayType.NEW_INSTANCE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 5: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.InterfaceType.INVOKE_METHOD.createReply(packet, DebuggerConnection.this.controller, DebuggerConnection.this);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 6: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.Methods.LINE_TABLE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.Methods.VARIABLE_TABLE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.Methods.BYTECODES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.Methods.IS_OBSOLETE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.Methods.VARIABLE_TABLE_WITH_GENERIC.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 9: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ObjectReference.REFERENCE_TYPE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ObjectReference.GET_VALUES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ObjectReference.SET_VALUES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.ObjectReference.MONITOR_INFO.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 6: {
                                    result = JDWP.ObjectReference.INVOKE_METHOD.createReply(packet, DebuggerConnection.this.controller, DebuggerConnection.this);
                                    break block1;
                                }
                                case 7: {
                                    result = JDWP.ObjectReference.DISABLE_COLLECTION.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 8: {
                                    result = JDWP.ObjectReference.ENABLE_COLLECTION.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 9: {
                                    result = JDWP.ObjectReference.IS_COLLECTED.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 10: {
                                    result = JDWP.ObjectReference.REFERRING_OBJECTS.createReply(packet);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 10: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.StringReference.VALUE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 11: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ThreadReference.NAME.createReply(packet, DebuggerConnection.this.controller, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ThreadReference.SUSPEND.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ThreadReference.RESUME.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.ThreadReference.STATUS.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 5: {
                                    result = JDWP.ThreadReference.THREAD_GROUP.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 6: {
                                    result = JDWP.ThreadReference.FRAMES.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 7: {
                                    result = JDWP.ThreadReference.FRAME_COUNT.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 8: {
                                    result = JDWP.ThreadReference.OWNED_MONITORS.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 9: {
                                    result = JDWP.ThreadReference.CURRENT_CONTENDED_MONITOR.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 10: {
                                    result = JDWP.ThreadReference.STOP.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 11: {
                                    result = JDWP.ThreadReference.INTERRUPT.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 12: {
                                    result = JDWP.ThreadReference.SUSPEND_COUNT.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 13: {
                                    result = JDWP.ThreadReference.OWNED_MONITORS_STACK_DEPTH_INFO.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 14: {
                                    result = JDWP.ThreadReference.FORCE_EARLY_RETURN.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 15: {
                                    result = JDWP.ThreadReference.IS_VIRTUAL.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 12: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ThreadGroupReference.NAME.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ThreadGroupReference.PARENT.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ThreadGroupReference.CHILDREN.createReply(packet, DebuggerConnection.this.context, DebuggerConnection.this.controller);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 13: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ArrayReference.LENGTH.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ArrayReference.GET_VALUES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.ArrayReference.SET_VALUES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 14: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ClassLoaderReference.VISIBLE_CLASSES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 15: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = this.requestedJDWPEvents.registerEvent(packet, DebuggerConnection.this);
                                    break block1;
                                }
                                case 2: {
                                    result = this.requestedJDWPEvents.clearRequest(packet);
                                    break block1;
                                }
                                case 3: {
                                    result = this.requestedJDWPEvents.clearAllRequests(packet);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 16: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.StackFrame.GET_VALUES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.StackFrame.SET_VALUES.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 3: {
                                    result = JDWP.StackFrame.THIS_OBJECT.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                                case 4: {
                                    result = JDWP.StackFrame.POP_FRAMES.createReply(packet, DebuggerConnection.this.controller);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 17: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ClassObjectReference.REFLECTED_TYPE.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 18: {
                            switch (packet.cmd) {
                                case 1: {
                                    result = JDWP.ModuleReference.NAME.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                                case 2: {
                                    result = JDWP.ModuleReference.CLASSLOADER.createReply(packet, DebuggerConnection.this.context);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        case 64: {
                            switch (packet.cmd) {
                                case 100: {
                                    result = JDWP.Event.COMPOSITE.createReply(packet);
                                    break block1;
                                }
                            }
                            result = DebuggerConnection.this.unknownCommand(packet);
                            break;
                        }
                        default: {
                            result = DebuggerConnection.this.unknownCommandSet(packet);
                        }
                    }
                }
                DebuggerConnection.this.handleReply(packet, result);
            }
            catch (Throwable t) {
                DebuggerConnection.this.controller.severe("Internal error while processing packet", t);
                PacketStream reply = new PacketStream().replyPacket().id(packet.id);
                reply.errorCode(113);
                DebuggerConnection.this.handleReply(packet, new CommandResult(reply));
            }
        }
    }
}

