/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.reflect.Modifier;

public final class ParserField {
    public static final ParserField[] EMPTY_ARRAY = new ParserField[0];
    public static final int HIDDEN = 65536;
    private final int flags;
    private final Symbol<Symbol.Name> name;
    private final Symbol<Symbol.Type> type;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Attribute[] attributes;

    public ParserField withFlags(int newFlags) {
        return new ParserField(this.flags | newFlags, this.name, this.type, this.attributes);
    }

    public int getFlags() {
        return this.flags;
    }

    public Symbol<Symbol.Name> getName() {
        return this.name;
    }

    public Symbol<Symbol.Type> getType() {
        return this.type;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public ParserField(int flags, Symbol<Symbol.Name> name, Symbol<Symbol.Type> type, Attribute[] attributes) {
        this.flags = flags;
        this.name = name;
        this.type = type;
        this.attributes = attributes;
    }

    public boolean isHidden() {
        return (this.flags & 0x10000) != 0;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.flags);
    }

    public JavaKind getKind() {
        return Types.getJavaKind(this.type);
    }

    public Class<?> getPropertyType() {
        if (this.type.length() == 1) {
            char ch = (char)this.type.byteAt(0);
            switch (ch) {
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
            }
            throw new IllegalArgumentException("unknown primitive or void type character: " + ch);
        }
        return this.isHidden() ? Object.class : StaticObject.class;
    }
}

