/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;

@ExportLibrary(value=InteropLibrary.class)
public final class KeysArray<T>
implements TruffleObject {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final T[] keys;

    public KeysArray(T[] keys) {
        this.keys = keys;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return this.keys.length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long idx) {
        return 0L <= idx && idx < (long)this.keys.length;
    }

    @ExportMessage
    Object readArrayElement(long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(idx)) {
            exception.enter();
            throw InvalidArrayIndexException.create((long)idx);
        }
        return this.keys[(int)idx];
    }
}

