/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import java.util.Arrays;
import java.util.Objects;

final class NativeSignatureImpl
implements NativeSignature {
    private final NativeType returnType;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final NativeType[] parameterTypes;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final NativeType[] varArgsParameterTypes;

    NativeSignatureImpl(NativeType returnType, NativeType[] parameterTypes) {
        this(returnType, parameterTypes, null);
    }

    NativeSignatureImpl(NativeType returnType, NativeType[] parameterTypes, NativeType[] varArgsParameterTypes) {
        NativeType param;
        int i;
        this.returnType = Objects.requireNonNull(returnType);
        this.parameterTypes = Objects.requireNonNull(parameterTypes);
        this.varArgsParameterTypes = varArgsParameterTypes;
        for (i = 0; i < parameterTypes.length; ++i) {
            param = Objects.requireNonNull(parameterTypes[i]);
            if (param != NativeType.VOID) continue;
            throw new IllegalArgumentException("Invalid VOID parameter type");
        }
        if (varArgsParameterTypes != null) {
            for (i = 0; i < varArgsParameterTypes.length; ++i) {
                param = Objects.requireNonNull(varArgsParameterTypes[i]);
                if (param != NativeType.VOID) continue;
                throw new IllegalArgumentException("Invalid VOID parameter type");
            }
        }
    }

    @Override
    public NativeType getReturnType() {
        return this.returnType;
    }

    @Override
    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    @Override
    public int getVarArgsParameterCount() {
        return this.varArgsParameterTypes == null ? 0 : this.varArgsParameterTypes.length;
    }

    @Override
    public NativeType parameterTypeAt(int index) {
        if (index < this.parameterTypes.length) {
            return this.parameterTypes[index];
        }
        return this.varArgsParameterTypes[index - this.parameterTypes.length];
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NativeSignature)) {
            return false;
        }
        NativeSignature that = (NativeSignature)other;
        if (this.returnType != that.getReturnType()) {
            return false;
        }
        if (this.parameterTypes.length != that.getParameterCount()) {
            return false;
        }
        if (this.getVarArgsParameterCount() != that.getParameterCount()) {
            return false;
        }
        int totalParamaterCount = this.getParameterCount() + this.getVarArgsParameterCount();
        for (int i = 0; i < totalParamaterCount; ++i) {
            if (this.parameterTypeAt(i) == that.parameterTypeAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.returnType});
        result = 31 * result + Arrays.hashCode((Object[])this.parameterTypes);
        result = 31 * result + Arrays.hashCode((Object[])this.varArgsParameterTypes);
        return result;
    }

    public String toString() {
        return Arrays.toString((Object[])this.parameterTypes) + (String)(this.varArgsParameterTypes == null ? "" : "..." + Arrays.toString((Object[])this.varArgsParameterTypes)) + " : " + this.returnType;
    }
}

