/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.descriptors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.SymbolKey;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class Symbols {
    private final ConcurrentHashMap<SymbolKey, Symbol<?>> symbols = new ConcurrentHashMap();

    public Symbols() {
    }

    public Symbols(Symbols seed) {
        this.symbols.putAll(seed.symbols);
    }

    @CompilerDirectives.TruffleBoundary
    <T> Symbol<T> lookup(ByteSequence sequence) {
        return this.symbols.get(new SymbolKey(sequence));
    }

    <T> Symbol<T> lookup(String str) {
        return this.lookup(ByteSequence.create(str));
    }

    @CompilerDirectives.TruffleBoundary
    <T> Symbol<T> symbolify(final ByteSequence sequence) {
        final SymbolKey key = new SymbolKey(sequence);
        return this.symbols.computeIfAbsent(key, new Function<SymbolKey, Symbol<?>>(){

            @Override
            public Symbol<?> apply(SymbolKey unused) {
                Symbol computed;
                byte[] bytes = Arrays.copyOfRange(sequence.getUnderlyingBytes(), sequence.offset(), sequence.offset() + sequence.length());
                key.seq = computed = new Symbol(bytes, sequence.hashCode());
                return computed;
            }
        });
    }
}

