/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Validation;
import java.nio.ByteBuffer;

public final class Utf8Constant
implements PoolConstant {
    private static final byte VALID_CLASS_NAME = 1;
    private static final byte VALID_METHOD_NAME = 2;
    private static final byte VALID_METHOD_NAME_OR_CLINIT = 4;
    private static final byte VALID_FIELD_NAME = 8;
    private static final byte VALID_SIGNATURE = 16;
    private static final byte VALID_UTF8 = 32;
    private static final byte VALID_TYPE = 64;
    private static final byte VALID_INIT_SIGNATURE = -128;
    private byte validationCache;
    private final Symbol<?> value;

    @Override
    public ConstantPool.Tag tag() {
        return ConstantPool.Tag.UTF8;
    }

    public Utf8Constant(Symbol<?> value) {
        this.value = value;
    }

    public <T> Symbol<T> value() {
        return this.value;
    }

    @Override
    public void validate(ConstantPool pool) {
        this.validateUTF8();
    }

    public void validateUTF8() {
        if ((this.validationCache & 0x20) == 0) {
            if (!Validation.validModifiedUTF8(this.value())) {
                throw ConstantPool.classFormatError("Ill-formed modified-UTF8 entry");
            }
            this.validationCache = (byte)(this.validationCache | 0x20);
        }
    }

    public void validateClassName() {
        this.validateUTF8();
        if ((this.validationCache & 1) == 0) {
            if (!Validation.validClassNameEntry(this.value)) {
                throw ConstantPool.classFormatError("Invalid class name entry: " + this.value);
            }
            this.validationCache = (byte)(this.validationCache | 1);
        }
    }

    public void validateType(boolean allowVoid) {
        this.validateUTF8();
        if ((this.validationCache & 0x40) == 0) {
            if (!Validation.validTypeDescriptor(this.value, allowVoid)) {
                throw ConstantPool.classFormatError("Invalid type descriptor: " + this.value);
            }
            this.validationCache = (byte)(this.validationCache | 0x40);
        }
    }

    public void validateMethodName(boolean allowClinit) {
        int mask;
        this.validateUTF8();
        int n = mask = allowClinit ? 4 : 2;
        if ((this.validationCache & mask) == 0) {
            if (!Validation.validMethodName(this.value, allowClinit)) {
                throw ConstantPool.classFormatError("Invalid method name: " + this.value);
            }
            this.validationCache = (byte)(this.validationCache | mask);
        }
    }

    public void validateFieldName() {
        this.validateUTF8();
        if ((this.validationCache & 8) == 0) {
            if (!Validation.validUnqualifiedName(this.value)) {
                throw ConstantPool.classFormatError("Invalid field name: " + this.value);
            }
            this.validationCache = (byte)(this.validationCache | 8);
        }
    }

    public void validateSignature() {
        this.validateSignature(false);
    }

    public void validateSignature(boolean isInitOrClinit) {
        this.validateUTF8();
        int mask = isInitOrClinit ? -128 : 16;
        if ((this.validationCache & mask) == 0) {
            if (!Validation.validSignatureDescriptor(this.value, isInitOrClinit)) {
                throw ConstantPool.classFormatError("Invalid signature descriptor: " + this.value);
            }
            this.validationCache = (byte)(this.validationCache | (byte)(mask | 0x10));
        }
    }

    public int validateSignatureGetSlots(boolean isInitOrClinit) {
        this.validateUTF8();
        int mask = isInitOrClinit ? -128 : 16;
        int slots = Validation.validSignatureDescriptorGetSlots(this.value, isInitOrClinit);
        if (slots < 0) {
            throw ConstantPool.classFormatError("Invalid signature descriptor: " + this.value);
        }
        this.validationCache = (byte)(this.validationCache | (byte)(mask | 0x10));
        return slots;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String toString(ConstantPool pool) {
        return this.value.toString();
    }

    @Override
    public void dump(ByteBuffer buf) {
        buf.putChar((char)this.value().length());
        for (int i = 0; i < this.value().length(); ++i) {
            buf.put(this.value().byteAt(i));
        }
    }
}

