/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.descriptors.Symbol;
import java.nio.ByteBuffer;

public interface NameAndTypeConstant
extends PoolConstant {
    public static NameAndTypeConstant create(int nameIndex, int typeIndex) {
        return new Indexes(nameIndex, typeIndex);
    }

    public Symbol<Symbol.Name> getName(ConstantPool var1);

    public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool var1);

    default public void validateMethod(ConstantPool pool, boolean checkVoidInitOrClinit) {
        this.validateMethod(pool, true, checkVoidInitOrClinit);
    }

    public void validateMethod(ConstantPool var1, boolean var2, boolean var3);

    public void validateField(ConstantPool var1);

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.NAME_AND_TYPE;
    }

    @Override
    default public String toString(ConstantPool pool) {
        return this.getName(pool) + ":" + this.getDescriptor(pool);
    }

    public static final class Indexes
    implements NameAndTypeConstant {
        private final char nameIndex;
        private final char typeIndex;

        Indexes(int nameIndex, int typeIndex) {
            this.nameIndex = PoolConstant.u2(nameIndex);
            this.typeIndex = PoolConstant.u2(typeIndex);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return pool.symbolAt(this.nameIndex);
        }

        @Override
        public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool pool) {
            return pool.symbolAt(this.typeIndex);
        }

        @Override
        public void validate(ConstantPool pool) {
            Symbol<? extends Symbol.Descriptor> descriptor = this.getDescriptor(pool);
            if (descriptor.length() > 0 && descriptor.byteAt(0) == 40) {
                this.validateMethod(pool, false);
            } else {
                this.validateField(pool);
            }
        }

        @Override
        public void validateMethod(ConstantPool pool, boolean allowClinit, boolean checkVoidInitOrClinit) {
            pool.utf8At(this.nameIndex).validateMethodName(allowClinit);
            Symbol symbol = pool.symbolAt(this.nameIndex);
            boolean isInitOrClinit = checkVoidInitOrClinit && (Symbol.Name._init_.equals(symbol) || Symbol.Name._clinit_.equals(symbol));
            pool.utf8At(this.typeIndex).validateSignature(isInitOrClinit);
        }

        @Override
        public void validateField(ConstantPool pool) {
            pool.utf8At(this.nameIndex).validateFieldName();
            pool.utf8At(this.typeIndex).validateType(false);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.nameIndex);
            buf.putChar(this.typeIndex);
        }
    }
}

