/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Member;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import java.nio.ByteBuffer;

public interface MemberRefConstant
extends PoolConstant {
    public Symbol<Symbol.Name> getHolderKlassName(ConstantPool var1);

    public Symbol<Symbol.Name> getName(ConstantPool var1);

    public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool var1);

    @Override
    default public String toString(ConstantPool pool) {
        return this.getHolderKlassName(pool) + "." + this.getName(pool) + this.getDescriptor(pool);
    }

    @CompilerDirectives.TruffleBoundary
    public static void doAccessCheck(Klass accessingKlass, Klass resolvedKlass, Member<? extends Symbol.Descriptor> member, Meta meta) {
        if (!MemberRefConstant.checkAccess(accessingKlass, resolvedKlass, member)) {
            String message = "Class " + accessingKlass.getExternalName() + " cannot access method " + resolvedKlass.getExternalName() + "#" + member.getName();
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalAccessError, meta.toGuestString(message));
        }
    }

    public static boolean checkAccess(Klass accessingKlass, Klass resolvedKlass, Member<? extends Symbol.Descriptor> member) {
        if (member.isPublic()) {
            return true;
        }
        ObjectKlass memberKlass = member.getDeclaringKlass();
        if (member instanceof Method && Symbol.Name.clone.equals(member.getName()) && memberKlass.isJavaLangObject() && resolvedKlass.isArray()) {
            return true;
        }
        if (member.isProtected() && (!member.isStatic() ? resolvedKlass.isAssignableFrom(accessingKlass) || accessingKlass.isAssignableFrom(resolvedKlass) : memberKlass.isAssignableFrom(accessingKlass))) {
            return true;
        }
        if ((member.isProtected() || member.isPackagePrivate()) && accessingKlass.sameRuntimePackage(memberKlass)) {
            return true;
        }
        if (member.isPrivate() && MemberRefConstant.nestMateTest(accessingKlass, memberKlass)) {
            return true;
        }
        if (accessingKlass.getMeta().sun_reflect_MagicAccessorImpl.isAssignableFrom(accessingKlass)) {
            return true;
        }
        if (accessingKlass.getHostClass() != null) {
            return MemberRefConstant.checkAccess(accessingKlass.getHostClass(), resolvedKlass, member);
        }
        return false;
    }

    public static boolean nestMateTest(Klass k1, Klass k2) {
        return k1 == k2 || k1.nest() == k2.nest();
    }

    public static abstract class Indexes
    implements MemberRefConstant {
        final char classIndex;
        final char nameAndTypeIndex;

        Indexes(int classIndex, int nameAndTypeIndex) {
            this.classIndex = PoolConstant.u2(classIndex);
            this.nameAndTypeIndex = PoolConstant.u2(nameAndTypeIndex);
        }

        @Override
        public Symbol<Symbol.Name> getHolderKlassName(ConstantPool pool) {
            return pool.classAt(this.classIndex).getName(pool);
        }

        public Klass getResolvedHolderKlass(Klass accessingKlass, RuntimeConstantPool pool) {
            return pool.resolvedKlassAt(accessingKlass, this.classIndex);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return pool.nameAndTypeAt(this.nameAndTypeIndex).getName(pool);
        }

        @Override
        public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool pool) {
            return pool.nameAndTypeAt(this.nameAndTypeIndex).getDescriptor(pool);
        }

        @Override
        public void validate(ConstantPool pool) {
            pool.classAt(this.classIndex).validate(pool);
            pool.nameAndTypeAt(this.nameAndTypeIndex).validate(pool);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.classIndex);
            buf.putChar(this.nameAndTypeIndex);
        }
    }
}

