/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.NameAndTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.descriptors.Symbol;

public interface BootstrapMethodConstant
extends PoolConstant {
    public int getBootstrapMethodAttrIndex();

    public Symbol<Symbol.Name> getName(ConstantPool var1);

    public NameAndTypeConstant getNameAndType(ConstantPool var1);

    @Override
    default public String toString(ConstantPool pool) {
        return "bsmIndex:" + this.getBootstrapMethodAttrIndex() + " " + this.getNameAndType(pool);
    }

    public static abstract class Indexes
    implements BootstrapMethodConstant {
        protected final char bootstrapMethodAttrIndex;
        protected final char nameAndTypeIndex;

        Indexes(int bootstrapMethodAttrIndex, int nameAndTypeIndex) {
            this.bootstrapMethodAttrIndex = PoolConstant.u2(bootstrapMethodAttrIndex);
            this.nameAndTypeIndex = PoolConstant.u2(nameAndTypeIndex);
        }

        @Override
        public final int getBootstrapMethodAttrIndex() {
            return this.bootstrapMethodAttrIndex;
        }

        @Override
        public final Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.getNameAndType(pool).getName(pool);
        }

        @Override
        public NameAndTypeConstant getNameAndType(ConstantPool pool) {
            return pool.nameAndTypeAt(this.nameAndTypeIndex);
        }
    }
}

