/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.bytecode;

import com.oracle.truffle.espresso.bytecode.BytecodeStream;

public abstract class BytecodeSwitch {
    public static int getAlignedBci(int bci) {
        return bci + 4 & 0xFFFFFFFC;
    }

    public int targetAt(BytecodeStream stream, int bci, int i) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return bci + this.offsetAt(stream, bci, i);
    }

    public int defaultTarget(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return bci + this.defaultOffset(stream, bci);
    }

    public int defaultOffset(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return stream.readInt(BytecodeSwitch.getAlignedBci(bci));
    }

    public abstract int keyAt(BytecodeStream var1, int var2, int var3);

    public abstract int offsetAt(BytecodeStream var1, int var2, int var3);

    public abstract int numberOfCases(BytecodeStream var1, int var2);

    public abstract int size(BytecodeStream var1, int var2);

    protected abstract int getSwitchBytecode();
}

