/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.liveness;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.analysis.DepthFirstBlockIterator;
import com.oracle.truffle.espresso.analysis.GraphBuilder;
import com.oracle.truffle.espresso.analysis.Util;
import com.oracle.truffle.espresso.analysis.graph.Graph;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import com.oracle.truffle.espresso.analysis.liveness.BlockBoundaryFinder;
import com.oracle.truffle.espresso.analysis.liveness.BlockBoundaryResult;
import com.oracle.truffle.espresso.analysis.liveness.EdgeAction;
import com.oracle.truffle.espresso.analysis.liveness.LoadStoreFinder;
import com.oracle.truffle.espresso.analysis.liveness.LocalVariableAction;
import com.oracle.truffle.espresso.analysis.liveness.LoopPropagatorClosure;
import com.oracle.truffle.espresso.analysis.liveness.Record;
import com.oracle.truffle.espresso.analysis.liveness.actions.MultiAction;
import com.oracle.truffle.espresso.analysis.liveness.actions.NullOutAction;
import com.oracle.truffle.espresso.analysis.liveness.actions.SelectEdgeAction;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.perf.DebugCloseable;
import com.oracle.truffle.espresso.perf.DebugTimer;
import com.oracle.truffle.espresso.perf.TimerCollection;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LivenessAnalysis {
    public static final DebugTimer LIVENESS_TIMER = DebugTimer.create("liveness");
    public static final DebugTimer BUILDER_TIMER = DebugTimer.create("builder", LIVENESS_TIMER);
    public static final DebugTimer LOADSTORE_TIMER = DebugTimer.create("loadStore", LIVENESS_TIMER);
    public static final DebugTimer STATE_TIMER = DebugTimer.create("state", LIVENESS_TIMER);
    public static final DebugTimer PROPAGATE_TIMER = DebugTimer.create("propagation", LIVENESS_TIMER);
    public static final DebugTimer ACTION_TIMER = DebugTimer.create("action", LIVENESS_TIMER);
    private static final LivenessAnalysis NO_ANALYSIS = new LivenessAnalysis(null, null, null, null);
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LocalVariableAction[] postBci;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final EdgeAction[] edge;
    private final LocalVariableAction onStart;
    private final CatchUpMap catchUpMap;

    public void performOnEdge(VirtualFrame frame, int bci, int nextBci, boolean disable) {
        if (CompilerDirectives.inCompiledCode() && !disable && this.edge != null && this.edge[nextBci] != null) {
            this.edge[nextBci].onEdge(frame, bci);
        }
    }

    public void onStart(VirtualFrame frame, boolean disable) {
        if (CompilerDirectives.inCompiledCode() && !disable && this.onStart != null) {
            this.onStart.execute(frame);
        }
    }

    public void performPostBCI(VirtualFrame frame, int bci, boolean disable) {
        if (CompilerDirectives.inCompiledCode() && !disable && this.postBci != null && this.postBci[bci] != null) {
            this.postBci[bci].execute(frame);
        }
    }

    public void catchUpOSR(VirtualFrame frame, int bci, boolean disable) {
        CompilerAsserts.neverPartOfCompilation();
        if (!disable && this.catchUpMap != null) {
            this.catchUpMap.catchUp(frame, bci);
        }
    }

    public static LivenessAnalysis analyze(Method.MethodVersion methodVersion) {
        EspressoLanguage language = methodVersion.getMethod().getLanguage();
        if (!LivenessAnalysis.enableLivenessAnalysis(language, methodVersion)) {
            return NO_ANALYSIS;
        }
        Method method = methodVersion.getMethod();
        TimerCollection scope = method.getContext().getTimers();
        try (DebugCloseable liveness = LIVENESS_TIMER.scope(scope);){
            BlockBoundaryFinder blockBoundaryFinder;
            LoadStoreFinder loadStoreClosure;
            Graph<? extends LinkedBlock> graph;
            try (DebugCloseable builder = BUILDER_TIMER.scope(scope);){
                graph = GraphBuilder.build(method);
            }
            try (DebugCloseable loadStore = LOADSTORE_TIMER.scope(scope);){
                loadStoreClosure = new LoadStoreFinder(graph, method);
                loadStoreClosure.analyze();
            }
            try (DebugCloseable boundary = STATE_TIMER.scope(scope);){
                blockBoundaryFinder = new BlockBoundaryFinder(methodVersion, loadStoreClosure.result());
                DepthFirstBlockIterator.analyze(method, graph, blockBoundaryFinder);
            }
            try (DebugCloseable propagation = PROPAGATE_TIMER.scope(scope);){
                LoopPropagatorClosure loopPropagation = new LoopPropagatorClosure(graph, blockBoundaryFinder.result());
                while (loopPropagation.process(graph)) {
                }
            }
            DebugCloseable actionFinder = ACTION_TIMER.scope(scope);
            try {
                Builder builder = new Builder(graph, methodVersion, blockBoundaryFinder.result());
                builder.build();
                LivenessAnalysis livenessAnalysis = new LivenessAnalysis(builder.actions, builder.edge, builder.onStart, builder.catchUpMap);
                if (actionFinder != null) {
                    actionFinder.close();
                }
                return livenessAnalysis;
            }
            catch (Throwable throwable) {
                if (actionFinder != null) {
                    try {
                        actionFinder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static boolean enableLivenessAnalysis(EspressoLanguage language, Method.MethodVersion methodVersion) {
        if (LivenessAnalysis.isExempt(methodVersion.getMethod())) {
            return false;
        }
        switch (language.getLivenessAnalysisMode()) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case AUTO: {
                return methodVersion.getMaxLocals() >= language.livenessAnalysisMinimumLocals();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    private static boolean isExempt(Method m) {
        return m.getDeclaringKlass() == m.getMeta().java_security_AccessController && m.getName() == Symbol.Name.executePrivileged || m.isScoped();
    }

    private LivenessAnalysis(LocalVariableAction[] postBci, EdgeAction[] edge, LocalVariableAction onStart, CatchUpMap catchUpMap) {
        this.postBci = postBci;
        this.edge = edge;
        this.onStart = onStart;
        this.catchUpMap = catchUpMap;
    }

    private void log(PrintStream ps) {
        int i;
        ps.println("on start: " + this.onStart);
        for (i = 0; i < this.postBci.length; ++i) {
            EdgeAction edgeAction;
            LocalVariableAction post = this.postBci[i];
            if (post != null) {
                ps.println(i + "- post: " + post);
            }
            if ((edgeAction = this.edge[i]) == null) continue;
            ps.println("at " + i);
            ps.println(edgeAction.toString());
        }
        if (this.catchUpMap != null) {
            ps.println("Catch up data:");
            for (i = 0; i < this.catchUpMap.actions.length; ++i) {
                ps.println("\tAt " + this.catchUpMap.loopStarts[i] + ": " + this.catchUpMap.actions[i]);
            }
        }
    }

    private static final class CatchUpMap {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] loopStarts;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final LocalVariableAction[] actions;

        CatchUpMap(Map<Integer, LocalVariableAction> data) {
            this.loopStarts = new int[data.size()];
            this.actions = new LocalVariableAction[data.size()];
            int pos = 0;
            for (Map.Entry<Integer, LocalVariableAction> entry : data.entrySet()) {
                this.loopStarts[pos] = entry.getKey();
                this.actions[pos] = entry.getValue();
                ++pos;
            }
        }

        public void catchUp(VirtualFrame frame, int loopsStartBci) {
            for (int i = 0; i < this.loopStarts.length; ++i) {
                if (this.loopStarts[i] != loopsStartBci) continue;
                this.actions[i].execute(frame);
                return;
            }
        }
    }

    private static final class Builder {
        private final LocalVariableAction[] actions;
        private final EdgeAction[] edge;
        private LocalVariableAction onStart;
        private CatchUpMap catchUpMap;
        private final Graph<? extends LinkedBlock> graph;
        private final Method.MethodVersion method;
        private final BlockBoundaryResult helper;

        private Builder(Graph<? extends LinkedBlock> graph, Method.MethodVersion method, BlockBoundaryResult helper) {
            this.actions = new LocalVariableAction[method.getOriginalCode().length];
            this.edge = new EdgeAction[method.getOriginalCode().length];
            this.graph = graph;
            this.method = method;
            this.helper = helper;
        }

        private void build() {
            for (int id = 0; id < this.graph.totalBlocks(); ++id) {
                this.processBlock(id);
            }
            this.processBackEdges();
        }

        private void processBlock(int blockID) {
            LinkedBlock current = this.graph.get(blockID);
            if (current == this.graph.entryBlock()) {
                this.processEntryBlock(blockID);
            } else {
                if (this.isUnreachable(blockID)) {
                    return;
                }
                BitSet mergedEntryState = this.mergePredecessors(current);
                this.killLocalsOnBlockEntry(blockID, current, mergedEntryState);
            }
            this.replayHistory(blockID);
        }

        private boolean isUnreachable(int blockID) {
            return this.helper.entryFor(blockID) == null;
        }

        private LocalVariableAction extractKills(BitSet entryState) {
            ArrayList<Integer> kills = new ArrayList<Integer>();
            for (int dead : Util.bitSetUnsetIterator(entryState, this.method.getMaxLocals())) {
                kills.add(dead);
            }
            if (!kills.isEmpty()) {
                return Builder.toLocalAction(kills);
            }
            return null;
        }

        private void processBackEdges() {
            Set<Integer> loopBlockIds = this.helper.getLoops().keySet();
            HashMap<Integer, LocalVariableAction> map = new HashMap<Integer, LocalVariableAction>();
            for (int id : loopBlockIds) {
                BitSet live = this.helper.entryFor(id);
                LocalVariableAction action = this.extractKills(live);
                if (action == null) continue;
                map.put(this.graph.get(id).start(), action);
            }
            if (!map.isEmpty()) {
                this.catchUpMap = new CatchUpMap(map);
            }
        }

        private void processEntryBlock(int blockID) {
            BitSet entryState = this.helper.entryFor(blockID);
            this.onStart = this.extractKills(entryState);
        }

        private BitSet mergePredecessors(LinkedBlock current) {
            BitSet mergedEntryState = new BitSet(this.method.getMaxLocals());
            for (int pred : current.predecessorsID()) {
                BitSet predState = this.helper.endFor(pred);
                if (predState == null) continue;
                mergedEntryState.or(predState);
            }
            return mergedEntryState;
        }

        private void killLocalsOnBlockEntry(int blockID, LinkedBlock current, BitSet mergedEntryState) {
            BitSet entryState = this.helper.entryFor(blockID);
            if (entryState == null) {
                return;
            }
            mergedEntryState.andNot(entryState);
            int nbPredKills = 0;
            int[] predecessors = current.predecessorsID();
            ArrayList[] kills = new ArrayList[predecessors.length];
            for (int local : Util.bitSetSetIterator(mergedEntryState)) {
                for (int j = 0; j < predecessors.length; ++j) {
                    int pred = predecessors[j];
                    BitSet predEnd = this.helper.endFor(pred);
                    if (predEnd == null || !predEnd.get(local)) continue;
                    ArrayList<Integer> kill = kills[j];
                    if (kill == null) {
                        kills[j] = kill = new ArrayList<Integer>();
                        ++nbPredKills;
                    }
                    kill.add(local);
                }
            }
            if (nbPredKills > 0) {
                int pos = 0;
                int[] predBCIs = new int[nbPredKills];
                LocalVariableAction[] edgeActions = new LocalVariableAction[nbPredKills];
                for (int p = 0; p < predecessors.length; ++p) {
                    ArrayList clears = kills[p];
                    if (clears == null) continue;
                    predBCIs[pos] = this.graph.get(predecessors[p]).lastBCI();
                    edgeActions[pos] = Builder.toLocalAction(clears);
                    ++pos;
                }
                assert (pos == nbPredKills);
                this.edge[current.start()] = new SelectEdgeAction(predBCIs, edgeActions);
            }
        }

        private static LocalVariableAction toLocalAction(List<Integer> actions) {
            assert (!actions.isEmpty());
            if (actions.size() == 1) {
                return NullOutAction.get(actions.get(0));
            }
            return new MultiAction(Util.toIntArray(actions));
        }

        private void replayHistory(int blockID) {
            BitSet endState = this.helper.endFor(blockID);
            if (endState == null) {
                return;
            }
            endState = (BitSet)endState.clone();
            for (Record r : this.helper.historyFor(blockID).reverse()) {
                switch (r.type) {
                    case LOAD: 
                    case IINC: {
                        if (endState.get(r.local)) break;
                        this.recordAction(r.bci, NullOutAction.get(r.local));
                        endState.set(r.local);
                        break;
                    }
                    case STORE: {
                        if (!endState.get(r.local)) {
                            this.recordAction(r.bci, NullOutAction.get(r.local));
                            break;
                        }
                        endState.clear(r.local);
                    }
                }
            }
        }

        private void recordAction(int bci, LocalVariableAction action) {
            LocalVariableAction toInsert = action;
            if (this.actions[bci] != null) {
                toInsert = this.actions[bci].merge(toInsert);
            }
            this.actions[bci] = toInsert;
        }
    }
}

