/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.hierarchy;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.analysis.hierarchy.AssumptionGuardedValue;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class SingleImplementor {
    @CompilerDirectives.CompilationFinal
    private volatile AssumptionGuardedValue<ObjectKlass> currentState;
    private static final AtomicReferenceFieldUpdater<SingleImplementor, AssumptionGuardedValue> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleImplementor.class, AssumptionGuardedValue.class, "currentState");
    static final AssumptionGuardedValue<ObjectKlass> NoImplementorsState = AssumptionGuardedValue.createInvalid();
    static final SingleImplementor MultipleImplementors = new SingleImplementor(AssumptionGuardedValue.createInvalid());
    static final AssumptionGuardedValue<ObjectKlass> MultipleImplementorsState = MultipleImplementors.read();

    private SingleImplementor(AssumptionGuardedValue<ObjectKlass> state) {
        this.currentState = state;
    }

    SingleImplementor() {
        this.currentState = NoImplementorsState;
    }

    SingleImplementor(ObjectKlass implementor) {
        this.currentState = AssumptionGuardedValue.create(implementor);
    }

    void addImplementor(ObjectKlass.KlassVersion implementor) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.currentState == MultipleImplementorsState) {
            return;
        }
        AssumptionGuardedValue<ObjectKlass> singleImplementor = AssumptionGuardedValue.create(implementor.getKlass());
        if (!STATE_UPDATER.compareAndSet(this, NoImplementorsState, singleImplementor)) {
            AssumptionGuardedValue<ObjectKlass> state = this.currentState;
            if (state.value == implementor.getKlass()) {
                return;
            }
            while (!STATE_UPDATER.compareAndSet(this, state, MultipleImplementorsState)) {
                state = this.currentState;
            }
            state.hasValue().invalidate("Single implementor invalidated");
        }
    }

    public AssumptionGuardedValue<ObjectKlass> read() {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant(this.currentState);
        return this.currentState;
    }
}

