/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.hierarchy;

import com.oracle.truffle.espresso.analysis.hierarchy.AssumptionGuardedValue;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumption;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumptionImpl;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyOracle;
import com.oracle.truffle.espresso.analysis.hierarchy.SingleImplementor;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;

public final class DefaultClassHierarchyOracle
implements ClassHierarchyOracle {
    @Override
    public void registerNewKlassVersion(ObjectKlass.KlassVersion newVersion) {
        if (newVersion.isConcrete()) {
            this.addImplementorToAncestors(newVersion);
            this.updateVirtualAndInterfaceTables(newVersion);
        }
    }

    @Override
    public ClassHierarchyAssumption createAssumptionForNewKlass(ObjectKlass newKlass) {
        return new ClassHierarchyAssumptionImpl(newKlass);
    }

    @Override
    public ClassHierarchyAssumption isLeafKlass(ObjectKlass klass) {
        if (klass.isConcrete()) {
            return klass.getNoConcreteSubclassesAssumption(ClassHierarchyOracle.ClassHierarchyAccessor.accessor);
        }
        return ClassHierarchyAssumptionImpl.NeverValid;
    }

    @Override
    public ClassHierarchyAssumption hasNoImplementors(ObjectKlass klass) {
        if (klass.isAbstract() || klass.isInterface()) {
            return klass.getNoConcreteSubclassesAssumption(ClassHierarchyOracle.ClassHierarchyAccessor.accessor);
        }
        return ClassHierarchyAssumptionImpl.NeverValid;
    }

    private void addImplementor(ObjectKlass superInterface, ObjectKlass.KlassVersion implementor) {
        superInterface.getNoConcreteSubclassesAssumption(ClassHierarchyOracle.ClassHierarchyAccessor.accessor).invalidate();
        superInterface.getImplementor(ClassHierarchyOracle.ClassHierarchyAccessor.accessor).addImplementor(implementor);
        for (ObjectKlass ancestorInterface : superInterface.getSuperInterfaces()) {
            this.addImplementor(ancestorInterface, implementor);
        }
    }

    private void addImplementorToAncestors(ObjectKlass.KlassVersion newKlass) {
        for (ObjectKlass superInterface : newKlass.getSuperInterfaces()) {
            this.addImplementor(superInterface, newKlass);
        }
        for (ObjectKlass currentKlass = newKlass.getSuperKlass(); currentKlass != null; currentKlass = currentKlass.getSuperKlass()) {
            currentKlass.getNoConcreteSubclassesAssumption(ClassHierarchyOracle.ClassHierarchyAccessor.accessor).invalidate();
            currentKlass.getImplementor(ClassHierarchyOracle.ClassHierarchyAccessor.accessor).addImplementor(newKlass);
            for (ObjectKlass superInterface : currentKlass.getSuperInterfaces()) {
                this.addImplementor(superInterface, newKlass);
            }
        }
    }

    private void updateVirtualAndInterfaceTables(ObjectKlass.KlassVersion newKlassVersion) {
        ObjectKlass newKlass = newKlassVersion.getKlass();
        Method.MethodVersion[] vTable = newKlass.getVTable();
        block0: for (int i = 0; i < vTable.length; ++i) {
            Method.MethodVersion[] superVTable;
            Method.MethodVersion m = vTable[i];
            for (ObjectKlass current = newKlassVersion.getSuperKlass(); current != null && i < (superVTable = current.getKlassVersion().getVtable()).length; current = current.getSuperKlass()) {
                Method.MethodVersion overridden = superVTable[i];
                if (overridden != m) {
                    overridden.getMethod().getLeafAssumption(ClassHierarchyOracle.ClassHierarchyAccessor.accessor).invalidate();
                }
                if (current.isConcrete()) continue block0;
            }
        }
        Method.MethodVersion[][] itables = newKlassVersion.getItable();
        for (int tableIndex = 0; tableIndex < itables.length; ++tableIndex) {
            this.updateLeafAssumptions(itables[tableIndex], newKlassVersion.getiKlassTable()[tableIndex].getKlass());
        }
    }

    private void updateLeafAssumptions(Method.MethodVersion[] itable, ObjectKlass currInterface) {
        for (int methodIndex = 0; methodIndex < itable.length; ++methodIndex) {
            Method.MethodVersion m = itable[methodIndex];
            if (m.getDeclaringKlassRef() == currInterface) continue;
            Method.MethodVersion intfMethod = currInterface.getInterfaceMethodsTable()[methodIndex];
            assert (intfMethod.getDeclaringKlassRef() == currInterface);
            assert (m.getMethod().canOverride(intfMethod.getMethod()) && m.getName() == intfMethod.getName() && m.getRawSignature() == intfMethod.getRawSignature());
            this.isLeafMethod(intfMethod).invalidate();
        }
    }

    @Override
    public SingleImplementor initializeImplementorForNewKlass(ObjectKlass klass) {
        if (klass.getType() == Symbol.Type.java_io_Serializable || klass.getType() == Symbol.Type.java_lang_Cloneable) {
            return SingleImplementor.MultipleImplementors;
        }
        if (klass.isAbstract() || klass.isInterface()) {
            return new SingleImplementor();
        }
        return new SingleImplementor(klass);
    }

    @Override
    public AssumptionGuardedValue<ObjectKlass> readSingleImplementor(ObjectKlass klass) {
        return klass.getImplementor(ClassHierarchyOracle.ClassHierarchyAccessor.accessor).read();
    }

    @Override
    public ClassHierarchyAssumption createLeafAssumptionForNewMethod(Method newMethod) {
        if (newMethod.isAbstract()) {
            return ClassHierarchyAssumptionImpl.NeverValid;
        }
        if (newMethod.isStatic() || newMethod.isPrivate() || newMethod.isFinalFlagSet()) {
            return ClassHierarchyAssumptionImpl.AlwaysValid;
        }
        return new ClassHierarchyAssumptionImpl(newMethod);
    }

    @Override
    public ClassHierarchyAssumption isLeafMethod(Method method) {
        return method.getLeafAssumption(ClassHierarchyOracle.ClassHierarchyAccessor.accessor);
    }
}

