/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.graph;

import com.oracle.truffle.espresso.analysis.graph.EspressoBlock;
import com.oracle.truffle.espresso.analysis.graph.Graph;
import com.oracle.truffle.espresso.meta.ExceptionHandler;
import java.util.BitSet;

public final class EspressoExecutionGraph
implements Graph<EspressoBlock> {
    private final ExceptionHandler[] handlers;
    private final int[] handlerToBlock;
    private final EspressoBlock[] blocks;

    public EspressoExecutionGraph(ExceptionHandler[] handlers, int[] handlerToBlock, EspressoBlock[] blocks) {
        this.handlers = handlers;
        this.handlerToBlock = handlerToBlock;
        this.blocks = blocks;
    }

    @Override
    public int totalBlocks() {
        return this.blocks.length;
    }

    @Override
    public EspressoBlock entryBlock() {
        return this.blocks[0];
    }

    @Override
    public EspressoBlock get(int blockID) {
        return this.blocks[blockID];
    }

    public ExceptionHandler getHandler(int handlerID) {
        return this.handlers[handlerID];
    }

    public int getHandlerBlock(int handlerID) {
        return this.handlerToBlock[handlerID];
    }

    public String toString() {
        return this.visit(new GraphVisitor<String>(){
            StringBuilder str;
            int indent;
            {
                this.str = new StringBuilder();
                this.indent = 0;
            }

            @Override
            protected String result() {
                return this.str.toString();
            }

            @Override
            protected void visitImpl(EspressoBlock block) {
                this.appendItem(block.toString());
            }

            private StringBuilder indent() {
                for (int i = 0; i < this.indent; ++i) {
                    this.str.append("  ");
                }
                return this.str;
            }

            private void appendItem(String s) {
                this.indent();
                this.str.append(s).append('\n');
            }
        });
    }

    private <T> T visit(GraphVisitor<T> visitor) {
        for (EspressoBlock block : this.blocks) {
            visitor.visit(block);
        }
        return visitor.result();
    }

    private abstract class GraphVisitor<T> {
        private final BitSet visited;

        private GraphVisitor() {
            this.visited = new BitSet(EspressoExecutionGraph.this.blocks.length);
        }

        public void visit(EspressoBlock block) {
            int id = block.id();
            if (this.visited.get(id)) {
                return;
            }
            this.visited.set(id);
            this.visitImpl(block);
        }

        protected abstract void visitImpl(EspressoBlock var1);

        protected abstract T result();
    }
}

