/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis.graph;

import com.oracle.truffle.espresso.analysis.Util;
import com.oracle.truffle.espresso.analysis.graph.EspressoExecutionGraph;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import java.util.Arrays;

public class EspressoBlock
implements LinkedBlock {
    public static final int[] EMPTY_ID_ARRAY = new int[0];
    private final EspressoExecutionGraph graph;
    private final int id;
    private final int start;
    private final int end;
    private final int last;
    private final int[] successors;
    private final int[] predecessors;

    public EspressoExecutionGraph graph() {
        return this.graph;
    }

    public EspressoBlock(EspressoExecutionGraph graph, int id, int start, int end, int last, int[] successors, int[] predecessors) {
        this.graph = graph;
        this.id = id;
        this.start = start;
        this.end = end;
        this.last = last;
        this.successors = successors;
        this.predecessors = predecessors;
        assert (Util.assertNoDupe(successors));
        assert (Util.assertNoDupe(predecessors));
    }

    @Override
    public final int start() {
        return this.start;
    }

    @Override
    public final int end() {
        return this.end;
    }

    @Override
    public int lastBCI() {
        return this.last;
    }

    @Override
    public final boolean isLeaf() {
        return this.successorsID().length == 0;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int[] successorsID() {
        return this.successors;
    }

    @Override
    public int[] predecessorsID() {
        return this.predecessors;
    }

    public String toString() {
        return "B" + this.id + "[" + this.start + ", " + this.end + "] to: " + Arrays.toString(this.successorsID());
    }
}

