/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis;

import com.oracle.truffle.espresso.analysis.BlockIterator;
import com.oracle.truffle.espresso.analysis.BlockIteratorClosure;
import com.oracle.truffle.espresso.analysis.graph.Graph;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import com.oracle.truffle.espresso.impl.Method;

public final class DepthFirstBlockIterator
extends BlockIterator {
    private final IntArrayIterator[] successors;

    public static void analyze(Method m, Graph<? extends LinkedBlock> graph, BlockIteratorClosure closure) {
        new DepthFirstBlockIterator(m, graph, closure).analyze();
    }

    public static void analyze(Graph<? extends LinkedBlock> graph, BlockIteratorClosure closure) {
        new DepthFirstBlockIterator(graph, closure).analyze();
    }

    private DepthFirstBlockIterator(Method m, Graph<? extends LinkedBlock> graph, BlockIteratorClosure closure) {
        super(m, graph, closure);
        this.successors = new IntArrayIterator[graph.totalBlocks()];
    }

    private DepthFirstBlockIterator(Graph<? extends LinkedBlock> graph, BlockIteratorClosure closure) {
        super(graph, closure);
        this.successors = new IntArrayIterator[graph.totalBlocks()];
    }

    @Override
    protected void processResult(LinkedBlock b, BlockIterator.BlockProcessResult result) {
        switch (result) {
            case SKIP: {
                this.pushNextSuccessor(b);
                break;
            }
            case DONE: {
                this.done.set(b.id());
                this.pop();
            }
        }
    }

    private void pushNextSuccessor(LinkedBlock b) {
        IntArrayIterator iterator = this.successors[b.id()];
        if (iterator == null) {
            this.successors[b.id()] = iterator = new IntArrayIterator(this.closure.getSuccessors(b));
        }
        assert (iterator.hasNext());
        while (iterator.hasNext() && !this.push((LinkedBlock)this.graph.get(iterator.next()))) {
        }
    }

    private static final class IntArrayIterator {
        final int[] array;
        int pos = 0;

        private IntArrayIterator(int[] array) {
            this.array = array;
        }

        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        public int next() {
            return this.array[this.pos++];
        }
    }
}

