/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.jni.JniEnv;

public final class Structs {

    public final JavaVMAttachArgs javaVMAttachArgs;

    public final JdkVersionInfo jdkVersionInfo;

    public final MemberInfo memberInfo;

    public final JvmtiThreadInfo jvmtiThreadInfo;

    public final JvmtiMonitorStackDepthInfo jvmtiMonitorStackDepthInfo;

    public final JvmtiThreadGroupInfo jvmtiThreadGroupInfo;

    public final JvmtiFrameInfo jvmtiFrameInfo;

    public final JvmtiStackInfo jvmtiStackInfo;

    public final JvmtiHeapReferenceInfoField jvmtiHeapReferenceInfoField;

    public final JvmtiHeapReferenceInfoArray jvmtiHeapReferenceInfoArray;

    public final JvmtiHeapReferenceInfoConstantPool jvmtiHeapReferenceInfoConstantPool;

    public final JvmtiHeapReferenceInfoStackLocal jvmtiHeapReferenceInfoStackLocal;

    public final JvmtiHeapReferenceInfoJniLocal jvmtiHeapReferenceInfoJniLocal;

    public final JvmtiHeapReferenceInfoReserved jvmtiHeapReferenceInfoReserved;

    public final JvmtiHeapCallbacks jvmtiHeapCallbacks;

    public final JvmtiClassDefinition jvmtiClassDefinition;

    public final JvmtiMonitorUsage jvmtiMonitorUsage;

    public final JvmtiLineNumberEntry jvmtiLineNumberEntry;

    public final JvmtiLocalVariableEntry jvmtiLocalVariableEntry;

    public final JvmtiParamInfo jvmtiParamInfo;

    public final JvmtiExtensionFunctionInfo jvmtiExtensionFunctionInfo;

    public final JvmtiExtensionEventInfo jvmtiExtensionEventInfo;

    public final JvmtiTimerInfo jvmtiTimerInfo;

    public final JvmtiAddrLocationMap jvmtiAddrLocationMap;

    public final JvmtiEventCallbacks jvmtiEventCallbacks;

    public Structs(JniEnv jni, TruffleObject memberInfoPtr, TruffleObject lookupMemberOffset) {
        InteropLibrary library = InteropLibrary.getUncached();
        MemberOffsetGetter offsetGetter = new NativeMemberOffsetGetter(library, memberInfoPtr, lookupMemberOffset);
        memberInfo = new MemberInfo(offsetGetter);
        offsetGetter = new JavaMemberOffsetGetter(jni, memberInfoPtr, this);
        javaVMAttachArgs = new JavaVMAttachArgs(offsetGetter);
        jdkVersionInfo = new JdkVersionInfo(offsetGetter);
        jvmtiThreadInfo = new JvmtiThreadInfo(offsetGetter);
        jvmtiMonitorStackDepthInfo = new JvmtiMonitorStackDepthInfo(offsetGetter);
        jvmtiThreadGroupInfo = new JvmtiThreadGroupInfo(offsetGetter);
        jvmtiFrameInfo = new JvmtiFrameInfo(offsetGetter);
        jvmtiStackInfo = new JvmtiStackInfo(offsetGetter);
        jvmtiHeapReferenceInfoField = new JvmtiHeapReferenceInfoField(offsetGetter);
        jvmtiHeapReferenceInfoArray = new JvmtiHeapReferenceInfoArray(offsetGetter);
        jvmtiHeapReferenceInfoConstantPool = new JvmtiHeapReferenceInfoConstantPool(offsetGetter);
        jvmtiHeapReferenceInfoStackLocal = new JvmtiHeapReferenceInfoStackLocal(offsetGetter);
        jvmtiHeapReferenceInfoJniLocal = new JvmtiHeapReferenceInfoJniLocal(offsetGetter);
        jvmtiHeapReferenceInfoReserved = new JvmtiHeapReferenceInfoReserved(offsetGetter);
        jvmtiHeapCallbacks = new JvmtiHeapCallbacks(offsetGetter);
        jvmtiClassDefinition = new JvmtiClassDefinition(offsetGetter);
        jvmtiMonitorUsage = new JvmtiMonitorUsage(offsetGetter);
        jvmtiLineNumberEntry = new JvmtiLineNumberEntry(offsetGetter);
        jvmtiLocalVariableEntry = new JvmtiLocalVariableEntry(offsetGetter);
        jvmtiParamInfo = new JvmtiParamInfo(offsetGetter);
        jvmtiExtensionFunctionInfo = new JvmtiExtensionFunctionInfo(offsetGetter);
        jvmtiExtensionEventInfo = new JvmtiExtensionEventInfo(offsetGetter);
        jvmtiTimerInfo = new JvmtiTimerInfo(offsetGetter);
        jvmtiAddrLocationMap = new JvmtiAddrLocationMap(offsetGetter);
        jvmtiEventCallbacks = new JvmtiEventCallbacks(offsetGetter);
    }

}

