/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import java.nio.ByteBuffer;

import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.ffi.RawPointer;

@SuppressWarnings(value = "unused") public final class JvmtiHeapReferenceInfoStackLocal extends StructStorage<JvmtiHeapReferenceInfoStackLocal.JvmtiHeapReferenceInfoStackLocalWrapper> {

    final int thread_tag;

    final int thread_id;

    final int depth;

    final int method;

    final int location;

    final int slot;

    JvmtiHeapReferenceInfoStackLocal(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiHeapReferenceInfoStackLocal"));
        thread_tag = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoStackLocal", "thread_tag");
        thread_id = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoStackLocal", "thread_id");
        depth = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoStackLocal", "depth");
        method = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoStackLocal", "method");
        location = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoStackLocal", "location");
        slot = (int) offsetGetter.getOffset("_jvmtiHeapReferenceInfoStackLocal", "slot");
    }

    public final class JvmtiHeapReferenceInfoStackLocalWrapper extends StructWrapper {

        JvmtiHeapReferenceInfoStackLocalWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, structSize);
        }

        public long threadTag() {
            return getLong(thread_tag);
        }

        public void threadTag(long valueToPut) {
            putLong(thread_tag, valueToPut);
        }

        public long threadId() {
            return getLong(thread_id);
        }

        public void threadId(long valueToPut) {
            putLong(thread_id, valueToPut);
        }

        public int depth() {
            return getInt(depth);
        }

        public void depth(int valueToPut) {
            putInt(depth, valueToPut);
        }

        public long method() {
            return getLong(method);
        }

        public void method(long valueToPut) {
            putLong(method, valueToPut);
        }

        public long location() {
            return getLong(location);
        }

        public void location(long valueToPut) {
            putLong(location, valueToPut);
        }

        public int slot() {
            return getInt(slot);
        }

        public void slot(int valueToPut) {
            putInt(slot, valueToPut);
        }

    }

    @Override
    public JvmtiHeapReferenceInfoStackLocalWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiHeapReferenceInfoStackLocalWrapper(jni, pointer);
    }

}

