/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import java.nio.ByteBuffer;

import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.ffi.RawPointer;

@SuppressWarnings(value = "unused") public final class JvmtiHeapCallbacks extends StructStorage<JvmtiHeapCallbacks.JvmtiHeapCallbacksWrapper> {

    final int heap_iteration_callback;

    final int heap_reference_callback;

    final int primitive_field_callback;

    final int array_primitive_value_callback;

    final int string_primitive_value_callback;

    final int reserved5;

    final int reserved6;

    final int reserved7;

    final int reserved8;

    final int reserved9;

    final int reserved10;

    final int reserved11;

    final int reserved12;

    final int reserved13;

    final int reserved14;

    final int reserved15;

    JvmtiHeapCallbacks(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiHeapCallbacks"));
        heap_iteration_callback = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "heap_iteration_callback");
        heap_reference_callback = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "heap_reference_callback");
        primitive_field_callback = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "primitive_field_callback");
        array_primitive_value_callback = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "array_primitive_value_callback");
        string_primitive_value_callback = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "string_primitive_value_callback");
        reserved5 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved5");
        reserved6 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved6");
        reserved7 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved7");
        reserved8 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved8");
        reserved9 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved9");
        reserved10 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved10");
        reserved11 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved11");
        reserved12 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved12");
        reserved13 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved13");
        reserved14 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved14");
        reserved15 = (int) offsetGetter.getOffset("_jvmtiHeapCallbacks", "reserved15");
    }

    public final class JvmtiHeapCallbacksWrapper extends StructWrapper {

        JvmtiHeapCallbacksWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, structSize);
        }

        public TruffleObject heapIterationCallback() {
            return getPointer(heap_iteration_callback);
        }

        public void heapIterationCallback(TruffleObject valueToPut) {
            putPointer(heap_iteration_callback, valueToPut);
        }

        public TruffleObject heapReferenceCallback() {
            return getPointer(heap_reference_callback);
        }

        public void heapReferenceCallback(TruffleObject valueToPut) {
            putPointer(heap_reference_callback, valueToPut);
        }

        public TruffleObject primitiveFieldCallback() {
            return getPointer(primitive_field_callback);
        }

        public void primitiveFieldCallback(TruffleObject valueToPut) {
            putPointer(primitive_field_callback, valueToPut);
        }

        public TruffleObject arrayPrimitiveValueCallback() {
            return getPointer(array_primitive_value_callback);
        }

        public void arrayPrimitiveValueCallback(TruffleObject valueToPut) {
            putPointer(array_primitive_value_callback, valueToPut);
        }

        public TruffleObject stringPrimitiveValueCallback() {
            return getPointer(string_primitive_value_callback);
        }

        public void stringPrimitiveValueCallback(TruffleObject valueToPut) {
            putPointer(string_primitive_value_callback, valueToPut);
        }

        public TruffleObject reserved5() {
            return getPointer(reserved5);
        }

        public void reserved5(TruffleObject valueToPut) {
            putPointer(reserved5, valueToPut);
        }

        public TruffleObject reserved6() {
            return getPointer(reserved6);
        }

        public void reserved6(TruffleObject valueToPut) {
            putPointer(reserved6, valueToPut);
        }

        public TruffleObject reserved7() {
            return getPointer(reserved7);
        }

        public void reserved7(TruffleObject valueToPut) {
            putPointer(reserved7, valueToPut);
        }

        public TruffleObject reserved8() {
            return getPointer(reserved8);
        }

        public void reserved8(TruffleObject valueToPut) {
            putPointer(reserved8, valueToPut);
        }

        public TruffleObject reserved9() {
            return getPointer(reserved9);
        }

        public void reserved9(TruffleObject valueToPut) {
            putPointer(reserved9, valueToPut);
        }

        public TruffleObject reserved10() {
            return getPointer(reserved10);
        }

        public void reserved10(TruffleObject valueToPut) {
            putPointer(reserved10, valueToPut);
        }

        public TruffleObject reserved11() {
            return getPointer(reserved11);
        }

        public void reserved11(TruffleObject valueToPut) {
            putPointer(reserved11, valueToPut);
        }

        public TruffleObject reserved12() {
            return getPointer(reserved12);
        }

        public void reserved12(TruffleObject valueToPut) {
            putPointer(reserved12, valueToPut);
        }

        public TruffleObject reserved13() {
            return getPointer(reserved13);
        }

        public void reserved13(TruffleObject valueToPut) {
            putPointer(reserved13, valueToPut);
        }

        public TruffleObject reserved14() {
            return getPointer(reserved14);
        }

        public void reserved14(TruffleObject valueToPut) {
            putPointer(reserved14, valueToPut);
        }

        public TruffleObject reserved15() {
            return getPointer(reserved15);
        }

        public void reserved15(TruffleObject valueToPut) {
            putPointer(reserved15, valueToPut);
        }

    }

    @Override
    public JvmtiHeapCallbacksWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiHeapCallbacksWrapper(jni, pointer);
    }

}

