/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import java.nio.ByteBuffer;

import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.ffi.RawPointer;

@SuppressWarnings(value = "unused") public final class JvmtiExtensionEventInfo extends StructStorage<JvmtiExtensionEventInfo.JvmtiExtensionEventInfoWrapper> {

    final int extension_event_index;

    final int id;

    final int short_description;

    final int param_count;

    final int params;

    JvmtiExtensionEventInfo(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiExtensionEventInfo"));
        extension_event_index = (int) offsetGetter.getOffset("_jvmtiExtensionEventInfo", "extension_event_index");
        id = (int) offsetGetter.getOffset("_jvmtiExtensionEventInfo", "id");
        short_description = (int) offsetGetter.getOffset("_jvmtiExtensionEventInfo", "short_description");
        param_count = (int) offsetGetter.getOffset("_jvmtiExtensionEventInfo", "param_count");
        params = (int) offsetGetter.getOffset("_jvmtiExtensionEventInfo", "params");
    }

    public final class JvmtiExtensionEventInfoWrapper extends StructWrapper {

        JvmtiExtensionEventInfoWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, structSize);
        }

        public TruffleObject extensionEventIndex() {
            return getPointer(extension_event_index);
        }

        public void extensionEventIndex(TruffleObject valueToPut) {
            putPointer(extension_event_index, valueToPut);
        }

        public TruffleObject id() {
            return getPointer(id);
        }

        public void id(TruffleObject valueToPut) {
            putPointer(id, valueToPut);
        }

        public TruffleObject shortDescription() {
            return getPointer(short_description);
        }

        public void shortDescription(TruffleObject valueToPut) {
            putPointer(short_description, valueToPut);
        }

        public int paramCount() {
            return getInt(param_count);
        }

        public void paramCount(int valueToPut) {
            putInt(param_count, valueToPut);
        }

        public TruffleObject params() {
            return getPointer(params);
        }

        public void params(TruffleObject valueToPut) {
            putPointer(params, valueToPut);
        }

    }

    @Override
    public JvmtiExtensionEventInfoWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiExtensionEventInfoWrapper(jni, pointer);
    }

}

