/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm.structs;

import java.nio.ByteBuffer;

import com.oracle.truffle.api.interop.TruffleObject;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.ffi.RawPointer;

@SuppressWarnings(value = "unused") public final class JavaVMAttachArgs extends StructStorage<JavaVMAttachArgs.JavaVMAttachArgsWrapper> {

    final int version;

    final int name;

    final int group;

    JavaVMAttachArgs(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("JavaVMAttachArgs"));
        version = (int) offsetGetter.getOffset("JavaVMAttachArgs", "version");
        name = (int) offsetGetter.getOffset("JavaVMAttachArgs", "name");
        group = (int) offsetGetter.getOffset("JavaVMAttachArgs", "group");
    }

    public final class JavaVMAttachArgsWrapper extends StructWrapper {

        JavaVMAttachArgsWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, structSize);
        }

        public int version() {
            return getInt(version);
        }

        public void version(int valueToPut) {
            putInt(version, valueToPut);
        }

        public TruffleObject name() {
            return getPointer(name);
        }

        public void name(TruffleObject valueToPut) {
            putPointer(name, valueToPut);
        }

        public StaticObject group() {
            return getObject(group);
        }

        public void group(StaticObject valueToPut) {
            putObject(group, valueToPut);
        }

    }

    @Override
    public JavaVMAttachArgsWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JavaVMAttachArgsWrapper(jni, pointer);
    }

}

