/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.substitutions.Collect;

/**
 * Generated by: {@link VM#JVM_LookupDefineClass(StaticObject, TruffleObject, TruffleObject, int, StaticObject, boolean, int, StaticObject)}
 */
public final class VM_JVM_LookupDefineClass__LLLILZIL extends CallableFromNative {

    @Collect(value = com.oracle.truffle.espresso.vm.VmImpl.class) public static final class Factory extends CallableFromNative.Factory {

        public Factory() {
            super(
                "JVM_LookupDefineClass",
                NativeSignature.create(NativeType.OBJECT, NativeType.POINTER, NativeType.OBJECT, NativeType.POINTER, NativeType.POINTER, NativeType.INT, NativeType.OBJECT, NativeType.BOOLEAN, NativeType.INT, NativeType.OBJECT),
                8,
                true
            );
        }

        @Override
        public final CallableFromNative create() {
            return new VM_JVM_LookupDefineClass__LLLILZIL();
        }

    }

    @SuppressWarnings(value = "unused") private VM_JVM_LookupDefineClass__LLLILZIL() {
    }

    @Override
    public final CallableFromNative split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        VM vm = (VM) env;
        StaticObject arg0 = vm.getHandles().get(Math.toIntExact((long) args[1]));
        TruffleObject arg1 = (TruffleObject) args[2];
        TruffleObject arg2 = (TruffleObject) args[3];
        int arg3 = (int) args[4];
        StaticObject arg4 = vm.getHandles().get(Math.toIntExact((long) args[5]));
        boolean arg5 = (boolean) args[6];
        int arg6 = (int) args[7];
        StaticObject arg7 = vm.getHandles().get(Math.toIntExact((long) args[8]));
        return (long) vm.getHandles().createLocal(vm.JVM_LookupDefineClass(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7));
    }

    @Override
    public final Object invokeDirect(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        VM vm = (VM) env;
        StaticObject arg0 = (StaticObject) args[0];
        TruffleObject arg1 = (TruffleObject) args[1];
        TruffleObject arg2 = (TruffleObject) args[2];
        int arg3 = (int) args[3];
        StaticObject arg4 = (StaticObject) args[4];
        boolean arg5 = (boolean) args[5];
        int arg6 = (int) args[6];
        StaticObject arg7 = (StaticObject) args[7];
        return vm.JVM_LookupDefineClass(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    @Override
    public final String generatedBy() {
        return "VmImpl";
    }

}

