/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.substitutions.Collect;

/**
 * Generated by: {@link VM#JVM_FindClassFromCaller(TruffleObject, boolean, StaticObject, StaticObject)}
 */
public final class VM_JVM_FindClassFromCaller__LZLL extends CallableFromNative {

    @Collect(value = com.oracle.truffle.espresso.vm.VmImpl.class) public static final class Factory extends CallableFromNative.Factory {

        public Factory() {
            super(
                "JVM_FindClassFromCaller",
                NativeSignature.create(NativeType.OBJECT, NativeType.POINTER, NativeType.POINTER, NativeType.BOOLEAN, NativeType.OBJECT, NativeType.OBJECT),
                4,
                true
            );
        }

        @Override
        public final CallableFromNative create() {
            return new VM_JVM_FindClassFromCaller__LZLL();
        }

    }

    @SuppressWarnings(value = "unused") private VM_JVM_FindClassFromCaller__LZLL() {
    }

    @Override
    public final CallableFromNative split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        VM vm = (VM) env;
        TruffleObject arg0 = (TruffleObject) args[1];
        boolean arg1 = (boolean) args[2];
        StaticObject arg2 = vm.getHandles().get(Math.toIntExact((long) args[3]));
        StaticObject arg3 = vm.getHandles().get(Math.toIntExact((long) args[4]));
        return (long) vm.getHandles().createLocal(vm.JVM_FindClassFromCaller(arg0, arg1, arg2, arg3));
    }

    @Override
    public final Object invokeDirect(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        VM vm = (VM) env;
        TruffleObject arg0 = (TruffleObject) args[0];
        boolean arg1 = (boolean) args[1];
        StaticObject arg2 = (StaticObject) args[2];
        StaticObject arg3 = (StaticObject) args[3];
        return vm.JVM_FindClassFromCaller(arg0, arg1, arg2, arg3);
    }

    @Override
    public final String generatedBy() {
        return "VmImpl";
    }

}

