/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.substitutions.Collect;

/**
 * Generated by: {@link Management#FindDeadlocks(boolean, Meta)}
 */
public final class Management_FindDeadlocks__Z extends CallableFromNative {

    @Collect(value = com.oracle.truffle.espresso.vm.ManagementImpl.class) public static final class Factory extends CallableFromNative.Factory {

        public Factory() {
            super(
                "FindDeadlocks",
                NativeSignature.create(NativeType.OBJECT, NativeType.POINTER, NativeType.BOOLEAN),
                1,
                true
            );
        }

        @Override
        public final CallableFromNative create() {
            return new Management_FindDeadlocks__Z();
        }

    }

    @SuppressWarnings(value = "unused") private Management_FindDeadlocks__Z() {
    }

    @Override
    public final CallableFromNative split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object env, Object[] args) {
        com.oracle.truffle.api.TruffleSafepoint.poll(this);
        Management management = (Management) env;
        boolean arg0 = (boolean) args[1];
        EspressoContext context = getContext();
        return (long) management.getHandles().createLocal(management.FindDeadlocks(arg0, context.getMeta()));
    }

    @Override
    public final String generatedBy() {
        return "ManagementImpl";
    }

}

